/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.commons.crypto;

import com.ibm.bi.config.ConfigurationPropertyFactory;
import com.ibm.bi.platform.commons.crypto.CAMCryptoException;
import com.ibm.bi.platform.commons.crypto.JCAMCryptoConfiguration;
import com.ibm.bi.platform.commons.crypto.JCAMCryptoConfigurationProvider;
import com.ibm.bi.platform.commons.crypto.api.CAMKeyPair;
import com.ibm.bi.platform.commons.crypto.api.StreamCipherSession;
import com.ibm.bi.platform.commons.crypto.internal.keystore.KeyDistributor;
import com.ibm.bi.platform.commons.crypto.internal.session.EncryptingSession;
import com.ibm.bi.platform.commons.crypto.internal.session.HMACSession;
import com.ibm.bi.platform.commons.crypto.internal.session.JavaKeyStoreSession;
import com.ibm.bi.platform.commons.crypto.internal.session.SystemKeyCryptoSession;
import com.ibm.bi.platform.commons.crypto.internal.session.TrustedRequestSession;
import com.ibm.bi.platform.commons.crypto.internal.utils.CipherSuiteManager;
import com.ibm.bi.platform.commons.crypto.internal.utils.JVMEnvironment;
import com.ibm.bi.platform.commons.crypto.internal.utils.JcaFactory;
import com.ibm.bi.platform.commons.crypto.internal.utils.SSLProtocolManager;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.StrictHostnameVerifier;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.ssl.PrivateKeyDetails;
import org.apache.http.ssl.PrivateKeyStrategy;
import org.apache.http.ssl.SSLContexts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JCAMCrypto {
    private static final int CAM_PASSWORD_LENGTH = 16;
    private static final Logger LOGGER = LoggerFactory.getLogger(JCAMCrypto.class);
    private static boolean initialized = false;

    private JCAMCrypto() {
    }

    private static void init() {
        if (initialized) {
            return;
        }
        JCAMCrypto.configureJVMTrustStorePassword();
        JCAMCrypto.traceAndLogConfiguration();
        initialized = true;
    }

    public static EncryptingSession createEncryptingSession() throws CAMCryptoException {
        LOGGER.trace("createEncryptingSession entering");
        JCAMCrypto.init();
        EncryptingSession es = new EncryptingSession();
        LOGGER.trace("createEncryptingSession returning");
        return es;
    }

    public static TrustedRequestSession createTrustedRequestSession() throws CAMCryptoException {
        LOGGER.trace("createEncryptingSession entering");
        JCAMCrypto.init();
        TrustedRequestSession trs = new TrustedRequestSession();
        LOGGER.trace("createEncryptingSession returning");
        return trs;
    }

    public static HMACSession createHMACSession() throws CAMCryptoException {
        LOGGER.trace("createHMACSession entering");
        JCAMCrypto.init();
        HMACSession hmacSession = new HMACSession();
        LOGGER.trace("createHMACSession returning");
        return hmacSession;
    }

    public static JavaKeyStoreSession createJavaKeyStoreSession() throws CAMCryptoException {
        LOGGER.trace("createJavaKeyStoreSession entering");
        JCAMCrypto.init();
        JavaKeyStoreSession jks = new JavaKeyStoreSession();
        LOGGER.trace("createJavaKeyStoreSession returning");
        return jks;
    }

    public static SSLConnectionSocketFactory getSSLConnectionSocketFactory() {
        JCAMCrypto.init();
        SSLConnectionSocketFactory sslsf = null;
        try {
            SSLContext sslcontext = JCAMCrypto.createSSLContext();
            String advancedProperties = ConfigurationPropertyFactory.getInstance().getStringProperty("advancedProperties", "").getValue();
            LOGGER.trace("advancedProperties configuration: " + advancedProperties);
            String enableSSLHostnameVerification = JCAMCrypto.getAdvancedPropertyValue(advancedProperties, "EnableSSLHostnameVerification");
            LOGGER.trace("EnableSSLHostnameVerification = " + enableSSLHostnameVerification);
            if (enableSSLHostnameVerification.compareToIgnoreCase("false") == 0 || enableSSLHostnameVerification.compareToIgnoreCase("no") == 0) {
                sslsf = new SSLConnectionSocketFactory(sslcontext, JCAMCrypto.getSupportedProtocols(), JCAMCrypto.getSupportedCipherSuites(sslcontext), (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
                LOGGER.trace("hostnameVerifier = NoopHostnameVerifier.INSTANCE");
            } else {
                sslsf = new SSLConnectionSocketFactory(sslcontext, JCAMCrypto.getSupportedProtocols(), JCAMCrypto.getSupportedCipherSuites(sslcontext), (X509HostnameVerifier)StrictHostnameVerifier.INSTANCE);
                LOGGER.trace("hostnameVerifier = StrictHostnameVerifier.INSTANCE");
            }
        }
        catch (CAMCryptoException | JcaFactory.CouldNotGetInstanceException | IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e1) {
            LOGGER.trace("Setting up SSL connection socket factory failed: " + e1.toString());
        }
        return sslsf;
    }

    public static String[] getSupportedProtocols() {
        JCAMCrypto.init();
        Object[] protocols = SSLProtocolManager.getSSLProtocols();
        if (null == protocols || 0 == protocols.length) {
            LOGGER.error("Failed to get SSL protocol from configuration provider");
        } else {
            String p = Arrays.toString(protocols);
            LOGGER.trace("SSL protocol is configured to: " + p);
        }
        return protocols;
    }

    public static String[] getSupportedCipherSuites(SSLContext sslcontext) {
        JCAMCrypto.init();
        String[] cipherSuites = JCAMCryptoConfiguration.getProvider().getJSSECiphersuites();
        if (cipherSuites == null) {
            cipherSuites = CipherSuiteManager.getInstance().getCipherSuites(sslcontext);
        }
        return cipherSuites;
    }

    public static SSLContext getSSLContext() {
        JCAMCrypto.init();
        SSLContext sslcontext = null;
        try {
            sslcontext = JCAMCrypto.createSSLContext();
        }
        catch (CAMCryptoException | JcaFactory.CouldNotGetInstanceException | IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e1) {
            LOGGER.trace("Setting up SSL context failed: " + e1.toString());
        }
        return sslcontext;
    }

    public static String createPassword() throws CAMCryptoException {
        JCAMCrypto.init();
        String characters = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJLMNOPQRSTUVWXYZ1234567890!@#$%^&*()_+";
        StringBuilder result = new StringBuilder(16);
        SecureRandom secureRandom = JVMEnvironment.getInstance().getSecureRandom();
        for (int length = 16; length > 0; --length) {
            result.append("abcdefghijklmnopqrstuvwxyzABCDEFGHIJLMNOPQRSTUVWXYZ1234567890!@#$%^&*()_+".charAt(secureRandom.nextInt("abcdefghijklmnopqrstuvwxyzABCDEFGHIJLMNOPQRSTUVWXYZ1234567890!@#$%^&*()_+".length())));
        }
        return result.toString();
    }

    static SSLContext createSSLContext() throws CAMCryptoException, KeyStoreException, CertificateException, KeyManagementException, NoSuchAlgorithmException, IOException, UnrecoverableKeyException, JcaFactory.CouldNotGetInstanceException {
        JCAMCrypto.init();
        String camKeystore = JCAMCryptoConfiguration.getProvider().getCamKeystoreFile();
        String camKeystorePwd = JCAMCryptoConfiguration.getProvider().getCamKeystorePwdPlaintext();
        if (camKeystorePwd == null) {
            camKeystorePwd = JCAMCryptoConfiguration.getProvider().getCamKeystorePwdCiphertext();
            byte[] decryptBytes = SystemKeyCryptoSession.decryptData(camKeystorePwd.getBytes(), JVMEnvironment.getInstance());
            camKeystorePwd = new String(decryptBytes, "UTF-8");
        }
        KeyStore keystore = JcaFactory.getInstance(KeyStore.class, "JKS");
        try (FileInputStream inStrm = new FileInputStream(camKeystore);){
            keystore.load(inStrm, camKeystorePwd.toCharArray());
        }
        return SSLContexts.custom().loadTrustMaterial(keystore, null).loadKeyMaterial(keystore, camKeystorePwd.toCharArray(), new PrivateKeyStrategy(){

            @Override
            public String chooseAlias(Map<String, PrivateKeyDetails> alias, Socket socket) {
                return "encryption";
            }
        }).build();
    }

    public static CAMKeyPair keyPairFromKeyDistributor(String algorithm) throws CAMCryptoException {
        JCAMCrypto.init();
        return KeyDistributor.getInstance().getKeyPair(algorithm);
    }

    static void configureJVMTrustStorePassword() {
        LOGGER.info("Start configuration of JVM trust store password");
        String encryptedJVMTrustStorePassword = JCAMCryptoConfiguration.getProvider().getJVMTrustStorePassword();
        if (encryptedJVMTrustStorePassword == null) {
            LOGGER.error("Failed to get password of JVM trust store");
            return;
        }
        String jvmTrustStorePassword = null;
        try {
            byte[] decryptBytes = SystemKeyCryptoSession.decryptData(encryptedJVMTrustStorePassword.getBytes(), JVMEnvironment.getInstance());
            jvmTrustStorePassword = new String(decryptBytes, "UTF-8");
        }
        catch (Exception e) {
            LOGGER.error("Failed to decrypt password of JVM trust store. Exception: " + e.toString());
            return;
        }
        if (0 != jvmTrustStorePassword.length()) {
            LOGGER.info("Set password of JVM trust store " + jvmTrustStorePassword);
            System.setProperty("javax.net.ssl.trustStorePassword", jvmTrustStorePassword);
        }
        LOGGER.info("Completed configuration of JVM trust store password");
    }

    public static StreamCipherSession streamCipherSession() {
        return StreamCipherSession.INSTANCE;
    }

    static void traceAndLogConfiguration() {
        String prefix = "Cryptography configuration: ";
        JCAMCryptoConfigurationProvider jcamCryptoConfiguraitonProvider = JCAMCryptoConfiguration.getProvider();
        if (jcamCryptoConfiguraitonProvider == null) {
            LOGGER.error("Failed at loading jcamCryptoConfigurationProvider");
            return;
        }
        String jcamCryptoConfigurationProviderClassName = jcamCryptoConfiguraitonProvider.getClass().getName();
        LOGGER.debug(prefix + "JCAMCryptoConfigurationProvider = " + jcamCryptoConfigurationProviderClassName);
        String cryptoProvider = jcamCryptoConfiguraitonProvider.getCryptoProvider();
        LOGGER.debug(prefix + "cryptoProvider = " + cryptoProvider);
        String camKeystoreFile = jcamCryptoConfiguraitonProvider.getCamKeystoreFile();
        LOGGER.debug(prefix + "camKeystoreFile = " + camKeystoreFile);
        String confidentialityAlgorithm = jcamCryptoConfiguraitonProvider.getConfidentialityAlgorithm();
        LOGGER.debug(prefix + "confidentialityAlgorithm = " + confidentialityAlgorithm);
        String pdfEncryptionAlgorithm = jcamCryptoConfiguraitonProvider.getPDFEncryptionAlgorithm();
        LOGGER.debug(prefix + "pdfEncryptionAlgorithm = " + pdfEncryptionAlgorithm);
        String digestAlgorithm = jcamCryptoConfiguraitonProvider.getDigestAlgorithm();
        LOGGER.debug(prefix + "digestAlgorithm = " + digestAlgorithm);
        String ciphersuites = jcamCryptoConfiguraitonProvider.getCognosCryptoCiphersuite();
        LOGGER.debug(prefix + "ciphersuites = " + ciphersuites);
        boolean sslConfidentiality = jcamCryptoConfiguraitonProvider.getSSLConfidentiality();
        LOGGER.debug(prefix + "sslConfidentiality = " + sslConfidentiality);
        boolean useMutualAuthentication = jcamCryptoConfiguraitonProvider.useMutualAuthentication();
        LOGGER.debug(prefix + "useMutualAuthentication = " + useMutualAuthentication);
        String[] sslProtocols = jcamCryptoConfiguraitonProvider.getSSLProtocols();
        LOGGER.debug(prefix + "sslProtocols = " + sslProtocols);
        String[] jsseCipherSuites = jcamCryptoConfiguraitonProvider.getJSSECiphersuites();
        LOGGER.debug(prefix + "jsseCipherSuites = " + jsseCipherSuites);
        String tempFileLocation = jcamCryptoConfiguraitonProvider.getTempFileLocation();
        LOGGER.debug(prefix + "tempFileLocation = " + tempFileLocation);
        String internalDispatcher = jcamCryptoConfiguraitonProvider.getInternalDispatcher();
        LOGGER.debug(prefix + "internalDispatcher = " + internalDispatcher);
        String externalDispatcher = jcamCryptoConfiguraitonProvider.getExternalDispatcher();
        LOGGER.debug(prefix + "externalDispatcher = " + externalDispatcher);
    }

    protected static String getAdvancedPropertyValue(String advancedProperties, String advancePropertyName) {
        String textValue = "";
        if (StringUtils.isBlank(advancedProperties)) {
            return textValue;
        }
        Element rootElement = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(advancedProperties.getBytes());
            Document document = builder.parse(inputStream);
            rootElement = document.getDocumentElement();
        }
        catch (Exception e) {
            LOGGER.debug("Failed at parsing advanced properties XML: " + advancedProperties + ". Exception: " + e.getMessage());
        }
        if (rootElement != null) {
            NodeList properties = rootElement.getElementsByTagName("crn:parameter");
            Node property = null;
            int count = properties.getLength();
            for (int i = 0; i < count; ++i) {
                property = properties.item(i);
                String nameAttributeValue = property.getAttributes().getNamedItem("name").getNodeValue();
                if (nameAttributeValue.compareToIgnoreCase(advancePropertyName) != 0) continue;
                textValue = property.getTextContent().replaceAll("\\s", "");
                break;
            }
        }
        return textValue;
    }
}

