/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.commons.crypto.internal.session;

import com.ibm.bi.platform.commons.crypto.CAMCryptoException;
import com.ibm.bi.platform.commons.crypto.JCAMCryptoConfiguration;
import com.ibm.bi.platform.commons.crypto.internal.keystore.CAMCskKs;
import com.ibm.bi.platform.commons.crypto.internal.session.Token;
import com.ibm.bi.platform.commons.crypto.internal.utils.JcaFactory;
import com.ibm.bi.platform.commons.crypto.internal.utils.MacWithCskPool;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.security.InvalidKeyException;
import java.util.Arrays;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HMACSession
extends Token {
    private static final Logger LOGGER = LoggerFactory.getLogger(HMACSession.class);
    private CAMCskKs camCskKs = null;
    private static final int VERSION_1 = 1;
    private static final byte VERSION2 = 2;
    public static final int INT_ARRAY_LENGTH = 4;
    private int version;
    private byte[] cskAlias;
    private byte[] hmacAlgorithm;
    private byte[] hmac;

    public String protectData(byte[] data) throws CAMCryptoException {
        LOGGER.trace("Start HMAC protectData");
        if (!this.loadCAMCskKs()) {
            LOGGER.error("Not able to load CSK keystore for generating HMAC token");
            return null;
        }
        this.cskAlias = this.camCskKs.getCurrentCSKAlias();
        this.hmacAlgorithm = JCAMCryptoConfiguration.getProvider().getHMACAlgorithm().getBytes();
        LOGGER.trace("Start generating HMAC token");
        byte[] hmacBytes = this.calculateHMAC(data);
        if (hmacBytes == null) {
            LOGGER.error("Failed at calculating HMAC");
            return null;
        }
        this.hmac = hmacBytes;
        byte[] binaryToken = null;
        try {
            binaryToken = this.writeToken();
        }
        catch (CAMCryptoException e) {
            LOGGER.error("Failed at writing token. Exception: " + e.getMessage());
            return null;
        }
        String b64HMACToken = new String(Base64.encodeBase64(binaryToken));
        LOGGER.trace("HMAC protectData completed. The input data (lentgh = " + data.length + ") is protected by HMAC token: " + b64HMACToken);
        return b64HMACToken;
    }

    public boolean verifyData(byte[] data, String b64HMACToken) throws CAMCryptoException {
        LOGGER.trace("Start HMAC verifyData, input data length = " + data.length + ", HMAC token: " + b64HMACToken);
        if (b64HMACToken == null || b64HMACToken.length() == 0) {
            return false;
        }
        byte[] binaryToken = Base64.decodeBase64(b64HMACToken);
        LOGGER.trace("Base64 decoded the input data");
        byte tokenVersion = binaryToken[0];
        if (tokenVersion == 1) {
            return this.verifyHMACToken1(data, binaryToken);
        }
        if (tokenVersion == 2) {
            return this.verifyHMACToken2(data, binaryToken);
        }
        LOGGER.error("Invalid HMAC token version");
        return false;
    }

    private boolean verifyHMACToken1(byte[] data, byte[] binaryToken) throws CAMCryptoException {
        try {
            this.readToken(binaryToken);
        }
        catch (CAMCryptoException e) {
            LOGGER.error("Failed at reading token. Exception: " + e.getMessage());
            return false;
        }
        LOGGER.trace("Start verifying HMAC token.");
        if (!this.loadCAMCskKs()) {
            LOGGER.error("Not able to load CSK keystore for verifying HMAC token");
            return false;
        }
        if (this.version != 1) {
            LOGGER.error("Invalid HMAC token version.");
            return false;
        }
        byte[] hmacBytes = this.calculateHMAC(data);
        if (!Arrays.equals(hmacBytes, this.hmac)) {
            LOGGER.error("Invalid HAMC token.");
            return false;
        }
        LOGGER.trace("HMAC verifyData completed");
        return true;
    }

    @Override
    public void writeToken(ByteArrayOutputStream out) throws CAMCryptoException {
        this.writeVersion(out, 1);
        this.writeByteArray(out, this.cskAlias);
        this.writeByteArray(out, this.hmacAlgorithm);
        this.writeByteArray(out, this.hmac);
    }

    @Override
    public void readToken(ByteArrayInputStream in) throws CAMCryptoException {
        this.version = this.readVersion(in);
        this.cskAlias = this.readByteArray(in);
        this.hmacAlgorithm = this.readByteArray(in);
        this.hmac = this.readByteArray(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] createHMACToken2(byte[] inputdata) throws CAMCryptoException {
        String mdAlgorithm = JCAMCryptoConfiguration.getProvider().getDigestAlgorithm();
        String hmacAlgorithm = "Hmac" + mdAlgorithm.replace("SHA-", "SHA");
        int algorithmLength = mdAlgorithm.length();
        int hmacVersion = 2;
        try {
            byte[] hmac;
            Mac mac;
            if (!this.loadCAMCskKs()) {
                LOGGER.error("Not able to load CSK keystore for generating HMAC token");
                return null;
            }
            SecretKey key = this.camCskKs.getCSK();
            byte[] cskDigest = this.camCskKs.getCSKAlias(key);
            int cskDigestLength = cskDigest.length;
            Mac mac2 = mac = MacWithCskPool.getInstance().getMacGivenCSKDigest(cskDigest, hmacAlgorithm);
            synchronized (mac2) {
                mac.update(inputdata);
                hmac = mac.doFinal();
            }
            int hmacLength = hmac.length;
            int sizeFieldLength = 4;
            int tokenLength = 1 + sizeFieldLength + cskDigestLength + sizeFieldLength + algorithmLength + sizeFieldLength + hmacLength;
            byte[] token = new byte[tokenLength];
            token[0] = (byte)(hmacVersion & 0xFF);
            int pos = 1;
            pos += this.addTokenField(token, pos, cskDigest);
            pos += this.addTokenField(token, pos, mdAlgorithm.getBytes());
            this.addTokenField(token, pos, hmac);
            LOGGER.trace("hmac token created length = " + token.length);
            return token;
        }
        catch (CAMCryptoException | JcaFactory.CouldNotGetInstanceException | InvalidKeyException e) {
            LOGGER.error("Failed at createHMACToken2. Exception: " + e.getMessage());
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean verifyHMACToken2(byte[] inputdata, byte[] token) throws CAMCryptoException {
        int sizeFieldLength = 4;
        int pos = 1;
        byte[] cskDigest = this.getTokenField(token, pos);
        String mdAlgorithm = new String(this.getTokenField(token, pos += sizeFieldLength + cskDigest.length));
        String hmacAlg = "Hmac" + mdAlgorithm.replace("SHA-", "SHA");
        byte[] hmac = this.getTokenField(token, pos += sizeFieldLength + mdAlgorithm.length());
        pos += sizeFieldLength + hmac.length;
        try {
            byte[] actualHmac;
            Mac mac;
            Mac mac2 = mac = MacWithCskPool.getInstance().getMacGivenCSKDigest(cskDigest, hmacAlg);
            synchronized (mac2) {
                mac.update(inputdata);
                actualHmac = mac.doFinal();
            }
            boolean hashesMatch = Arrays.equals(hmac, actualHmac);
            LOGGER.trace("hmac verified");
            return hashesMatch;
        }
        catch (CAMCryptoException | JcaFactory.CouldNotGetInstanceException | InvalidKeyException e) {
            LOGGER.trace("hmac verification vailed with exception: " + e.toString());
            return false;
        }
    }

    private boolean loadCAMCskKs() {
        if (this.camCskKs == null) {
            try {
                this.camCskKs = CAMCskKs.getInstance();
            }
            catch (CAMCryptoException e) {
                LOGGER.error("Not able to get CSK keystore instance. Exception: " + e.getMessage());
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] calculateHMAC(byte[] theData) {
        Mac mac = null;
        try {
            String alg = new String(this.hmacAlgorithm);
            mac = MacWithCskPool.getInstance().getMacGivenCSKDigest(this.cskAlias, alg);
        }
        catch (Exception e) {
            LOGGER.error("Failed at initializing MAC object with exception: " + e.getClass().getName() + ", message = " + e.getMessage());
            return null;
        }
        byte[] hmacBytes = null;
        try {
            Mac mac2 = mac;
            synchronized (mac2) {
                mac.update(theData);
                hmacBytes = mac.doFinal();
            }
        }
        catch (IllegalStateException e) {
            LOGGER.error("Failed at generating HMAC bytes. Exception: " + e.getMessage());
            return null;
        }
        return hmacBytes;
    }

    private int addTokenField(byte[] token, int pos, byte[] dataField) {
        int sizeFieldLength = 4;
        int ret = pos;
        int fieldDataLength = dataField.length;
        byte[] sizeByte = this.toByteArray(fieldDataLength);
        System.arraycopy(sizeByte, 0, token, ret, 4);
        System.arraycopy(dataField, 0, token, ret += 4, fieldDataLength);
        return (ret += fieldDataLength) - pos;
    }

    private byte[] getTokenField(byte[] token, int pos) {
        int sizeFieldLength = 4;
        byte[] lengthFieldBytes = new byte[4];
        System.arraycopy(token, pos, lengthFieldBytes, 0, 4);
        int fieldLength = this.toInt(lengthFieldBytes);
        if (fieldLength > token.length - pos - 4) {
            throw new IllegalArgumentException("field length lager than buffer");
        }
        byte[] fieldData = new byte[fieldLength];
        System.arraycopy(token, pos + 4, fieldData, 0, fieldLength);
        return fieldData;
    }

    private byte[] toByteArray(int intVal) {
        byte[] byteArray = new byte[4];
        this.toByteArray(intVal, byteArray, 0, 4);
        return byteArray;
    }

    private void toByteArray(int intVal, byte[] byteArray, int offset, int len) {
        int max = offset + len;
        for (int i = offset; i < max; ++i) {
            byteArray[i] = (byte)intVal;
            intVal >>>= 8;
        }
    }

    private int toInt(byte[] byteArray) {
        int val = 0;
        int len = 4;
        for (int i = len - 1; i >= 0; --i) {
            val <<= 8;
            val |= byteArray[i] & 0xFF;
        }
        return val;
    }
}

