/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.commons.crypto.internal.session;

import com.ibm.bi.platform.commons.crypto.CAMCryptoException;
import com.ibm.bi.platform.commons.crypto.JCAMCryptoConfiguration;
import com.ibm.bi.platform.commons.crypto.internal.keystore.CAMCskKs;
import com.ibm.bi.platform.commons.crypto.internal.session.Token;
import com.ibm.bi.platform.commons.crypto.internal.utils.MacWithCskPool;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import javax.crypto.Mac;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrustedRequestSession
extends Token {
    private static final Logger LOGGER = LoggerFactory.getLogger(TrustedRequestSession.class);
    private CAMCskKs camCskKs = null;
    private int timeout_millisecond = 300000;
    private static final int VERSION_1 = 1;
    private static final int VERSION_2 = 2;
    private static final int VERSION = 2;
    private int version;
    private Date timestamp;
    private byte[] serviceid;
    private byte[] cskAlias;
    private byte[] hmacAlgorithm;
    private byte[] hmac;
    private int version_test = 0;

    public String generateToken(String serviceid) throws CAMCryptoException {
        LOGGER.trace("generateToken called");
        if (!this.loadCAMCskKs()) {
            LOGGER.error("Not able to load CSK keystore");
            return null;
        }
        this.version = this.version_test != 0 ? this.version_test : 2;
        this.timestamp = this.getTimeoutDate(this.timeout_millisecond);
        this.serviceid = serviceid.getBytes();
        this.cskAlias = this.camCskKs.getCurrentCSKAlias();
        this.hmacAlgorithm = this.version == 1 ? "HmacSHA256".getBytes() : JCAMCryptoConfiguration.getProvider().getHMACAlgorithm().getBytes();
        byte[] hmacBytes = this.calculateHMAC();
        if (hmacBytes == null) {
            LOGGER.error("Failed at calculating HMAC");
            return null;
        }
        this.hmac = hmacBytes;
        byte[] binaryToken = null;
        try {
            binaryToken = this.writeToken();
        }
        catch (CAMCryptoException e) {
            LOGGER.error("Failed at writing token. Exception: " + e.getMessage());
            return null;
        }
        String base64Token = new String(Base64.encodeBase64(binaryToken));
        LOGGER.trace("generateToken completed");
        return base64Token;
    }

    public boolean verifyToken(String base64Token) throws CAMCryptoException {
        LOGGER.trace("verifyToken called");
        byte[] binaryToken = Base64.decodeBase64(base64Token);
        if (binaryToken == null || binaryToken.length == 0) {
            LOGGER.error("Token is not Base 64 encoded");
            return false;
        }
        if (!this.loadCAMCskKs()) {
            LOGGER.error("Not able to load CSK keystore");
            return false;
        }
        try {
            this.readToken(binaryToken);
        }
        catch (CAMCryptoException e) {
            LOGGER.error("Failed at reading token. Exception: " + e.getMessage());
            return false;
        }
        if (this.version != 1 && this.version != 2) {
            return false;
        }
        Date now = new Date();
        if (now.getTime() > this.timestamp.getTime()) {
            LOGGER.error("token is expired.");
            return false;
        }
        byte[] hmacBytes = this.calculateHMAC();
        if (!Arrays.equals(hmacBytes, this.hmac)) {
            LOGGER.error("invalid token.");
            return false;
        }
        LOGGER.trace("verifyToken completed");
        return true;
    }

    public String getServiceIDAndVerifyToken(String trustToken) throws CAMCryptoException {
        LOGGER.trace("getServiceIDAndVerifyToken called");
        String serviceIDString = null;
        boolean isTrusted = this.verifyToken(trustToken);
        if (isTrusted) {
            LOGGER.trace("Verified trustToken and return the server ID");
            serviceIDString = new String(this.serviceid);
        } else {
            LOGGER.error("Not return the server ID because not able to verify the trustToken");
        }
        LOGGER.trace("getServiceIDAndVerifyToken completed");
        return serviceIDString;
    }

    public void setTimeout(int timeout_millisecond) {
        this.timeout_millisecond = timeout_millisecond;
    }

    protected void setVersion(int version) {
        this.version_test = version;
    }

    @Override
    public void writeToken(ByteArrayOutputStream out) throws CAMCryptoException {
        this.writeVersion(out, this.version);
        this.writeTime(out, this.timestamp);
        this.writeByteArray(out, this.serviceid);
        this.writeByteArray(out, this.cskAlias);
        if (this.version > 1) {
            this.writeByteArray(out, this.hmacAlgorithm);
        }
        this.writeByteArray(out, this.hmac);
    }

    @Override
    public void readToken(ByteArrayInputStream in) throws CAMCryptoException {
        this.version = this.readVersion(in);
        if (this.version != 1 && this.version != 2) {
            return;
        }
        this.timestamp = this.readTime(in);
        this.serviceid = this.readByteArray(in);
        this.cskAlias = this.readByteArray(in);
        this.hmacAlgorithm = this.version == 1 ? "HmacSHA256".getBytes() : this.readByteArray(in);
        this.hmac = this.readByteArray(in);
    }

    private boolean loadCAMCskKs() {
        if (this.camCskKs == null) {
            try {
                this.camCskKs = CAMCskKs.getInstance();
            }
            catch (CAMCryptoException e) {
                LOGGER.error("Not able to get CSK keystore instance. Exception: " + e.getMessage());
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] calculateHMAC() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSSSSS");
        byte[] timestampBytes = sdf.format(this.timestamp).getBytes();
        Mac mac = null;
        try {
            String alg = new String(this.hmacAlgorithm);
            mac = MacWithCskPool.getInstance().getMacGivenCSKDigest(this.cskAlias, alg);
        }
        catch (Exception e) {
            LOGGER.error("Failed at initializing MAC object with exception: " + e.getClass().getName() + ", message = " + e.getMessage());
            return null;
        }
        byte[] hmacBytes = null;
        try {
            Mac mac2 = mac;
            synchronized (mac2) {
                mac.update(timestampBytes);
                mac.update(this.serviceid);
                mac.update(this.cskAlias);
                hmacBytes = mac.doFinal();
            }
        }
        catch (IllegalStateException e) {
            LOGGER.error("Failed at generating HMAC bytes. Exception: " + e.getMessage());
            return null;
        }
        return hmacBytes;
    }

    private Date getTimeoutDate(int timeout_millisecond) {
        Date now = new Date();
        long lNow = now.getTime();
        long timeoutTime = lNow + (long)timeout_millisecond;
        Date timeoutDate = new Date(timeoutTime);
        return timeoutDate;
    }
}

