/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.commons.crypto.internal.utils;

import com.ibm.bi.platform.commons.crypto.CAMCryptoException;
import com.ibm.bi.platform.commons.crypto.CamCryptoMessageKeys;
import com.ibm.bi.platform.commons.crypto.internal.utils.CAMLockFile;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileLockResource
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileLockResource.class);
    private final CAMLockFile lockFile;
    private final String lockFilePath;

    public FileLockResource(String lockFilePath) throws CAMCryptoException {
        this.lockFilePath = lockFilePath;
        try {
            this.lockFile = new CAMLockFile(lockFilePath);
            this.lockFile.lock();
            LOGGER.info("lock acquired on file {}", (Object)lockFilePath);
        }
        catch (IOException e) {
            throw new CAMCryptoException(e, CamCryptoMessageKeys.could_not_acquire_keystore_lock.buildMessage(lockFilePath));
        }
    }

    @Override
    public void close() throws CAMCryptoException {
        try {
            this.lockFile.unlock();
            LOGGER.info("file {} is unlocked", (Object)this.lockFilePath);
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (IOException e) {
            throw new CAMCryptoException(e, CamCryptoMessageKeys.could_not_unlock_keystore_lock.buildMessage(this.lockFilePath));
        }
    }
}

