/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.commons.crypto.internal.utils;

import com.ibm.bi.platform.commons.crypto.CAMCryptoException;
import com.ibm.bi.platform.commons.crypto.CamCryptoMessageKeys;
import com.ibm.bi.platform.commons.crypto.internal.utils.Constants;
import com.ibm.bi.platform.commons.crypto.internal.utils.JcaFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.ThreadLocalRandom;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.pkcs.Attribute;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.cert.CertIOException;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequest;
import org.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequestBuilder;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemReader;
import org.bouncycastle.util.io.pem.PemWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeysAndCertsGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(KeysAndCertsGenerator.class);

    public static X509Certificate signedCertificate(X509Certificate issuerCert, PrivateKey issuerPrivateKey, byte[] csrPkcs10PemEncoded, String signatureAlgorithm) throws CAMCryptoException {
        return KeysAndCertsGenerator.signedCertificate(issuerCert, issuerPrivateKey, csrPkcs10PemEncoded, signatureAlgorithm, Constants.CERTS_GENERATION_DEFAULT_START_DATE);
    }

    public static X509Certificate signedCertificate(X509Certificate issuerCert, PrivateKey issuerPrivateKey, byte[] csrPkcs10PemEncoded, String signatureAlgorithm, Date startDate) throws CAMCryptoException {
        try {
            return KeysAndCertsGenerator.signedCertificate(issuerCert, issuerPrivateKey, csrPkcs10PemEncoded, signatureAlgorithm, startDate, 30, false);
        }
        catch (CAMCryptoException e) {
            LOGGER.error("Exception occurred while generating a signed certificate", e);
            throw new CAMCryptoException(e, CamCryptoMessageKeys.could_not_sign_cert.buildMessage(issuerCert.getIssuerDN().toString(), "the provided CSR"));
        }
    }

    public static X509Certificate signedCertificate(X509Certificate issuerCert, PrivateKey issuerPrivateKey, byte[] csrPkcs10PemEncoded, String signatureAlgorithm, Date startDate, int daysBeforeItExpires, boolean isSubjectCA) throws CAMCryptoException {
        try {
            PemObject pemObject = new PemReader((Reader)new InputStreamReader(new ByteArrayInputStream(csrPkcs10PemEncoded))).readPemObject();
            JcaPKCS10CertificationRequest parsedCSR = new JcaPKCS10CertificationRequest(pemObject.getContent());
            parsedCSR.setProvider((Provider)new BouncyCastleProvider());
            X500Principal subjectPrincipal = new X500Principal(parsedCSR.getSubject().toASN1Primitive().getEncoded());
            PublicKey subjectPublicKey = parsedCSR.getPublicKey();
            Attribute[] csrExtensionRequest = parsedCSR.getAttributes(PKCSObjectIdentifiers.pkcs_9_at_extensionRequest);
            X500Principal issuerPrincipal = issuerCert.getSubjectX500Principal();
            return KeysAndCertsGenerator.signedCertificate(issuerPrincipal, subjectPrincipal, issuerPrivateKey, subjectPublicKey, signatureAlgorithm, startDate, daysBeforeItExpires, isSubjectCA, csrExtensionRequest);
        }
        catch (IOException | InvalidKeyException | NoSuchAlgorithmException | SignatureException | CertificateException | OperatorCreationException e) {
            LOGGER.error("Exception occurred while generating a signed certificate", e);
            throw new CAMCryptoException(e, CamCryptoMessageKeys.could_not_sign_cert.buildMessage(issuerCert.getIssuerDN().toString(), "the provided CSR"));
        }
    }

    public static X509Certificate signedCertificate(X500Principal issuerPrincipal, X500Principal subjectPrincipal, PrivateKey issuerPrivateKey, PublicKey subjectPublicKey, String signatureAlgorithm, Date startDate, int daysBeforeItExpires, boolean isSubjectCA, Attribute[] csrExtensionRequest) throws IOException, NoSuchAlgorithmException, SignatureException, InvalidKeyException, CertificateException, OperatorCreationException {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(startDate);
        calendar.add(5, daysBeforeItExpires);
        Date expiryDate = calendar.getTime();
        JcaX509v3CertificateBuilder x509V3CertificateBuilder = new JcaX509v3CertificateBuilder(issuerPrincipal, BigInteger.valueOf(ThreadLocalRandom.current().nextLong(Integer.MAX_VALUE)), startDate, expiryDate, subjectPrincipal, subjectPublicKey);
        x509V3CertificateBuilder = KeysAndCertsGenerator.withV3Extensions(x509V3CertificateBuilder, subjectPublicKey, isSubjectCA);
        if (csrExtensionRequest != null && csrExtensionRequest.length > 0) {
            x509V3CertificateBuilder = KeysAndCertsGenerator.withCsrExtensions(x509V3CertificateBuilder, csrExtensionRequest);
        }
        ContentSigner signer = new JcaContentSignerBuilder(signatureAlgorithm).build(issuerPrivateKey);
        X509CertificateHolder x509CertificateHolder = x509V3CertificateBuilder.build(signer);
        return new JcaX509CertificateConverter().getCertificate(x509CertificateHolder);
    }

    private static JcaX509v3CertificateBuilder withV3Extensions(JcaX509v3CertificateBuilder x509V3CertificateBuilder, PublicKey subjectPublicKey, boolean isSubjectCA) throws IOException, NoSuchAlgorithmException {
        x509V3CertificateBuilder.addExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(isSubjectCA));
        x509V3CertificateBuilder.addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)new JcaX509ExtensionUtils().createSubjectKeyIdentifier(subjectPublicKey));
        KeyUsage usage = new KeyUsage(182);
        x509V3CertificateBuilder.addExtension(Extension.keyUsage, false, (ASN1Encodable)usage);
        ASN1EncodableVector purposes = new ASN1EncodableVector();
        purposes.add((ASN1Encodable)KeyPurposeId.id_kp_serverAuth);
        purposes.add((ASN1Encodable)KeyPurposeId.id_kp_clientAuth);
        purposes.add((ASN1Encodable)KeyPurposeId.anyExtendedKeyUsage);
        x509V3CertificateBuilder.addExtension(Extension.extendedKeyUsage, false, (ASN1Encodable)new DERSequence(purposes));
        return x509V3CertificateBuilder;
    }

    private static JcaX509v3CertificateBuilder withCsrExtensions(JcaX509v3CertificateBuilder x509V3CertificateBuilder, Attribute[] attributes) throws CertIOException {
        for (Attribute attribute : attributes) {
            for (ASN1Encodable value : attribute.getAttributeValues()) {
                Extensions extensions = Extensions.getInstance((Object)value);
                for (ASN1ObjectIdentifier extensionOID : extensions.getExtensionOIDs()) {
                    x509V3CertificateBuilder.addExtension(extensions.getExtension(extensionOID));
                }
            }
        }
        return x509V3CertificateBuilder;
    }

    public static byte[] certificateRequestPkcs10PemEncoded(X500Principal subject, PrivateKey privateKey, PublicKey publicKey, String signatureAlgorithm) throws CAMCryptoException {
        return KeysAndCertsGenerator.certificateRequestPkcs10PemEncoded(subject, null, null, null, privateKey, publicKey, signatureAlgorithm);
    }

    public static byte[] certificateRequestPkcs10PemEncoded(X500Principal subject, String subjectAlternativeNameDnsNames, String subjectAlternativeNameIpAddresses, String subjectAlternativeNameEmailAddresses, PrivateKey privateKey, PublicKey publicKey, String signatureAlgorithm) throws CAMCryptoException {
        try {
            JcaPKCS10CertificationRequestBuilder certificationRequestBuilder = new JcaPKCS10CertificationRequestBuilder(new X500Name(subject.getName()), publicKey);
            certificationRequestBuilder = KeysAndCertsGenerator.withSubjectAlternativeNameExtension(certificationRequestBuilder, subjectAlternativeNameDnsNames, subjectAlternativeNameIpAddresses, subjectAlternativeNameEmailAddresses);
            ContentSigner signer = new JcaContentSignerBuilder(signatureAlgorithm).build(privateKey);
            PKCS10CertificationRequest certificationRequest = certificationRequestBuilder.build(signer);
            PemObject pemObject = new PemObject("CERTIFICATE REQUEST", certificationRequest.getEncoded());
            ByteArrayOutputStream pemBytesSink = new ByteArrayOutputStream();
            PemWriter pemWriter = new PemWriter((Writer)new OutputStreamWriter(pemBytesSink));
            pemWriter.writeObject(() -> pemObject);
            pemWriter.close();
            return pemBytesSink.toByteArray();
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("Exception occurred while generating a certificate request", e);
            throw new CAMCryptoException(e, CamCryptoMessageKeys.san_ip_address_format_error.buildMessage(e.getMessage()));
        }
        catch (IOException | OperatorCreationException e) {
            LOGGER.error("Exception occurred while generating a certificate request", e);
            throw new CAMCryptoException(e, CamCryptoMessageKeys.could_not_generate_csr.buildMessage(subject.getName()));
        }
    }

    private static JcaPKCS10CertificationRequestBuilder withSubjectAlternativeNameExtension(JcaPKCS10CertificationRequestBuilder certificationRequestBuilder, String subjectAlternativeNameDnsNames, String subjectAlternativeNameIpAddresses, String subjectAlternativeNameEmailAddresses) throws IOException {
        ArrayList sanExtensions = new ArrayList();
        if (subjectAlternativeNameIpAddresses != null) {
            Arrays.stream(subjectAlternativeNameIpAddresses.split(" ")).forEach(sanIpAddress -> {
                try {
                    sanExtensions.add(new GeneralName(7, sanIpAddress));
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException((String)sanIpAddress, e);
                }
            });
        }
        if (subjectAlternativeNameDnsNames != null) {
            Arrays.stream(subjectAlternativeNameDnsNames.split(" ")).forEach(sanDnsName -> sanExtensions.add(new GeneralName(2, sanDnsName)));
        }
        if (subjectAlternativeNameEmailAddresses != null) {
            Arrays.stream(subjectAlternativeNameEmailAddresses.split(" ")).forEach(sanEmailAddress -> sanExtensions.add(new GeneralName(1, sanEmailAddress)));
        }
        if (sanExtensions.size() > 0) {
            Extension sanExtension = new Extension(Extension.subjectAlternativeName, false, new GeneralNames(sanExtensions.toArray(new GeneralName[0])).getEncoded());
            certificationRequestBuilder.addAttribute(PKCSObjectIdentifiers.pkcs_9_at_extensionRequest, (ASN1Encodable)new Extensions(sanExtension));
        }
        return certificationRequestBuilder;
    }

    public static byte[] pemEncodedCertificateContent(Certificate certificate) throws CAMCryptoException {
        try {
            PemObject pemObject = new PemObject("CERTIFICATE", certificate.getEncoded());
            ByteArrayOutputStream pemBytesSink = new ByteArrayOutputStream();
            PemWriter pemWriter = new PemWriter((Writer)new OutputStreamWriter(pemBytesSink));
            pemWriter.writeObject(() -> pemObject);
            pemWriter.close();
            return pemBytesSink.toByteArray();
        }
        catch (IOException | CertificateEncodingException e) {
            LOGGER.error("Exception occurred while generating pem encoded certificate", e);
            throw new CAMCryptoException(e, CamCryptoMessageKeys.could_not_generate_pem_encoded_certificate.buildMessage());
        }
    }

    public static KeyPair newKeyPair(String algorithm, int keysize) throws CAMCryptoException {
        try {
            KeyPairGenerator keyPairGenerator = JcaFactory.getInstance(KeyPairGenerator.class, algorithm);
            keyPairGenerator.initialize(keysize);
            return keyPairGenerator.generateKeyPair();
        }
        catch (JcaFactory.CouldNotGetInstanceException e) {
            LOGGER.error("Exception occurred while generating a new keypair", e);
            throw new CAMCryptoException(CamCryptoMessageKeys.no_provider_available.buildMessage("KeyPairGenerator", algorithm));
        }
    }

    public static X509Certificate selfSignedCertificate(X500Principal principal, PrivateKey privateKey, PublicKey publicKey, String signatureAlgorithm, int daysBeforeItExpires) throws CAMCryptoException {
        return KeysAndCertsGenerator.selfSignedCertificate(principal, privateKey, publicKey, signatureAlgorithm, Constants.CERTS_GENERATION_DEFAULT_START_DATE, daysBeforeItExpires);
    }

    public static X509Certificate selfSignedCertificate(X500Principal principal, PrivateKey privateKey, PublicKey publicKey, String signatureAlgorithm, Date startDate, int daysBeforeItExpires) throws CAMCryptoException {
        try {
            return KeysAndCertsGenerator.signedCertificate(principal, principal, privateKey, publicKey, signatureAlgorithm, startDate, daysBeforeItExpires, true, null);
        }
        catch (IOException | InvalidKeyException | NoSuchAlgorithmException | SignatureException | CertificateException | OperatorCreationException e) {
            LOGGER.error("Exception occurred while generating a self-signed certificate", e);
            throw new CAMCryptoException(e, CamCryptoMessageKeys.could_not_generate_self_signed_cert.buildMessage(principal.getName()));
        }
    }
}

