/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.commons.crypto.internal.utils;

import com.ibm.bi.platform.commons.crypto.CAMCryptoException;
import com.ibm.bi.platform.commons.crypto.CamCryptoMessageKeys;
import com.ibm.bi.platform.commons.crypto.internal.utils.GenericUtils;
import com.ibm.bi.platform.commons.crypto.internal.utils.JcaFactory;
import com.ibm.bi.platform.commons.messages.Message;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.crypto.EncryptedPrivateKeyInfo;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.bouncycastle.util.io.pem.PemReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeysAndCertsLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(KeysAndCertsLoader.class);

    public static PrivateKey privateKeyFromPKCS12(InputStream keySource, String alias, char[] password, String cryptoAlgorithm) throws CAMCryptoException {
        Objects.requireNonNull(keySource);
        Objects.requireNonNull(alias);
        Objects.requireNonNull(cryptoAlgorithm);
        try {
            KeyStore pkcs12KeyStore = KeysAndCertsLoader.pkcs12KeyStore(keySource, password);
            return KeysAndCertsLoader.privateKeyFromKeyStore(pkcs12KeyStore, alias, password, cryptoAlgorithm);
        }
        catch (KeyStoreException e) {
            LOGGER.error("Exception occurred while loading private key from pkcs12", e);
            throw new CAMCryptoException(e, new Message(CamCryptoMessageKeys.could_not_load_keystore_general));
        }
        catch (UnrecoverableKeyException e) {
            LOGGER.error("Exception occurred while loading private key from pkcs12", e);
            throw new CAMCryptoException(e, new Message(CamCryptoMessageKeys.could_not_load_private_key_wrong_password));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            LOGGER.error("Exception occurred while loading private key from pkcs12", e);
            throw new CAMCryptoException(e, new Message(CamCryptoMessageKeys.could_not_load_private_key));
        }
    }

    private static KeyStore pkcs12KeyStore(InputStream keySource, char[] storePassword) throws CAMCryptoException {
        try {
            KeyStore pkcs12KeyStore = JcaFactory.getInstance(KeyStore.class, "PKCS12");
            pkcs12KeyStore.load(keySource, storePassword);
            return pkcs12KeyStore;
        }
        catch (JcaFactory.CouldNotGetInstanceException | IOException | NoSuchAlgorithmException | CertificateException e) {
            LOGGER.error("Exception occurred while loading a pkcs12 keystore", e);
            throw new CAMCryptoException(e, new Message(CamCryptoMessageKeys.could_not_load_keystore_general));
        }
    }

    private static PrivateKey privateKeyFromKeyStore(KeyStore pkcs12KeyStore, String alias, char[] password, String cryptoAlgorithm) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, InvalidKeyException, CAMCryptoException {
        PrivateKey privateKey = (PrivateKey)pkcs12KeyStore.getKey(alias, password);
        if (privateKey != null) {
            return KeysAndCertsLoader.validPrivateKeyIfPossible(privateKey, cryptoAlgorithm);
        }
        return null;
    }

    private static PrivateKey validPrivateKeyIfPossible(PrivateKey privateKey, String cryptoAlgorithm) throws InvalidKeyException, CAMCryptoException {
        try {
            KeyFactory keyFactory = JcaFactory.getInstance(KeyFactory.class, cryptoAlgorithm);
            return (PrivateKey)keyFactory.translateKey(privateKey);
        }
        catch (JcaFactory.CouldNotGetInstanceException e) {
            LOGGER.error("Exception occurred while translating a private key", e);
            throw new CAMCryptoException(e, new Message(CamCryptoMessageKeys.crypto_algorithm_not_supported, "KeyFactory", cryptoAlgorithm));
        }
    }

    public static PrivateKey privateKeyFromPKCS12(InputStream keySource, char[] password, String cryptoAlgorithm) throws CAMCryptoException {
        try {
            Objects.requireNonNull(keySource);
            Objects.requireNonNull(cryptoAlgorithm);
            KeyStore pkcs12KeyStore = KeysAndCertsLoader.pkcs12KeyStore(keySource, password);
            ArrayList<String> aliases = Collections.list(pkcs12KeyStore.aliases());
            if (aliases.size() == 1) {
                return KeysAndCertsLoader.privateKeyFromKeyStore(pkcs12KeyStore, (String)aliases.get(0), password, cryptoAlgorithm);
            }
            throw new CAMCryptoException(CamCryptoMessageKeys.specify_alias.buildMessage(aliases.stream().collect(Collectors.joining(","))));
        }
        catch (UnrecoverableKeyException e) {
            LOGGER.error("Exception occurred while loading private key from pkcs12", e);
            throw new CAMCryptoException(e, new Message(CamCryptoMessageKeys.could_not_load_private_key_wrong_password));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            LOGGER.error("Exception occurred while loading private key from pkcs12", e);
            throw new CAMCryptoException(e, new Message(CamCryptoMessageKeys.could_not_load_private_key));
        }
        catch (KeyStoreException e) {
            LOGGER.error("Exception occurred while loading private key from pkcs12", e);
            throw new CAMCryptoException(e, new Message(CamCryptoMessageKeys.could_not_load_keystore_general));
        }
    }

    public static PrivateKey privateKeyFromPEMEncodedPKCS8Encrypted(InputStream keySource, char[] password, String cryptoAlgorithm) throws CAMCryptoException {
        try {
            Objects.requireNonNull(keySource);
            Objects.requireNonNull(cryptoAlgorithm);
            PemReader pemReader = new PemReader((Reader)new InputStreamReader(keySource));
            EncryptedPrivateKeyInfo pkInfo = new EncryptedPrivateKeyInfo(pemReader.readPemObject().getContent());
            PBEKeySpec keySpec = new PBEKeySpec(password);
            SecretKeyFactory pbeKeyFactory = JcaFactory.getInstance(SecretKeyFactory.class, pkInfo.getAlgName());
            PKCS8EncodedKeySpec encodedKeySpec = pkInfo.getKeySpec(pbeKeyFactory.generateSecret(keySpec));
            KeyFactory keyFactory = JcaFactory.getInstance(KeyFactory.class, cryptoAlgorithm);
            PrivateKey encryptedPrivateKey = keyFactory.generatePrivate(encodedKeySpec);
            return encryptedPrivateKey;
        }
        catch (JcaFactory.CouldNotGetInstanceException | NoSuchAlgorithmException e) {
            LOGGER.error("Exception occurred while loading private key from pkcs8", e);
            throw new CAMCryptoException(e, new Message(CamCryptoMessageKeys.crypto_algorithm_not_supported, cryptoAlgorithm, "key factory"));
        }
        catch (IOException | InvalidKeySpecException e) {
            LOGGER.error("Exception occurred while loading private key from pkcs8", e);
            throw new CAMCryptoException(e, new Message(CamCryptoMessageKeys.could_not_load_private_key));
        }
        catch (InvalidKeyException e) {
            LOGGER.error("Exception occurred while loading private key from pkcs8", e);
            throw new CAMCryptoException(e, new Message(CamCryptoMessageKeys.could_not_load_private_key_wrong_password));
        }
    }

    public static X509Certificate certificateFromPemEncodedX509(InputStream certChainSource) throws CAMCryptoException {
        try {
            CertificateFactory certificateFactory = JcaFactory.getInstance(CertificateFactory.class, "X.509");
            return (X509Certificate)certificateFactory.generateCertificate(certChainSource);
        }
        catch (JcaFactory.CouldNotGetInstanceException | CertificateException e) {
            LOGGER.error("Exception occurred while loading certificate from pem encoded x509", e);
            throw new CAMCryptoException(e, new Message(CamCryptoMessageKeys.could_not_load_certificates));
        }
    }

    public static List<X509Certificate> certificatesFromPKCS12(InputStream certChainSource, String alias, char[] password) throws CAMCryptoException {
        try {
            KeyStore pkcs12KeyStore = KeysAndCertsLoader.pkcs12KeyStore(certChainSource, password);
            return KeysAndCertsLoader.loadX509CertsFromKeyStore(pkcs12KeyStore, alias);
        }
        catch (KeyStoreException e) {
            LOGGER.error("Exception occurred while loading certificates from pkcs12", e);
            throw new CAMCryptoException(e, new Message(CamCryptoMessageKeys.could_not_load_certificates));
        }
    }

    private static List<X509Certificate> loadX509CertsFromKeyStore(KeyStore pkcs12KeyStore, String alias) throws KeyStoreException {
        Certificate[] certificateChain = pkcs12KeyStore.getCertificateChain(alias);
        if (certificateChain != null) {
            return Arrays.stream(certificateChain).map(o -> (X509Certificate)o).collect(Collectors.toList());
        }
        return null;
    }

    public static List<X509Certificate> certificatesFromPKCS12(InputStream certChainSource, char[] password) throws CAMCryptoException {
        try {
            KeyStore pkcs12KeyStore = KeysAndCertsLoader.pkcs12KeyStore(certChainSource, password);
            ArrayList<String> aliases = Collections.list(pkcs12KeyStore.aliases());
            if (aliases.size() == 1) {
                return KeysAndCertsLoader.loadX509CertsFromKeyStore(pkcs12KeyStore, (String)aliases.get(0));
            }
            throw new CAMCryptoException(CamCryptoMessageKeys.specify_alias.buildMessage(aliases.stream().collect(Collectors.joining(","))));
        }
        catch (KeyStoreException e) {
            LOGGER.error("Exception occurred while loading certificates from pkcs12", e);
            throw new CAMCryptoException(e, new Message(CamCryptoMessageKeys.could_not_load_certificates));
        }
    }

    public static List<String> keyEntriesAliasesFromPKCS12(InputStream pkcs12Source, char[] password) throws CAMCryptoException {
        Objects.requireNonNull(pkcs12Source);
        try {
            KeyStore pkcs12KeyStore = KeysAndCertsLoader.pkcs12KeyStore(pkcs12Source, password);
            return Collections.list(pkcs12KeyStore.aliases()).stream().filter(alias -> {
                try {
                    return pkcs12KeyStore.isKeyEntry((String)alias);
                }
                catch (KeyStoreException e) {
                    return false;
                }
            }).collect(Collectors.toList());
        }
        catch (KeyStoreException e) {
            LOGGER.error("Exception occurred while loading aliases from pkcs12", e);
            throw new CAMCryptoException(e, CamCryptoMessageKeys.could_not_load_keystore_general.buildMessage());
        }
    }

    public static List<X509Certificate> tryToLoadCertificatesFromSimpleResource(InputStream certChainSource) throws CAMCryptoException {
        return (List)GenericUtils.firstSuccessfulResult(GenericUtils.throwingSupplierToSupplier(() -> KeysAndCertsLoader.certificatesFromPemEncodedX509(certChainSource)), GenericUtils.throwingSupplierToSupplier(() -> KeysAndCertsLoader.certificatesFromPemEncodedPKCS7(certChainSource))).orElseThrow(() -> new CAMCryptoException(CamCryptoMessageKeys.could_not_load_certificates.buildMessage()));
    }

    public static List<X509Certificate> certificatesFromPemEncodedX509(InputStream certChainSource) throws CAMCryptoException {
        return KeysAndCertsLoader.loadX509Certificates(certChainSource);
    }

    public static List<X509Certificate> certificatesFromPemEncodedPKCS7(InputStream certChainSource) throws CAMCryptoException {
        return KeysAndCertsLoader.loadX509Certificates(certChainSource);
    }

    private static List<X509Certificate> loadX509Certificates(InputStream certChainSource) throws CAMCryptoException {
        try {
            CertificateFactory certificateFactory = JcaFactory.getInstance(CertificateFactory.class, "X.509");
            return certificateFactory.generateCertificates(certChainSource).stream().map(o -> (X509Certificate)o).collect(Collectors.toList());
        }
        catch (JcaFactory.CouldNotGetInstanceException | CertificateException e) {
            LOGGER.error("Exception occurred while loading x509 certs", e);
            throw new CAMCryptoException(e, new Message(CamCryptoMessageKeys.could_not_load_certificates));
        }
    }
}

