/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.commons.crypto.internal.utils;

import com.ibm.bi.platform.commons.crypto.CAMCryptoException;
import com.ibm.bi.platform.commons.crypto.CamCryptoMessageKeys;
import com.ibm.bi.platform.commons.crypto.internal.keystore.CAMCskKs;
import com.ibm.bi.platform.commons.crypto.internal.utils.EncodedCSK;
import com.ibm.bi.platform.commons.crypto.internal.utils.JVMEnvironment;
import com.ibm.bi.platform.commons.messages.Message;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.EncryptedContentInfo;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.RC2CBCParameter;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class PKCS7EncryptedData {
    static final int CURRENT_CSK_PLAINTEXT_ENCODING_VERSION = 1;

    public static byte[] decode(byte[] data) throws CAMCryptoException {
        if (data.length > 0) {
            ASN1InputStream dis = null;
            try {
                dis = new ASN1InputStream((InputStream)new ByteArrayInputStream(data));
            }
            catch (IndexOutOfBoundsException e) {
                throw new CAMCryptoException(e, new Message(CamCryptoMessageKeys.could_not_decode_pkcs7_bad_data));
            }
            try {
                ASN1Primitive pkcs = dis.readObject();
                ContentInfo contentInfo = ContentInfo.getInstance((Object)pkcs);
                String ct = contentInfo.getContentType().getId();
                if (!ct.equals("1.2.840.113549.1.7.6")) {
                    throw new CAMCryptoException(new Message(CamCryptoMessageKeys.could_not_decode_pkcs7_invalid_type, ct));
                }
                DERSequence encDataWrapper = (DERSequence)contentInfo.getContent();
                if (!(encDataWrapper.getObjectAt(0) instanceof ASN1Integer)) {
                    throw new CAMCryptoException(new Message(CamCryptoMessageKeys.could_not_decode_pkcs7_data));
                }
                EncryptedContentInfo d = null;
                DERSequence encContentInfo = (DERSequence)encDataWrapper.getObjectAt(1);
                if (encContentInfo.size() == 2) {
                    ASN1Sequence algorithmIdentifierSequence = (ASN1Sequence)encContentInfo.getObjectAt(0);
                    ASN1ObjectIdentifier algorithmIdentifier_oid = (ASN1ObjectIdentifier)algorithmIdentifierSequence.getObjectAt(0);
                    ASN1Encodable algorithmIdentifier_params = algorithmIdentifierSequence.getObjectAt(1);
                    AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(algorithmIdentifier_oid, algorithmIdentifier_params);
                    DERTaggedObject encryptedContent_taggedObject = (DERTaggedObject)encContentInfo.getObjectAt(1);
                    DEROctetString encryptedContent = (DEROctetString)encryptedContent_taggedObject.getObject();
                    d = new EncryptedContentInfo(PKCSObjectIdentifiers.data, algorithmIdentifier, (ASN1OctetString)encryptedContent);
                } else {
                    d = EncryptedContentInfo.getInstance((Object)encContentInfo);
                }
                return PKCS7EncryptedData.getDecryptionResultUsingCSK(d);
            }
            catch (Exception e) {
                throw new CAMCryptoException(e, new Message(CamCryptoMessageKeys.could_not_decode_pkcs7_internal_error));
            }
        }
        throw new CAMCryptoException(new Message(CamCryptoMessageKeys.could_not_decode_pkcs7_no_data));
    }

    public static byte[] encode(byte[] plaintext) throws CAMCryptoException {
        try {
            SecretKey key = CAMCskKs.getInstance().getCSK();
            String alg = EncodedCSK.lookupAlg(key);
            String algOid = "";
            if (alg.equalsIgnoreCase("AES")) {
                alg = "AES/CBC/PKCS5Padding";
                int keySize = key.getEncoded().length * 8;
                if (keySize == 128) {
                    algOid = "2.16.840.1.101.3.4.1.2";
                } else if (keySize == 256) {
                    algOid = "2.16.840.1.101.3.4.1.42";
                } else {
                    throw new CAMCryptoException(new Message(CamCryptoMessageKeys.could_not_decode_pkcs7_invalid_alg, new String("key size = " + Integer.toString(keySize))));
                }
            }
            if (alg.equalsIgnoreCase("DES")) {
                alg = "DES/CBC/PKCS5Padding";
                algOid = "1.3.14.3.2.7";
            } else if (alg.equalsIgnoreCase("DESede")) {
                alg = "DESede/CBC/PKCS5Padding";
                algOid = "1.2.840.113549.3.7";
            } else if (alg.equalsIgnoreCase("RC2")) {
                alg = "RC2/CBC/PKCS5Padding";
                algOid = "1.2.840.113549.3.2";
            } else if (alg.equalsIgnoreCase("RC4")) {
                alg = "RC4";
                algOid = "1.2.840.113549.3.4";
            }
            String jceProvider = JVMEnvironment.getInstance().getJCEProvider();
            Cipher cipher = Cipher.getInstance(alg, jceProvider);
            cipher.init(1, key);
            EncryptedContentInfo data = PKCS7EncryptedData.generateUsingCSK(cipher, plaintext, algOid, key);
            ASN1EncodableVector encDataVector = new ASN1EncodableVector();
            encDataVector.add((ASN1Encodable)new ASN1Integer(BigInteger.ZERO));
            encDataVector.add((ASN1Encodable)data);
            DERSequence encDataWrapper = new DERSequence(encDataVector);
            ContentInfo contentInfo = new ContentInfo(new ASN1ObjectIdentifier("1.2.840.113549.1.7.6"), (ASN1Encodable)encDataWrapper);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DEROutputStream dos = new DEROutputStream((OutputStream)baos);
            dos.writeObject((ASN1Encodable)contentInfo);
            return baos.toByteArray();
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new CAMCryptoException(e, new Message(CamCryptoMessageKeys.could_not_decode_pkcs7_invalid_alg, "DES/CBC/PKCS5Padding"));
        }
        catch (Exception e) {
            throw new CAMCryptoException(e, new Message(CamCryptoMessageKeys.could_not_decode_pkcs7_internal_error));
        }
    }

    private static Cipher generateCipher(EncryptedContentInfo info, byte[] secretKeyBytes) throws CAMCryptoException {
        Cipher cipher;
        block16: {
            String algId = info.getContentEncryptionAlgorithm().getAlgorithm().getId();
            ASN1Encodable encodedParams = info.getContentEncryptionAlgorithm().getParameters();
            ASN1Primitive params = null;
            if (encodedParams != null) {
                params = encodedParams.toASN1Primitive();
            }
            try {
                String jceProvider = JVMEnvironment.getInstance().getJCEProvider();
                if (algId.equals("2.16.840.1.101.3.4.1.2") || algId.equals("2.16.840.1.101.3.4.1.42")) {
                    ASN1OctetString iv;
                    cipher = Cipher.getInstance("AES/CBC/PKCS5Padding", jceProvider);
                    SecretKeySpec key = new SecretKeySpec(secretKeyBytes, "AES");
                    try {
                        iv = (ASN1OctetString)params;
                    }
                    catch (ClassCastException cce) {
                        throw new CAMCryptoException(cce, new Message(CamCryptoMessageKeys.could_not_decode_pkcs7_data));
                    }
                    cipher.init(2, (Key)key, new IvParameterSpec(iv == null ? null : iv.getOctets()));
                    break block16;
                }
                if (algId.equals("1.2.840.113549.3.7")) {
                    ASN1OctetString iv;
                    cipher = Cipher.getInstance("DESede/CBC/PKCS5Padding", jceProvider);
                    SecretKeySpec key = new SecretKeySpec(secretKeyBytes, "DESede");
                    try {
                        iv = (ASN1OctetString)params;
                    }
                    catch (ClassCastException cce) {
                        throw new CAMCryptoException(cce, new Message(CamCryptoMessageKeys.could_not_decode_pkcs7_data));
                    }
                    cipher.init(2, (Key)key, new IvParameterSpec(iv == null ? null : iv.getOctets()));
                    break block16;
                }
                if (algId.equals("1.3.14.3.2.7")) {
                    ASN1OctetString iv;
                    cipher = Cipher.getInstance("DES/CBC/PKCS5Padding", jceProvider);
                    SecretKeySpec key = new SecretKeySpec(secretKeyBytes, "DES");
                    try {
                        iv = (ASN1OctetString)params;
                    }
                    catch (ClassCastException cce) {
                        throw new CAMCryptoException(cce, new Message(CamCryptoMessageKeys.could_not_decode_pkcs7_data));
                    }
                    cipher.init(2, (Key)key, new IvParameterSpec(iv == null ? null : iv.getOctets()));
                    break block16;
                }
                if (algId.equals("1.2.840.113549.3.2")) {
                    cipher = Cipher.getInstance("RC2/CBC/PKCS5Padding", jceProvider);
                    SecretKeySpec key = new SecretKeySpec(secretKeyBytes, "RC2");
                    RC2CBCParameter rc2Params = RC2CBCParameter.getInstance((Object)params);
                    int effectiveKeySize = key.getEncoded().length * 8;
                    cipher.init(2, (Key)key, new RC2ParameterSpec(effectiveKeySize, rc2Params.getIV()));
                    break block16;
                }
                if (algId.equals("1.2.840.113549.3.4")) {
                    cipher = Cipher.getInstance("RC4", jceProvider);
                    SecretKeySpec key = new SecretKeySpec(secretKeyBytes, "RC4");
                    cipher.init(2, key);
                    break block16;
                }
                throw new CAMCryptoException(new Message(CamCryptoMessageKeys.could_not_decode_pkcs7_invalid_alg, algId));
            }
            catch (InvalidAlgorithmParameterException e) {
                throw new CAMCryptoException(e, new Message(CamCryptoMessageKeys.could_not_decode_pkcs7_data));
            }
            catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
                throw new CAMCryptoException(e, new Message(CamCryptoMessageKeys.could_not_decode_pkcs7_invalid_alg, "RSA"));
            }
            catch (Exception e) {
                throw new CAMCryptoException(e, new Message(CamCryptoMessageKeys.could_not_decode_pkcs7_internal_error));
            }
        }
        return cipher;
    }

    private static EncryptedContentInfo generateUsingCSK(Cipher cipher, byte[] content, String algId, SecretKey csk) throws CAMCryptoException {
        DEROctetString ec;
        ASN1Primitive params = null;
        try {
            AlgorithmParameters algParams = cipher.getParameters();
            if (algParams != null) {
                byte[] encodedParams = algParams.getEncoded("ASN.1");
                ByteArrayInputStream baos = new ByteArrayInputStream(encodedParams);
                ASN1InputStream dis = new ASN1InputStream((InputStream)baos);
                params = dis.readObject();
            }
        }
        catch (IOException e) {
            throw new CAMCryptoException(e, new Message(CamCryptoMessageKeys.could_not_decode_pkcs7_internal_error));
        }
        ASN1ObjectIdentifier contentType = new ASN1ObjectIdentifier("1.2.840.113549.1.7.1");
        AlgorithmIdentifier cea = params != null ? new AlgorithmIdentifier(new ASN1ObjectIdentifier(algId), params) : new AlgorithmIdentifier(new ASN1ObjectIdentifier(algId));
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] ptheader = new byte[]{0, 67, 65, 77, 0};
            baos.write(ptheader);
            baos.write(1);
            int randomdatalen = cipher.getBlockSize() > 0 ? cipher.getBlockSize() : 8;
            baos.write((byte)randomdatalen);
            SecureRandom random = JVMEnvironment.getInstance().getSecureRandom();
            byte[] randbytes = new byte[randomdatalen];
            random.nextBytes(randbytes);
            baos.write(randbytes);
            baos.write(content);
            byte[] cskHash = CAMCskKs.getInstance().getCSKAlias(csk);
            byte[] encContent = cipher.doFinal(baos.toByteArray());
            try {
                baos = new ByteArrayOutputStream();
                baos.write(cskHash);
                baos.write(encContent);
            }
            catch (IOException e) {
                throw new CAMCryptoException(e, new Message(CamCryptoMessageKeys.could_not_decode_pkcs7_internal_error));
            }
            ec = new DEROctetString(baos.toByteArray());
        }
        catch (Exception e) {
            throw new CAMCryptoException(e, new Message(CamCryptoMessageKeys.could_not_decode_pkcs7_internal_error));
        }
        return new EncryptedContentInfo(contentType, cea, (ASN1OctetString)ec);
    }

    private static byte[] getDecryptionResultUsingCSK(EncryptedContentInfo info) throws CAMCryptoException {
        byte[] decryptedData;
        byte[] contentOnly;
        byte[] cskDigestOnly;
        int digestLen = CAMCskKs.getInstance().getCSKAliasLength();
        byte[] encrContent = info.getEncryptedContent().getOctets();
        ByteArrayInputStream bais = new ByteArrayInputStream(encrContent);
        try {
            cskDigestOnly = new byte[digestLen];
            bais.read(cskDigestOnly, 0, digestLen);
            contentOnly = new byte[encrContent.length - digestLen];
            bais.read(contentOnly);
        }
        catch (IOException e) {
            throw new CAMCryptoException(e, new Message(CamCryptoMessageKeys.could_not_decode_pkcs7_internal_error));
        }
        SecretKey csk = CAMCskKs.getInstance().getCSK(cskDigestOnly);
        Cipher cipher = PKCS7EncryptedData.generateCipher(info, csk.getEncoded());
        try {
            decryptedData = cipher.doFinal(contentOnly);
        }
        catch (Exception e) {
            throw new CAMCryptoException(e, new Message(CamCryptoMessageKeys.could_not_decode_pkcs7_data));
        }
        byte[] ptheader = new byte[]{0, 67, 65, 77, 0};
        boolean match = true;
        if (decryptedData.length != 0) {
            for (int i = 0; i < ptheader.length; ++i) {
                if (decryptedData[i] == ptheader[i]) continue;
                match = false;
                break;
            }
        } else {
            match = false;
        }
        if (match) {
            byte randomdatalen;
            byte version;
            int pos = ptheader.length;
            if ((version = decryptedData[pos++]) > 1) {
                throw new CAMCryptoException(new Message(CamCryptoMessageKeys.could_not_decode_pkcs7_plaintext_version));
            }
            if ((randomdatalen = decryptedData[pos++]) > 0 && randomdatalen < 32) {
                int nonplaintextpartlen = 7 + randomdatalen;
                int plaintextlen = decryptedData.length - nonplaintextpartlen;
                byte[] actualplaintext = new byte[plaintextlen];
                System.arraycopy(decryptedData, nonplaintextpartlen, actualplaintext, 0, plaintextlen);
                decryptedData = actualplaintext;
            } else {
                throw new CAMCryptoException(new Message(CamCryptoMessageKeys.could_not_decode_pkcs7_internal_error));
            }
        }
        return decryptedData;
    }
}

