/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.commons.shared;

import com.ibm.bi.platform.commons.http.util.LocalAddresses;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebFilter(urlPatterns={"/*"})
public class BIBlockingFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(BIBlockingFilter.class);
    private boolean enabled = true;

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req;
        if (request instanceof HttpServletRequest && this.blockedRequest(req = (HttpServletRequest)request)) {
            ((HttpServletResponse)response).setStatus(403);
            ((HttpServletResponse)response).setHeader("x-bi-blocking", "blocked");
            LOGGER.info("Blocked call to {} from {}", (Object)req.getRequestURI(), (Object)req.getRemoteAddr());
            return;
        }
        chain.doFilter(request, response);
    }

    boolean blockedRequest(HttpServletRequest req) {
        if (!this.enabled) {
            return false;
        }
        String contextPath = req.getContextPath();
        if (contextPath.startsWith("/bi") || contextPath.startsWith("/flipper-service")) {
            return false;
        }
        if (contextPath.startsWith("/dataset-service")) {
            return false;
        }
        if (StringUtils.startsWith(req.getPathInfo(), "/api-docs")) {
            return !this.getDocsProp();
        }
        if (req.getHeader("X-CA-Proxy") != null) {
            return false;
        }
        if ("localhost".equalsIgnoreCase(req.getServerName())) {
            return false;
        }
        if (LocalAddresses.isLocal(req.getRemoteAddr())) {
            return false;
        }
        return !StringUtils.startsWith(req.getPathInfo(), "/health");
    }

    boolean getDocsProp() {
        LOGGER.debug("system property api-docs {}", (Object)Boolean.getBoolean("api-docs"));
        return Boolean.getBoolean("api-docs");
    }

    boolean disabled() {
        LOGGER.debug("system property disable-blocking-filter {}", (Object)Boolean.getBoolean("disable-blocking-filter"));
        return Boolean.getBoolean("disable-blocking-filter");
    }

    private boolean hasBIContext(FilterConfig config) {
        ServletContext context = config.getServletContext();
        return context != null && context.getContext("/bi") != null;
    }

    public void init(FilterConfig config) throws ServletException {
        String context = this.getContext(config);
        boolean bl = this.enabled = !this.disabled() && this.hasBIContext(config);
        if (this.enabled) {
            try (InputStream in = this.getClass().getClassLoader().getResourceAsStream("config.properties");){
                if (in != null) {
                    Properties props = new Properties();
                    props.load(in);
                    this.enabled = !Boolean.TRUE.equals(Boolean.parseBoolean(props.getProperty("disable-blocking-filter")));
                    LOGGER.debug("{} disable-blocking-filter={}", (Object)context, (Object)props.getProperty("disable-blocking-filter"));
                } else {
                    LOGGER.info("{} No properties file found", (Object)context);
                }
            }
            catch (IOException e) {
                LOGGER.warn("{} Error loading properties file: {}", (Object)context, (Object)e.getMessage());
            }
        }
        if (!this.enabled) {
            LOGGER.info("{} BIBlockingFilter disabled.", (Object)context);
        }
        LOGGER.info("{} BIBlockingFilter initialized.", (Object)context);
    }

    String getContext(FilterConfig config) {
        return config.getServletContext().getContextPath();
    }

    boolean isEnabled() {
        return this.enabled;
    }
}

