/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.commons.shared;

import com.ibm.bi.json.JsonObject;
import com.ibm.bi.json.JsonParser;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Base64;
import java.util.HashSet;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserPreferences
extends JsonObject {
    private static final long serialVersionUID = -6933379781976426986L;
    public static final String USER_PREFS_COOKIE_NAME = "up";
    private static final Logger LOGGER = LoggerFactory.getLogger(UserPreferences.class);
    private static final String PRODUCTLOCALE_PROPERTY = "productLocale";
    private static final String CONTENTLOCALE_PROPERTY = "contentLocale";
    private static final String DISPLAYNAME_PROPERTY = "defaultName";
    private static final String USERNAME_PROPERTY = "userName";
    private static HashSet<String> ignoreNames = new HashSet();

    public UserPreferences() {
    }

    public UserPreferences(String cookieString) {
        try (InputStream in = this.expandCookieString(cookieString);
             InputStreamReader sr = new InputStreamReader(in);){
            this.putAll((JsonObject)new JsonParser().parse(sr));
        }
        catch (IOException e) {
            LOGGER.error("Failed to parse preferences cookie: {}", (Object)cookieString);
            LOGGER.debug("Failed to parse preferences cookie.", e);
        }
    }

    public UserPreferences(JsonObject other) {
        this.putAll(other);
    }

    public void putAll(JsonObject jsonObj) {
        for (Map.Entry entry : jsonObj.entrySet()) {
            this.put((String)entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Object put(String key, Object value) {
        if (!ignoreNames.contains(key)) {
            return super.put(key, value);
        }
        return null;
    }

    public String getPreference(String name) {
        return (String)this.get(name);
    }

    public String getProductLocale() {
        return (String)this.get(PRODUCTLOCALE_PROPERTY);
    }

    public String getContentLocale() {
        return (String)this.get(CONTENTLOCALE_PROPERTY);
    }

    public String getUserDisplayName() {
        return (String)this.get(DISPLAYNAME_PROPERTY);
    }

    public String getUserName() {
        return (String)this.get(USERNAME_PROPERTY);
    }

    public String cookieValue() throws IOException {
        return this.compressCookieString(this.toString());
    }

    protected InputStream expandCookieString(String cookieString) throws IOException {
        try {
            byte[] bytes = Base64.getDecoder().decode(cookieString);
            return new GZIPInputStream(new ByteArrayInputStream(bytes));
        }
        catch (IllegalArgumentException e) {
            LOGGER.warn("Invalid preferences cookie ({}) : {}", (Object)cookieString, (Object)e.getMessage());
            throw new IOException(e);
        }
    }

    protected String compressCookieString(String cookieString) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (GZIPOutputStream compressor = new GZIPOutputStream(baos);){
            IOUtils.write(cookieString, (OutputStream)compressor);
        }
        return new String(Base64.getEncoder().encode(baos.toByteArray()), "UTF-8");
    }

    static {
        ignoreNames.add("linesPerPage");
        ignoreNames.add("listViewSeparator");
        ignoreNames.add("showWelcomePage");
        ignoreNames.add("displayMode");
        ignoreNames.add("showOptionSummary");
        ignoreNames.add("automaticPageRefresh");
        ignoreNames.add("columnsPerPage");
        ignoreNames.add("_meta");
    }
}

