/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.rest;

import com.ibm.bi.platform.commons.http.BaseHttpClientConfig;
import java.net.HttpCookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;

public class RESTClientConfig
extends BaseHttpClientConfig {
    public static final String X_BI_FORWARDED_FOR = "X-BI-Forwarded-For";
    private String context = "/";
    private static String overrideServer = System.getProperty("rest-client.server");
    private static int overridePort = Integer.getInteger("rest-client.port", -1);

    public RESTClientConfig() {
        this("");
    }

    public RESTClientConfig(String context) {
        if (StringUtils.isNotEmpty(context)) {
            this.context = context;
        }
        this.addSpecialHeaders();
    }

    public RESTClientConfig(HttpServletRequest request) {
        super(request);
        this.context = request.getContextPath().substring(1);
        this.prePopulateRequestHeaders(request);
        this.addSpecialHeaders();
    }

    public String getScheme() {
        return this.scheme;
    }

    @Override
    public String getServer() {
        return overrideServer != null ? overrideServer : this.server;
    }

    @Override
    public int getPort() {
        return overridePort != -1 ? overridePort : this.port;
    }

    public String getContext() {
        return this.context;
    }

    private void addSpecialHeaders() {
        this.requestHeaders.put("Accept-Encoding".toLowerCase(), new BasicHeader("Accept-Encoding", "gzip"));
        this.setXSRFTokenHeader();
        this.doForwardedByHeader();
        this.setTransactionCookie();
    }

    @Override
    protected void setTransactionCookie() {
    }

    private void doForwardedByHeader() {
        Header xbfb = (Header)this.requestHeaders.get(X_BI_FORWARDED_FOR.toLowerCase());
        StringBuilder currentValue = new StringBuilder();
        currentValue.append(this.getContext());
        if (xbfb != null) {
            currentValue.append(",").append(xbfb.getValue());
        }
        this.requestHeaders.put(X_BI_FORWARDED_FOR.toLowerCase(), new BasicHeader(X_BI_FORWARDED_FOR, currentValue.toString()));
    }

    public void setPassportCookie(String passport) {
        this.setCookie(new HttpCookie("cam_passport", passport));
    }
}

