/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.rest;

import com.ibm.bi.platform.commons.http.BIHttpClientPool;
import com.ibm.bi.rest.RESTClient;
import com.ibm.bi.rest.RESTClientConfig;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.client.HttpClient;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.cache.HttpCacheContext;
import org.apache.http.client.cache.HttpCacheStorage;
import org.apache.http.client.cache.ResourceFactory;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.client.CloseableHttpClient;

public class RESTClientFactory {
    private static RESTClientFactory instance = new RESTClientFactory();
    private final BIHttpClientPool clientPool = new BIHttpClientPool();

    public static RESTClientFactory getInstance() {
        return instance;
    }

    public RESTClient getClient(HttpServletRequest request) {
        return this.getClient(new RESTClientConfig(request));
    }

    public RESTClient getClient(RESTClientConfig config) {
        return this.createClient(this.clientPool.getClient(), HttpCacheContext.create(), config);
    }

    protected RESTClient createClient(CloseableHttpClient client, HttpClientContext context, RESTClientConfig config) {
        return new RESTClient(client, context, config);
    }

    public synchronized void startup(int max_connections) {
        this.clientPool.initialize();
    }

    public synchronized void startup() {
        this.startup(-1);
    }

    public synchronized void startup(boolean followRedirects) {
        this.clientPool.initialize(followRedirects);
    }

    public synchronized void startup(String context) {
        this.clientPool.initialize(context);
    }

    public synchronized void startup(String context, boolean followRedirects) {
        this.clientPool.initialize(context, followRedirects);
    }

    public synchronized void startup(String context, RedirectStrategy redirectStrategy) {
        this.clientPool.initialize(context, redirectStrategy);
    }

    public synchronized void startup(String context, boolean followRedirects, HttpRoutePlanner routePlanner) {
        this.clientPool.initialize(context, followRedirects, routePlanner);
    }

    public synchronized void startup(HttpCacheStorage clientCache) {
        this.startup(clientCache, null);
    }

    public synchronized void startup(HttpCacheStorage clientCache, ResourceFactory factory) {
        this.clientPool.initialize(clientCache, factory);
    }

    public void shutdown() {
        this.clientPool.terminate();
    }

    protected HttpClient getHttpClient() {
        return this.clientPool.getClient();
    }
}

