/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.rs;

import com.ibm.bi.platform.commons.CommonsMessageKeys;
import com.ibm.bi.platform.commons.http.util.CAHttpMethods;
import java.io.IOException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@PreMatching
public class HttpMethodOverride
implements ContainerRequestFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpMethodOverride.class);

    public void filter(ContainerRequestContext ctx) throws IOException {
        String methodOverride = StringUtils.upperCase(ctx.getHeaderString("X-Http-Method-Override"));
        if (StringUtils.isNotBlank(methodOverride)) {
            if (CAHttpMethods.isValid(methodOverride)) {
                ctx.setMethod(methodOverride);
            } else {
                LOGGER.error("Invalid X-Http-Method-Override value: {}", (Object)methodOverride);
                ctx.abortWith(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)CommonsMessageKeys.bad_override_header.buildMessage("X-Http-Method-Override", methodOverride).getLocalizedMessage()).build());
            }
        }
    }
}

