/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.rs;

import com.ibm.bi.platform.commons.CommonsMessageKeys;
import com.ibm.bi.platform.commons.crypto.CAMCryptoException;
import com.ibm.bi.platform.commons.crypto.JCAMCrypto;
import com.ibm.bi.platform.commons.messages.Message;
import com.ibm.bi.rs.BaseContainerRequestFilter;
import com.ibm.bi.rs.ITrustVerificationFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@ITrustVerificationFilter
public class TrustVerificationFilter
extends BaseContainerRequestFilter
implements ContainerRequestFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(TrustVerificationFilter.class);
    public static final String TRUSTED_SERVICE_ID = "TrustVerificationFilter.ServiceID";
    private static final boolean disabled = Boolean.getBoolean("TrustVerificationFilter.disable");
    @Context
    protected ResourceInfo resourceInfo;

    public void filter(ContainerRequestContext requestContext) throws IOException {
        if (!disabled) {
            Message msg = null;
            String trustHeader = requestContext.getHeaderString("X-CA-Authorization");
            if (StringUtils.isEmpty(trustHeader)) {
                msg = CommonsMessageKeys.trust_header_required.buildMessage();
            } else {
                String serviceID = this.getServiceIDAndVerifyToken(trustHeader);
                if (StringUtils.isEmpty(serviceID)) {
                    msg = CommonsMessageKeys.bad_trust_header.buildMessage();
                } else {
                    Set<String> services = this.getServiceNames();
                    if (services.contains("any") || services.contains(serviceID)) {
                        requestContext.setProperty(TRUSTED_SERVICE_ID, (Object)serviceID);
                        return;
                    }
                    msg = CommonsMessageKeys.service_not_trusted.buildMessage(serviceID);
                }
            }
            if (this.abort()) {
                LOGGER.error(msg.getMessage());
                requestContext.abortWith(this.abortResponse(msg.getLocalizedMessage()));
                return;
            }
            LOGGER.warn(msg.getMessage());
        }
    }

    protected String getServiceIDAndVerifyToken(String token) {
        try {
            return JCAMCrypto.createTrustedRequestSession().getServiceIDAndVerifyToken(token);
        }
        catch (CAMCryptoException e) {
            LOGGER.info("problem verifying trust token", e);
            return null;
        }
    }

    protected Response abortResponse(String message) {
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)message).header("Content-Type", (Object)"text/plain").build();
    }

    Set<String> getServiceNames() {
        ITrustVerificationFilter itvf = (ITrustVerificationFilter)this.getEffectiveAnnotation(ITrustVerificationFilter.class);
        if (itvf != null) {
            return new HashSet<String>(Arrays.asList(itvf.services()));
        }
        return new HashSet<String>(Arrays.asList("any"));
    }

    boolean abort() {
        ITrustVerificationFilter itvf = (ITrustVerificationFilter)this.getEffectiveAnnotation(ITrustVerificationFilter.class);
        if (itvf != null) {
            return itvf.abort();
        }
        return true;
    }
}

