/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.config;

import com.netflix.config.ConfigurationBackedDynamicPropertySupportImpl;
import com.netflix.config.ConfigurationManager;
import com.netflix.config.DynamicBooleanProperty;
import com.netflix.config.DynamicContextualProperty;
import com.netflix.config.DynamicDoubleProperty;
import com.netflix.config.DynamicFloatProperty;
import com.netflix.config.DynamicIntProperty;
import com.netflix.config.DynamicLongProperty;
import com.netflix.config.DynamicProperty;
import com.netflix.config.DynamicPropertySupport;
import com.netflix.config.DynamicStringProperty;
import com.netflix.config.PropertyWrapper;
import org.apache.commons.configuration.AbstractConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicPropertyFactory {
    private static DynamicPropertyFactory instance = new DynamicPropertyFactory();
    private static volatile DynamicPropertySupport config = null;
    private static volatile boolean initializedWithDefaultConfig = false;
    private static final Logger logger = LoggerFactory.getLogger(DynamicPropertyFactory.class);
    @Deprecated
    public static final String URL_CONFIG_NAME = "archaius.dynamicPropertyFactory.URL_CONFIG";
    @Deprecated
    public static final String SYS_CONFIG_NAME = "archaius.dynamicPropertyFactory.SYS_CONFIG";
    public static final String ENABLE_JMX = "archaius.dynamicPropertyFactory.registerConfigWithJMX";
    public static final String THROW_MISSING_CONFIGURATION_SOURCE_EXCEPTION = "archaius.dynamicProperty.throwMissingConfigurationSourceException";
    private static volatile boolean throwMissingConfigurationSourceException = Boolean.getBoolean("archaius.dynamicProperty.throwMissingConfigurationSourceException");
    @Deprecated
    public static final String DISABLE_DEFAULT_SYS_CONFIG = "archaius.dynamicProperty.disableSystemConfig";
    public static final String DISABLE_DEFAULT_CONFIG = "archaius.dynamicProperty.disableDefaultConfig";

    private DynamicPropertyFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DynamicPropertyFactory initWithConfigurationSource(AbstractConfiguration config) {
        Class<ConfigurationManager> clazz = ConfigurationManager.class;
        synchronized (ConfigurationManager.class) {
            if (config == null) {
                throw new NullPointerException("config is null");
            }
            if (ConfigurationManager.isConfigurationInstalled() && config != ConfigurationManager.instance) {
                throw new IllegalStateException("ConfigurationManager is already initialized with configuration " + ConfigurationManager.getConfigInstance());
            }
            if (config instanceof DynamicPropertySupport) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return DynamicPropertyFactory.initWithConfigurationSource((DynamicPropertySupport)((Object)config));
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return DynamicPropertyFactory.initWithConfigurationSource(new ConfigurationBackedDynamicPropertySupportImpl(config));
        }
    }

    public static boolean isInitializedWithDefaultConfig() {
        return initializedWithDefaultConfig;
    }

    public static Object getBackingConfigurationSource() {
        if (config instanceof ConfigurationBackedDynamicPropertySupportImpl) {
            return ((ConfigurationBackedDynamicPropertySupportImpl)config).getConfiguration();
        }
        return config;
    }

    public static void setThrowMissingConfigurationSourceException(boolean value) {
        throwMissingConfigurationSourceException = value;
    }

    public static boolean isThrowMissingConfigurationSourceException() {
        return throwMissingConfigurationSourceException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DynamicPropertyFactory initWithConfigurationSource(DynamicPropertySupport dynamicPropertySupport) {
        Class<ConfigurationManager> clazz = ConfigurationManager.class;
        synchronized (ConfigurationManager.class) {
            if (dynamicPropertySupport == null) {
                throw new IllegalArgumentException("dynamicPropertySupport is null");
            }
            AbstractConfiguration configuration = null;
            if (dynamicPropertySupport instanceof AbstractConfiguration) {
                configuration = (AbstractConfiguration)((Object)dynamicPropertySupport);
            } else if (dynamicPropertySupport instanceof ConfigurationBackedDynamicPropertySupportImpl) {
                configuration = ((ConfigurationBackedDynamicPropertySupportImpl)dynamicPropertySupport).getConfiguration();
            }
            if (initializedWithDefaultConfig) {
                config = null;
            } else if (config != null && config != dynamicPropertySupport) {
                throw new IllegalStateException("DynamicPropertyFactory is already initialized with a diffrerent configuration source: " + config);
            }
            if (ConfigurationManager.isConfigurationInstalled() && configuration != null && configuration != ConfigurationManager.instance) {
                throw new IllegalStateException("ConfigurationManager is already initialized with configuration " + ConfigurationManager.getConfigInstance());
            }
            if (configuration != null && configuration != ConfigurationManager.instance) {
                ConfigurationManager.setDirect(configuration);
            }
            DynamicPropertyFactory.setDirect(dynamicPropertySupport);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setDirect(DynamicPropertySupport support) {
        Class<ConfigurationManager> clazz = ConfigurationManager.class;
        synchronized (ConfigurationManager.class) {
            config = support;
            DynamicProperty.registerWithDynamicPropertySupport(support);
            initializedWithDefaultConfig = false;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DynamicPropertyFactory getInstance() {
        if (config != null) return instance;
        Class<ConfigurationManager> clazz = ConfigurationManager.class;
        synchronized (ConfigurationManager.class) {
            AbstractConfiguration configFromManager;
            if (config != null || (configFromManager = ConfigurationManager.getConfigInstance()) == null) return instance;
            DynamicPropertyFactory.initWithConfigurationSource(configFromManager);
            initializedWithDefaultConfig = !ConfigurationManager.isConfigurationInstalled();
            logger.info("DynamicPropertyFactory is initialized with configuration sources: " + configFromManager);
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private static void checkAndWarn(String propName) {
        if (config == null) {
            logger.warn("DynamicProperty " + propName + " is created without a configuration source for callback.");
        }
    }

    public DynamicStringProperty getStringProperty(String propName, String defaultValue) {
        return this.getStringProperty(propName, defaultValue, null);
    }

    public DynamicStringProperty getStringProperty(String propName, String defaultValue, Runnable propertyChangeCallback) {
        DynamicPropertyFactory.checkAndWarn(propName);
        DynamicStringProperty property = new DynamicStringProperty(propName, defaultValue);
        DynamicPropertyFactory.addCallback(propertyChangeCallback, property);
        return property;
    }

    public DynamicIntProperty getIntProperty(String propName, int defaultValue) {
        return this.getIntProperty(propName, defaultValue, null);
    }

    public DynamicIntProperty getIntProperty(String propName, int defaultValue, Runnable propertyChangeCallback) {
        DynamicPropertyFactory.checkAndWarn(propName);
        DynamicIntProperty property = new DynamicIntProperty(propName, defaultValue);
        DynamicPropertyFactory.addCallback(propertyChangeCallback, property);
        return property;
    }

    public DynamicLongProperty getLongProperty(String propName, long defaultValue) {
        return this.getLongProperty(propName, defaultValue, null);
    }

    public DynamicLongProperty getLongProperty(String propName, long defaultValue, Runnable propertyChangeCallback) {
        DynamicPropertyFactory.checkAndWarn(propName);
        DynamicLongProperty property = new DynamicLongProperty(propName, defaultValue);
        DynamicPropertyFactory.addCallback(propertyChangeCallback, property);
        return property;
    }

    public DynamicBooleanProperty getBooleanProperty(String propName, boolean defaultValue) {
        return this.getBooleanProperty(propName, defaultValue, null);
    }

    public DynamicBooleanProperty getBooleanProperty(String propName, boolean defaultValue, Runnable propertyChangeCallback) {
        DynamicPropertyFactory.checkAndWarn(propName);
        DynamicBooleanProperty property = new DynamicBooleanProperty(propName, defaultValue);
        DynamicPropertyFactory.addCallback(propertyChangeCallback, property);
        return property;
    }

    public DynamicFloatProperty getFloatProperty(String propName, float defaultValue) {
        return this.getFloatProperty(propName, defaultValue, null);
    }

    public DynamicFloatProperty getFloatProperty(String propName, float defaultValue, Runnable propertyChangeCallback) {
        DynamicPropertyFactory.checkAndWarn(propName);
        DynamicFloatProperty property = new DynamicFloatProperty(propName, defaultValue);
        DynamicPropertyFactory.addCallback(propertyChangeCallback, property);
        return property;
    }

    public DynamicDoubleProperty getDoubleProperty(String propName, double defaultValue) {
        return this.getDoubleProperty(propName, defaultValue, null);
    }

    public DynamicDoubleProperty getDoubleProperty(String propName, double defaultValue, Runnable propertyChangeCallback) {
        DynamicPropertyFactory.checkAndWarn(propName);
        DynamicDoubleProperty property = new DynamicDoubleProperty(propName, defaultValue);
        DynamicPropertyFactory.addCallback(propertyChangeCallback, property);
        return property;
    }

    public <T> DynamicContextualProperty<T> getContextualProperty(String propName, T defaultValue) {
        return this.getContextualProperty(propName, defaultValue, null);
    }

    public <T> DynamicContextualProperty<T> getContextualProperty(String propName, T defaultValue, Runnable propertyChangeCallback) {
        DynamicPropertyFactory.checkAndWarn(propName);
        DynamicContextualProperty<T> property = new DynamicContextualProperty<T>(propName, defaultValue);
        DynamicPropertyFactory.addCallback(propertyChangeCallback, property);
        return property;
    }

    private static void addCallback(Runnable callback, PropertyWrapper<?> wrapper) {
        if (callback != null) {
            wrapper.prop.addCallback(callback);
        }
    }
}

