/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.config;

import com.google.common.base.Splitter;
import com.netflix.config.WatchedUpdateResult;
import com.netflix.config.validation.ValidationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicPropertyUpdater {
    private static Logger logger = LoggerFactory.getLogger(DynamicPropertyUpdater.class);

    public void updateProperties(WatchedUpdateResult result, Configuration config, boolean ignoreDeletesFromSource) {
        block12: {
            block11: {
                if (result == null || !result.hasChanges()) {
                    return;
                }
                logger.debug("incremental result? [{}]", (Object)result.isIncremental());
                logger.debug("ignored deletes from source? [{}]", (Object)ignoreDeletesFromSource);
                if (result.isIncremental()) break block11;
                Map<String, Object> props = result.getComplete();
                if (props == null) {
                    return;
                }
                for (Map.Entry<String, Object> entry : props.entrySet()) {
                    this.addOrChangeProperty(entry.getKey(), entry.getValue(), config);
                }
                HashSet<String> existingKeys = new HashSet<String>();
                Iterator<String> i = config.getKeys();
                while (i.hasNext()) {
                    existingKeys.add(i.next());
                }
                if (ignoreDeletesFromSource) break block12;
                for (String key : existingKeys) {
                    if (props.containsKey(key)) continue;
                    this.deleteProperty(key, config);
                }
                break block12;
            }
            Map<String, Object> props = result.getAdded();
            if (props != null) {
                for (Map.Entry<String, Object> entry : props.entrySet()) {
                    this.addOrChangeProperty(entry.getKey(), entry.getValue(), config);
                }
            }
            if ((props = result.getChanged()) != null) {
                for (Map.Entry<String, Object> entry : props.entrySet()) {
                    this.addOrChangeProperty(entry.getKey(), entry.getValue(), config);
                }
            }
            if (!ignoreDeletesFromSource && (props = result.getDeleted()) != null) {
                for (String name : props.keySet()) {
                    this.deleteProperty(name, config);
                }
            }
        }
    }

    void addOrChangeProperty(String name, Object newValue, Configuration config) {
        try {
            if (!config.containsKey(name)) {
                logger.debug("adding property key [{}], value [{}]", (Object)name, (Object)newValue);
                config.addProperty(name, newValue);
            } else {
                Object oldValue = config.getProperty(name);
                if (newValue != null) {
                    CopyOnWriteArrayList<String> newValueArray;
                    if (oldValue instanceof CopyOnWriteArrayList && AbstractConfiguration.getDefaultListDelimiter() != '\u0000') {
                        newValueArray = new CopyOnWriteArrayList<String>();
                        Iterable<String> stringiterator = Splitter.on(AbstractConfiguration.getDefaultListDelimiter()).omitEmptyStrings().trimResults().split((String)((Object)newValue));
                        for (String s : stringiterator) {
                            newValueArray.add(s);
                        }
                    } else {
                        newValueArray = newValue;
                    }
                    if (!((Object)newValueArray).equals(oldValue)) {
                        logger.debug("updating property key [{}], value [{}]", (Object)name, (Object)newValue);
                        config.setProperty(name, newValue);
                    }
                } else if (oldValue != null) {
                    logger.debug("nulling out property key [{}]", (Object)name);
                    config.setProperty(name, null);
                }
            }
        }
        catch (ValidationException e) {
            logger.warn("Validation failed for property " + name, e);
        }
    }

    void deleteProperty(String key, Configuration config) {
        if (config.containsKey(key)) {
            logger.debug("deleting property key [" + key + "]");
            config.clearProperty(key);
        }
    }
}

