/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.config;

import com.google.common.base.Function;
import com.netflix.config.PropertyWrapper;

public class StringDerivedProperty<T>
extends PropertyWrapper<T> {
    protected final Function<String, T> decoder;
    private volatile T derivedValue;

    public StringDerivedProperty(String propName, T defaultValue, Function<String, T> decoder) {
        super(propName, defaultValue);
        this.decoder = decoder;
        this.propertyChangedInternal();
    }

    private final void propertyChangedInternal() {
        String stringValue = this.prop.getString();
        this.derivedValue = stringValue == null ? this.defaultValue : this.decoder.apply(stringValue);
    }

    @Override
    protected final void propertyChanged() {
        this.propertyChangedInternal();
        this.propertyChanged(this.getValue());
    }

    @Override
    public T getValue() {
        return this.derivedValue;
    }
}

