/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.accesscontrol;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.ibm.cognos.camaaa.internal.accesscontrol.CAMCachedIdentityProvider;
import com.ibm.cognos.camaaa.internal.accesscontrol.CAMIdentityProvider;
import com.ibm.cognos.camaaa.internal.accesscontrol.CAMIntegratedPolicy;
import com.ibm.cognos.camaaa.internal.accesscontrol.CAMLBPolicyFactory;
import com.ibm.cognos.camaaa.internal.accesscontrol.CAMPolicyFactory;
import com.ibm.cognos.internal.camaaa.accesscontrol.AccessControlException;
import com.ibm.cognos.internal.camaaa.accesscontrol.AccessControlModule;
import com.ibm.cognos.internal.camaaa.accesscontrol.Identity;
import com.ibm.cognos.internal.camaaa.accesscontrol.IdentityProvider;
import com.ibm.cognos.internal.camaaa.accesscontrol.IntegratedPolicy;
import com.ibm.cognos.internal.camaaa.accesscontrol.Policy;
import com.ibm.cognos.internal.camaaa.accesscontrol.PolicyFactory;
import java.net.MalformedURLException;
import java.net.URL;
import org.dom4j.Element;

public final class AccessControlModuleImpl
implements AccessControlModule {
    private static AccessControlModuleImpl acModuleInstance;
    private static final String INTERNAL_DISPATCHER = "internalDispatcher";
    private static final String LB_POLICY_FACTORY_NAME = "lbPolicyFactoryName";
    private static final String POLICY_FACTORY_NAME = "policyFactoryName";
    private static final int DEFAULT_MAX_HOST_CONNECTIONS = 100;
    private static final int DEFAULT_CACHE_TIMEOUT_IN_SECONDS = 60;
    private int instanceCount;
    private URL queryServiceURL;
    private int maxHostConnections;
    private int cacheTimeOutInSeconds;
    private PolicyFactory lbPolicyFactory;
    private String lbPolicyFactoryName;
    private PolicyFactory policyFactory;
    private String policyFactoryName;
    private CAMIdentityProvider identityProvider;

    private AccessControlModuleImpl() {
    }

    private static int getCacheTimeOut(ICCLConfiguration iCCLConfiguration) throws AccessControlException, CCLConfigurationException {
        return 60;
    }

    public static synchronized AccessControlModuleImpl getInstance() {
        if (acModuleInstance == null) {
            acModuleInstance = new AccessControlModuleImpl();
        }
        return acModuleInstance;
    }

    private static String getLBPolicyFactoryName(ICCLConfiguration iCCLConfiguration) throws AccessControlException, CCLConfigurationException {
        String string = iCCLConfiguration.getValue(LB_POLICY_FACTORY_NAME, false);
        if (string == null) {
            throw new AccessControlException("AAA_ACM_E_CANNOT_GET_POLICY_FACTORY_NAME");
        }
        return string;
    }

    private static int getMaxHostConnections(ICCLConfiguration iCCLConfiguration) throws AccessControlException, CCLConfigurationException {
        return 100;
    }

    private static String getPolicyFactoryName(ICCLConfiguration iCCLConfiguration) throws AccessControlException, CCLConfigurationException {
        String string = iCCLConfiguration.getValue(POLICY_FACTORY_NAME, false);
        if (string == null) {
            throw new AccessControlException("AAA_ACM_E_CANNOT_GET_POLICY_FACTORY_NAME");
        }
        return string;
    }

    private static URL getQueryServiceURL(ICCLConfiguration iCCLConfiguration) throws AccessControlException, CCLConfigurationException {
        URL uRL;
        try {
            String string = iCCLConfiguration.getValue(INTERNAL_DISPATCHER, false);
            if (string == null || string.length() == 0) {
                throw new AccessControlException("AAA_ACM_E_CANNOT_GET_SERVICE_URL");
            }
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new AccessControlException("AAA_ACM_E_CANNOT_GET_SERVICE_URL", malformedURLException);
        }
        return uRL;
    }

    private static PolicyFactory initPolicyFactory(String string) throws AccessControlException {
        try {
            Class<?> clazz = Class.forName(string);
            return (PolicyFactory)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new AccessControlException("AAA_ACM_E_LOADING_POLICY_FACTORY", classNotFoundException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AccessControlException("AAA_ACM_E_LOADING_POLICY_FACTORY", illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new AccessControlException("AAA_ACM_E_LOADING_POLICY_FACTORY", instantiationException);
        }
    }

    @Override
    public Identity getIdentity(Element element) throws AccessControlException {
        return this.identityProvider.getIdentity(element);
    }

    IdentityProvider getIdentityProvider() {
        return this.identityProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IntegratedPolicy getIntegratedPolicy() {
        AccessControlModuleImpl accessControlModuleImpl = this;
        synchronized (accessControlModuleImpl) {
            return new CAMIntegratedPolicy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Policy getLBPolicy() {
        AccessControlModuleImpl accessControlModuleImpl = this;
        synchronized (accessControlModuleImpl) {
            return this.lbPolicyFactory.createPolicy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Policy getPolicy() {
        AccessControlModuleImpl accessControlModuleImpl = this;
        synchronized (accessControlModuleImpl) {
            return this.policyFactory.createPolicy();
        }
    }

    private void increaseRefCount() {
        ++this.instanceCount;
    }

    @Override
    public synchronized void initialize() throws AccessControlException {
        ICCLConfiguration iCCLConfiguration = CCLConfigurationFactory.getInstance();
        try {
            if (iCCLConfiguration != null) {
                iCCLConfiguration.init();
            }
        }
        catch (CCLConfigurationException cCLConfigurationException) {
            throw new AccessControlException("AAA_ACM_E_ACCESSCONTROL_INITIALIZE_FAILED", (Exception)((Object)cCLConfigurationException));
        }
        this.initialize(iCCLConfiguration);
    }

    @Override
    public void initialize(ICCLConfiguration iCCLConfiguration) throws AccessControlException {
        this.initProviderConfig(iCCLConfiguration);
        CAMCachedIdentityProvider cAMCachedIdentityProvider = new CAMCachedIdentityProvider(this.queryServiceURL, this.maxHostConnections, this.cacheTimeOutInSeconds);
        this.initialize(iCCLConfiguration, cAMCachedIdentityProvider);
    }

    void initialize(ICCLConfiguration iCCLConfiguration, CAMIdentityProvider cAMIdentityProvider) throws AccessControlException {
        try {
            this.initPolicyFactoryConfig(iCCLConfiguration);
            this.initPolicyFactory(iCCLConfiguration);
            this.initLBPolicyFactory(iCCLConfiguration);
            this.identityProvider = cAMIdentityProvider;
            this.increaseRefCount();
        }
        catch (AccessControlException accessControlException) {
            throw new AccessControlException("AAA_ACM_E_ACCESSCONTROL_INITIALIZE_FAILED", (Exception)((Object)accessControlException));
        }
    }

    private void initLBPolicyFactory(ICCLConfiguration iCCLConfiguration) throws AccessControlException {
        try {
            if (this.lbPolicyFactory != null) {
                this.lbPolicyFactory = null;
            }
            this.lbPolicyFactory = this.lbPolicyFactoryName.length() != 0 ? AccessControlModuleImpl.initPolicyFactory(this.lbPolicyFactoryName) : new CAMLBPolicyFactory();
        }
        catch (AccessControlException accessControlException) {
            throw new AccessControlException("AAA_ACM_E_ACCESSCONTROL_INITIALIZE_FAILED", (Exception)((Object)accessControlException));
        }
    }

    private void initPolicyFactory(ICCLConfiguration iCCLConfiguration) throws AccessControlException {
        try {
            if (this.policyFactory != null) {
                this.policyFactory = null;
            }
            this.policyFactory = this.policyFactoryName.length() != 0 ? AccessControlModuleImpl.initPolicyFactory(this.policyFactoryName) : new CAMPolicyFactory();
        }
        catch (AccessControlException accessControlException) {
            throw new AccessControlException("AAA_ACM_E_ACCESSCONTROL_INITIALIZE_FAILED", (Exception)((Object)accessControlException));
        }
    }

    private void initPolicyFactoryConfig(ICCLConfiguration iCCLConfiguration) throws AccessControlException {
        try {
            this.policyFactoryName = AccessControlModuleImpl.getPolicyFactoryName(iCCLConfiguration);
            this.lbPolicyFactoryName = AccessControlModuleImpl.getLBPolicyFactoryName(iCCLConfiguration);
        }
        catch (CCLConfigurationException cCLConfigurationException) {
            throw new AccessControlException("AAA_ACM_E_ACCESSCONTROL_INITIALIZE_FAILED", (Exception)((Object)cCLConfigurationException));
        }
    }

    private void initProviderConfig(ICCLConfiguration iCCLConfiguration) throws AccessControlException {
        try {
            this.queryServiceURL = AccessControlModuleImpl.getQueryServiceURL(iCCLConfiguration);
            this.maxHostConnections = AccessControlModuleImpl.getMaxHostConnections(iCCLConfiguration);
            this.cacheTimeOutInSeconds = AccessControlModuleImpl.getCacheTimeOut(iCCLConfiguration);
        }
        catch (CCLConfigurationException cCLConfigurationException) {
            throw new AccessControlException("AAA_ACM_E_ACCESSCONTROL_INITIALIZE_FAILED", (Exception)((Object)cCLConfigurationException));
        }
    }

    @Override
    public void reconfigure() throws AccessControlException {
    }

    @Override
    public synchronized void terminate() {
        if (this.instanceCount > 0) {
            --this.instanceCount;
        } else {
            this.identityProvider.terminate();
            this.identityProvider = null;
        }
    }

    @Override
    public void testConfiguration(ICCLConfiguration iCCLConfiguration) throws AccessControlException {
        try {
            AccessControlModuleImpl.getQueryServiceURL(iCCLConfiguration);
            AccessControlModuleImpl.getMaxHostConnections(iCCLConfiguration);
            String string = AccessControlModuleImpl.getPolicyFactoryName(iCCLConfiguration);
            String string2 = AccessControlModuleImpl.getLBPolicyFactoryName(iCCLConfiguration);
            if (string.length() != 0) {
                AccessControlModuleImpl.initPolicyFactory(string);
            }
            if (string2.length() != 0) {
                AccessControlModuleImpl.initPolicyFactory(string2);
            }
        }
        catch (AccessControlException accessControlException) {
            throw new AccessControlException("AAA_ACM_E_CONFIG_TEST_FAILED", (Exception)((Object)accessControlException));
        }
        catch (CCLConfigurationException cCLConfigurationException) {
            throw new AccessControlException("AAA_ACM_E_CONFIG_TEST_FAILED", (Exception)((Object)cCLConfigurationException));
        }
    }
}

