/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.accesscontrol;

import com.ibm.cognos.camaaa.internal.accesscontrol.CAMIdentityCache;
import com.ibm.cognos.camaaa.internal.accesscontrol.CAMIdentityProvider;
import com.ibm.cognos.camaaa.internal.auth.soap.TenancyInfo;
import com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper;
import com.ibm.cognos.camaaa.internal.common.util.CAMAAServiceCommunicator;
import com.ibm.cognos.camaaa.internal.common.util.TimedObject;
import com.ibm.cognos.camaaa.internal.common.util.TimerPruningTask;
import com.ibm.cognos.internal.camaaa.accesscontrol.AccessControlException;
import com.ibm.cognos.internal.camaaa.accesscontrol.Identity;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.dom4j.Element;
import org.dom4j.Node;

public class CAMCachedIdentityProvider
extends CAMIdentityProvider {
    private static final int MILLISECONDS_IN_SECOND = 1000;
    private static final String CAM_PASSPORT_XPATH = "./*[local-name()='biBusHeader']/*[local-name()='CAM']/*[local-name()='CAMPassport']";
    private static final String CAM_PASSPORT_ID_XPATH = "./*[local-name()='biBusHeader']/*[local-name()='CAM']/*[local-name()='CAMPassport']/*[local-name()='id']/text()";
    private static final String CAM_PASSPORT_GENERATION_XPATH = "./*[local-name()='biBusHeader']/*[local-name()='CAM']/*[local-name()='CAMPassport']/*[local-name()='generation']/text()";
    private final long cacheTimeoutInSeconds;
    private Map camIdentityCache;
    private TimerPruningTask timerPruningTask;
    private Timer timer;

    CAMCachedIdentityProvider(CAMAAServiceCommunicator cAMAAServiceCommunicator, long l) {
        super(cAMAAServiceCommunicator);
        this.cacheTimeoutInSeconds = l;
        this.initPrunningTask();
    }

    CAMCachedIdentityProvider(long l) {
        this.cacheTimeoutInSeconds = l;
        this.initPrunningTask();
    }

    CAMCachedIdentityProvider(URL uRL, int n, long l) throws AccessControlException {
        super(uRL, n);
        this.cacheTimeoutInSeconds = l;
        this.initPrunningTask();
    }

    protected void addCAMIdentityToTheCache(CAMIdentityCache cAMIdentityCache) {
        this.camIdentityCache.put(cAMIdentityCache.getUniqueId(), cAMIdentityCache);
        this.timerPruningTask.add((TimedObject)cAMIdentityCache);
    }

    @Override
    protected Identity createIdentity(Element element) throws AccessControlException {
        return new CAMIdentityCache(element, this.cacheTimeoutInSeconds * 1000L, this);
    }

    protected Identity createIdentity(String string, List list, TenancyInfo tenancyInfo) throws AccessControlException {
        return new CAMIdentityCache(string, list, tenancyInfo, this.cacheTimeoutInSeconds * 1000L, this);
    }

    public void destroy() {
        this.timer.cancel();
        this.timer = null;
        if (this.camIdentityCache != null) {
            this.camIdentityCache.clear();
        }
    }

    protected int getCacheSize() {
        return this.camIdentityCache.size();
    }

    @Override
    public Identity getIdentity(Element element) throws AccessControlException {
        int n;
        String string = this.getPassportID(element);
        Identity identity = this.getIdentityFromCache(string, n = this.getIdentityGeneration(element));
        if (identity == null) {
            identity = super.getIdentity(element);
            this.addCAMIdentityToTheCache((CAMIdentityCache)identity);
        }
        return identity;
    }

    protected Identity getIdentityFromCache(String string, int n) {
        CAMIdentityCache cAMIdentityCache = null;
        CAMIdentityCache cAMIdentityCache2 = (CAMIdentityCache)this.camIdentityCache.get(string);
        if (cAMIdentityCache2 != null) {
            if (cAMIdentityCache2.isExpired() || n > cAMIdentityCache2.getGeneration()) {
                this.camIdentityCache.remove(string);
                this.timerPruningTask.remove((TimedObject)cAMIdentityCache2);
            } else {
                cAMIdentityCache = cAMIdentityCache2;
            }
        }
        return cAMIdentityCache;
    }

    private int getIdentityGeneration(Element element) {
        String string = DocumentHelper.valueOf((String)CAM_PASSPORT_GENERATION_XPATH, (Node)element);
        if (string != null) {
            try {
                int n = Integer.parseInt(string);
                return n;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    private String getPassportID(Element element) {
        return DocumentHelper.valueOf((String)CAM_PASSPORT_ID_XPATH, (Node)element);
    }

    private void initPrunningTask() {
        this.camIdentityCache = Collections.synchronizedMap(new HashMap());
        this.timerPruningTask = new TimerPruningTask();
        this.timer = new Timer(true);
        this.timer.schedule((TimerTask)this.timerPruningTask, 0L, this.cacheTimeoutInSeconds * 1000L);
    }

    void removeIdentityFromCache(String string) {
        this.camIdentityCache.remove(string);
    }

    protected void removeIdentityFromCacheAndTimer(String string) {
        CAMIdentityCache cAMIdentityCache = (CAMIdentityCache)this.camIdentityCache.remove(string);
        if (cAMIdentityCache != null) {
            this.timerPruningTask.remove((TimedObject)cAMIdentityCache);
        }
    }
}

