/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.accesscontrol;

import com.ibm.cognos.camaaa.internal.auth.TenancyInfoImpl;
import com.ibm.cognos.camaaa.internal.auth.soap.TenancyInfo;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.internal.camaaa.accesscontrol.AccessControlException;
import com.ibm.cognos.internal.camaaa.accesscontrol.Identity;
import java.util.HashSet;
import java.util.List;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.QName;

class CAMIdentity
implements Identity {
    private static final String COGNOS_NAMESPACE = "";
    private static final String CAMID_START = "CAMID(";
    private static final String CAMID_END = ")";
    private static final int CAMID_PREFIX_LENGHT = 6;
    private final HashSet identities;
    private final TenancyInfo tenancy;

    CAMIdentity(Element element) throws AccessControlException {
        Element element2 = element.element(QName.get((String)"Body", (String)"http://schemas.xmlsoap.org/soap/envelope/"));
        if (element2 == null) {
            throw new AccessControlException("AAA_ACM_E_NO_SOAPBODY_IN_RESPONSE", new Object[]{new String(element.asXML())});
        }
        List list = element2.selectNodes("./*/*/*[local-name()='self']/*[local-name()='item']");
        if (list.size() == 0) {
            throw new AccessControlException("AAA_ACM_E_NO_IDENTITIES_IN_RESPONSE", new Object[]{new String(element.asXML())});
        }
        this.tenancy = new TenancyInfoImpl();
        try {
            this.populateTenancy(element2);
        }
        catch (SoapFaultException soapFaultException) {
            throw new AccessControlException("AAA_ACM_E_NO_IDENTITIES_IN_RESPONSE", (Exception)((Object)soapFaultException));
        }
        this.identities = new HashSet();
        this.populateIdentities(list);
    }

    CAMIdentity(List list, TenancyInfo tenancyInfo) {
        this.tenancy = tenancyInfo;
        this.identities = new HashSet();
        this.populateIdentities(list);
    }

    static String extractObjectId(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string;
        int n = -1;
        int n2 = string.indexOf("\"");
        int n3 = string.indexOf("'");
        boolean bl = true;
        if (n2 != -1 && n3 != -1) {
            if (n2 < n3) {
                n = n2;
                bl = true;
            } else {
                n = n3;
                bl = false;
            }
        } else if (n2 != -1) {
            n = n2;
            bl = true;
        } else {
            n = n3;
            bl = false;
        }
        int n4 = -1;
        n4 = bl ? string.lastIndexOf("\"") : string.lastIndexOf("'");
        if (n != -1 && n4 != -1 && n < n4) {
            string2 = string.substring(n + 1, n4);
        }
        string2 = CAMIdentity.removeTrailingColon(string2);
        return string2;
    }

    static String extractPolicyObjectID(String string) {
        String string2 = CAMIdentity.removeCAMIDPrefix(string);
        return CAMIdentity.extractObjectId(string2);
    }

    private static String removeCAMIDPrefix(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string.trim();
        String string3 = null;
        int n = string2.indexOf(CAMID_START);
        int n2 = string2.lastIndexOf(CAMID_END);
        if (n == 0 && n2 == string2.length() - 1) {
            string3 = string2.substring(6, n2);
        }
        return string3;
    }

    private static String removeTrailingColon(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        String string2 = string;
        int n = string.lastIndexOf(58);
        if (n != -1 && n == string.length() - 1) {
            string2 = string.substring(0, n);
        } else if (n == 0 && string.length() == 1) {
            string2 = COGNOS_NAMESPACE;
        }
        return string2;
    }

    @Override
    public boolean contains(String string) {
        String string2 = CAMIdentity.extractObjectId(string);
        return this.identities.contains(string2);
    }

    @Override
    public String[] getIdentities() {
        String[] stringArray = new String[this.identities.size()];
        int n = 0;
        for (String string : this.identities) {
            stringArray[n] = new String("CAMID(\"" + string + "\")");
            ++n;
        }
        return stringArray;
    }

    @Override
    public TenancyInfo getTenancy() {
        return this.tenancy;
    }

    private void populateIdentities(List list) {
        for (int i = 0; i < list.size(); ++i) {
            Element element = (Element)list.get(i);
            String string = CAMIdentity.extractObjectId(element.getTextTrim());
            this.identities.add(string);
        }
    }

    private void populateTenancy(Element element) throws SoapFaultException {
        this.extractTenantInfo(element, "./*/*/*[local-name()='tenancy']/*[local-name()='tenantID']", TenancyInfo.TenancyType.TENANTID);
        this.extractMultiTenantInfo(element, "./*/*/*[local-name()='tenancy']/*[local-name()='readTenantIDs']/*[local-name()='item']", TenancyInfo.TenancyType.READ_TENANTID);
        this.extractTenantInfo(element, "./*/*/*[local-name()='tenancy']/*[local-name()='writeTenantID']", TenancyInfo.TenancyType.WRITE_TENANTID);
    }

    private void extractTenantInfo(Element element, String string, TenancyInfo.TenancyType tenancyType) {
        Element element2 = (Element)element.selectSingleNode(string);
        if (element2 != null) {
            this.tenancy.setTenancy(tenancyType, element2.getTextTrim());
        }
    }

    private void extractMultiTenantInfo(Element element, String string, TenancyInfo.TenancyType tenancyType) throws SoapFaultException {
        List list = element.selectNodes(string);
        for (Node node : list) {
            String string2 = node.getText();
            if (string2 == null || string2.isEmpty()) continue;
            this.tenancy.addTenancies(tenancyType, new String[]{string2});
        }
    }
}

