/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.accesscontrol;

import com.ibm.cognos.camaaa.internal.accesscontrol.CAMCachedIdentityProvider;
import com.ibm.cognos.camaaa.internal.accesscontrol.CAMIdentity;
import com.ibm.cognos.camaaa.internal.auth.soap.TenancyInfo;
import com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper;
import com.ibm.cognos.camaaa.internal.common.soap.XMLConstants;
import com.ibm.cognos.camaaa.internal.common.util.TimedObject;
import com.ibm.cognos.internal.camaaa.accesscontrol.AccessControlException;
import java.util.List;
import org.dom4j.Element;
import org.dom4j.Node;

public class CAMIdentityCache
extends CAMIdentity
implements TimedObject {
    private static final String CAM_PASSPORT_XPATH = "./*[local-name()='biBusHeader']/*[local-name()='CAM']/*[local-name()='CAMPassport']";
    private static final String CAM_PASSPORT_ID_XPATH = "./*[local-name()='biBusHeader']/*[local-name()='CAM']/*[local-name()='CAMPassport']/*[local-name()='id']/text()";
    private static final String CAM_PASSPORT_GENERATION_XPATH = "./*[local-name()='biBusHeader']/*[local-name()='CAM']/*[local-name()='CAMPassport']/*[local-name()='generation']/text()";
    private final long startTime;
    private final long timeOutInMillis;
    private final String uniqueID;
    private int generation;
    private final CAMCachedIdentityProvider myIdentityProvider;

    public CAMIdentityCache(Element element, long l, CAMCachedIdentityProvider cAMCachedIdentityProvider) throws AccessControlException {
        super(element);
        this.timeOutInMillis = l;
        this.startTime = System.currentTimeMillis();
        this.myIdentityProvider = cAMCachedIdentityProvider;
        Element element2 = element.element(XMLConstants.SOAPENV_HEADER);
        this.uniqueID = DocumentHelper.valueOf((String)CAM_PASSPORT_ID_XPATH, (Node)element2);
        String string = DocumentHelper.valueOf((String)CAM_PASSPORT_GENERATION_XPATH, (Node)element2);
        this.generation = 0;
        if (string != null) {
            try {
                this.generation = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public CAMIdentityCache(String string, List list, TenancyInfo tenancyInfo, long l, CAMCachedIdentityProvider cAMCachedIdentityProvider) throws AccessControlException {
        super(list, tenancyInfo);
        this.timeOutInMillis = l;
        this.startTime = System.currentTimeMillis();
        this.myIdentityProvider = cAMCachedIdentityProvider;
        this.uniqueID = string;
        this.generation = 0;
    }

    public void cleanup() {
        this.myIdentityProvider.removeIdentityFromCacheAndTimer(this.uniqueID);
    }

    private long getElapsedTimeInMs() {
        return System.currentTimeMillis() - this.startTime;
    }

    public int getGeneration() {
        return this.generation;
    }

    public String getUniqueId() {
        return this.uniqueID;
    }

    public boolean isExpired() {
        return this.getElapsedTimeInMs() >= this.timeOutInMillis;
    }
}

