/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.accesscontrol;

import com.ibm.cognos.camaaa.internal.accesscontrol.AccessControlModuleImpl;
import com.ibm.cognos.internal.camaaa.accesscontrol.AccessControlModule;
import com.ibm.cognos.internal.camaaa.accesscontrol.Identity;
import com.ibm.cognos.internal.camaaa.accesscontrol.IntegratedPolicy;
import com.ibm.cognos.internal.camaaa.accesscontrol.Policy;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class CAMIntegratedPolicy
implements IntegratedPolicy {
    private static final long serialVersionUID = 847362549601L;
    private static final int MAJOR_VERSION = 1;
    private static final int MINOR_VERSION = 0;
    private final AccessControlModule acm = AccessControlModuleImpl.getInstance();
    private Policy dacPolicy;
    private Policy lbPolicy;

    @Override
    public Object clone() throws CloneNotSupportedException {
        CAMIntegratedPolicy cAMIntegratedPolicy = (CAMIntegratedPolicy)super.clone();
        cAMIntegratedPolicy.dacPolicy = (Policy)this.dacPolicy.clone();
        cAMIntegratedPolicy.lbPolicy = (Policy)this.lbPolicy.clone();
        return cAMIntegratedPolicy;
    }

    @Override
    public void destroy() {
        if (this.dacPolicy != null) {
            this.dacPolicy.destroy();
            this.dacPolicy = null;
        }
        if (this.lbPolicy != null) {
            this.lbPolicy.destroy();
            this.lbPolicy = null;
        }
    }

    @Override
    public Policy getDACPolicy() {
        return this.dacPolicy;
    }

    @Override
    public Policy getLBPolicy() {
        return this.lbPolicy;
    }

    @Override
    public boolean isAccessGranted(Identity identity, String string) {
        boolean bl = true;
        if (this.lbPolicy != null) {
            bl = this.lbPolicy.isAccessGranted(identity, string);
        }
        boolean bl2 = true;
        if (bl && this.dacPolicy != null) {
            bl2 = this.dacPolicy.isAccessGranted(identity, string);
        }
        return bl && bl2;
    }

    @Override
    public void readFrom(ByteArrayInputStream byteArrayInputStream) throws IOException {
        this.destroy();
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        long l = objectInputStream.readLong();
        if (l != 847362549601L) {
            throw new IOException("Unkown version: " + Long.toString(l));
        }
        int n = objectInputStream.readInt();
        objectInputStream.readInt();
        if (n > 1) {
            throw new IOException("Unsupported version: " + Integer.toString(n));
        }
        boolean bl = objectInputStream.readBoolean();
        boolean bl2 = objectInputStream.readBoolean();
        if (bl) {
            this.lbPolicy = this.acm.getLBPolicy();
            this.lbPolicy.readFrom(byteArrayInputStream);
        }
        if (bl2) {
            this.dacPolicy = this.acm.getPolicy();
            this.dacPolicy.readFrom(byteArrayInputStream);
        }
    }

    @Override
    public void setDACPolicy(Policy policy) {
        if (this.dacPolicy != null) {
            this.dacPolicy.destroy();
        }
        this.dacPolicy = policy;
    }

    @Override
    public void setLBPolicy(Policy policy) {
        if (this.lbPolicy != null) {
            this.lbPolicy.destroy();
        }
        this.lbPolicy = policy;
    }

    @Override
    public void writeTo(ByteArrayOutputStream byteArrayOutputStream) throws IOException {
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeLong(847362549601L);
        objectOutputStream.writeInt(1);
        objectOutputStream.writeInt(0);
        objectOutputStream.writeBoolean(this.lbPolicy != null);
        objectOutputStream.writeBoolean(this.dacPolicy != null);
        objectOutputStream.flush();
        if (this.lbPolicy != null) {
            this.lbPolicy.writeTo(byteArrayOutputStream);
        }
        if (this.dacPolicy != null) {
            this.dacPolicy.writeTo(byteArrayOutputStream);
        }
    }
}

