/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.accesscontrol;

import com.ibm.cognos.camaaa.internal.auth.soap.TenancyInfo;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper;
import com.ibm.cognos.internal.camaaa.accesscontrol.AccessControlException;
import com.ibm.cognos.internal.camaaa.accesscontrol.Identity;
import com.ibm.cognos.internal.camaaa.accesscontrol.Policy;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.QName;

public class CAMLBPolicy
implements Policy {
    private static final String SOAP_ENC_NS_PREFIX = "SOAP-ENC";
    private static final Namespace SOAP_ENC_NS = new Namespace("SOAP-ENC", "http://schemas.xmlsoap.org/soap/encoding/");
    private static final Namespace XSD_NS = new Namespace("xsd", "http://www.w3.org/2001/XMLSchema");
    private static final Namespace XSI_NS = new Namespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
    private static final QName BIBUS_LBPOLICY = QName.get((String)"lbPolicy", (String)"bus", (String)"http://developer.cognos.com/schemas/bibus/3/");
    private static final QName AND_LABELS = QName.get((String)"andLabels");
    private static final QName OR_LABELS = QName.get((String)"orLabels");
    private static final QName TENANT_ID = QName.get((String)"tenantID");
    private static final QName SOAP_ENC_ARRAYTYPE = QName.get((String)"arrayType", (Namespace)SOAP_ENC_NS);
    private static final QName XSD_STRING = QName.get((String)"string", (Namespace)XSD_NS);
    private static final QName XSI_TYPE = QName.get((String)"type", (Namespace)XSI_NS);
    private static final String SOAP_ENC_ARRAY = QName.get((String)"Array", (Namespace)SOAP_ENC_NS).getQualifiedName();
    private static final String STRING_ARRAY = XSD_STRING.getQualifiedName();
    private static final long serialVersionUID = 164087134871L;
    private static final int MAJOR_VERSION = 1;
    private static final int MINOR_VERSION = 0;
    private List<String> requiredLabels = new LinkedList<String>();
    private List<String> optionalLabels = new LinkedList<String>();

    CAMLBPolicy() {
    }

    void addOptionalTenant(String string) {
        this.optionalLabels.add(string);
    }

    void addRequiredTenent(String string) {
        this.requiredLabels.add(string);
    }

    private boolean checkOptionalLabels(Set<String> set, String string) {
        boolean bl = false;
        bl = this.optionalLabels.size() == 0 ? true : (set == null ? false : this.doesIdentityContainAtLeastOneLabel(set, this.optionalLabels));
        return bl;
    }

    private boolean checkRequiredLabels(Set<String> set, String string) {
        boolean bl = false;
        bl = this.requiredLabels.size() == 0 ? true : (set == null ? false : this.doesIdentityContainAllLabels(set, this.requiredLabels));
        return bl;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        CAMLBPolicy cAMLBPolicy = (CAMLBPolicy)super.clone();
        cAMLBPolicy.requiredLabels = (LinkedList)((LinkedList)this.requiredLabels).clone();
        cAMLBPolicy.optionalLabels = (LinkedList)((LinkedList)this.optionalLabels).clone();
        return cAMLBPolicy;
    }

    @Override
    public void destroy() {
        this.requiredLabels = new LinkedList<String>();
        this.optionalLabels = new LinkedList<String>();
    }

    private boolean doesIdentityContainAllLabels(Set<String> set, List<String> list) {
        boolean bl = true;
        for (String string : list) {
            if (set.contains(string)) continue;
            bl = false;
            break;
        }
        return bl;
    }

    private boolean doesIdentityContainAtLeastOneLabel(Set<String> set, List<String> list) {
        boolean bl = false;
        for (String string : list) {
            if (!set.contains(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    @Override
    public Element getDescription() {
        Object object;
        Document document = DocumentFactory.getInstance().createDocument();
        Element element = document.addElement(BIBUS_LBPOLICY);
        element.addAttribute(XSI_TYPE, "lbPolicyArrayProp");
        element.add(XSI_NS);
        element.add(SOAP_ENC_NS);
        Element element2 = element.addElement(AND_LABELS);
        element2.addAttribute(XSI_TYPE, SOAP_ENC_ARRAY);
        element2.addAttribute(SOAP_ENC_ARRAYTYPE, STRING_ARRAY + "[" + this.requiredLabels.size() + "]");
        Element element3 = this.requiredLabels.iterator();
        while (element3.hasNext()) {
            object = element2.addElement(TENANT_ID);
            object.addAttribute(XSI_TYPE, XSD_STRING.getQualifiedName());
            object.addText((String)element3.next());
        }
        element3 = element.addElement(OR_LABELS);
        element3.addAttribute(XSI_TYPE, SOAP_ENC_ARRAY);
        element3.addAttribute(SOAP_ENC_ARRAYTYPE, STRING_ARRAY + "[" + this.optionalLabels.size() + "]");
        object = this.optionalLabels.iterator();
        while (object.hasNext()) {
            Element element4 = element3.addElement(TENANT_ID);
            element4.addAttribute(XSI_TYPE, XSD_STRING.getQualifiedName());
            element4.addText((String)object.next());
        }
        return element;
    }

    private Set<String> getIdentityLabels(Identity identity) throws SoapFaultException {
        TenancyInfo tenancyInfo = identity.getTenancy();
        if (tenancyInfo == null) {
            return null;
        }
        HashSet<String> hashSet = null;
        String string = tenancyInfo.getTenancy(TenancyInfo.TenancyType.READ_TENANTID);
        if (string == null || string.isEmpty()) {
            string = tenancyInfo.getTenancy(TenancyInfo.TenancyType.TENANTID);
        }
        if (string != null && !string.isEmpty()) {
            hashSet = new HashSet<String>();
            hashSet.add(string);
        }
        return hashSet;
    }

    @Override
    public void init(Element element) throws AccessControlException {
        String string;
        Object object2;
        this.destroy();
        List list = DocumentHelper.selectNodes((String)"./*[local-name()='andLabels']/*[local-name()='tenantID']", (Node)element);
        for (Object object2 : list) {
            string = DocumentHelper.getElementText((Element)object2);
            this.requiredLabels.add(string);
        }
        List list2 = DocumentHelper.selectNodes((String)"./*[local-name()='orLabels']/*[local-name()='tenantID']", (Node)element);
        object2 = list2.iterator();
        while (object2.hasNext()) {
            string = (Element)object2.next();
            String string2 = DocumentHelper.getElementText((Element)string);
            this.optionalLabels.add(string2);
        }
    }

    @Override
    public boolean isAccessGranted(Identity identity, String string) {
        boolean bl = false;
        if (this.isIdentityForSysAdmin(identity)) {
            bl = true;
        } else {
            try {
                Set<String> set = this.getIdentityLabels(identity);
                bl = this.checkRequiredLabels(set, string) && this.checkOptionalLabels(set, string);
            }
            catch (SoapFaultException soapFaultException) {
                // empty catch block
            }
        }
        return bl;
    }

    private boolean isIdentityForSysAdmin(Identity identity) {
        return identity.contains("::System Administrators");
    }

    @Override
    public void readFrom(ByteArrayInputStream byteArrayInputStream) throws IOException {
        int n;
        this.destroy();
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        long l = objectInputStream.readLong();
        if (l != 164087134871L) {
            throw new IOException("Unkown version: " + Long.toString(l));
        }
        int n2 = objectInputStream.readInt();
        objectInputStream.readInt();
        if (n2 > 1) {
            throw new IOException("Unsupported version: " + Integer.toString(n2));
        }
        int n3 = objectInputStream.readInt();
        for (n = 0; n < n3; ++n) {
            this.requiredLabels.add(objectInputStream.readUTF());
        }
        n = objectInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            this.optionalLabels.add(objectInputStream.readUTF());
        }
    }

    @Override
    public void writeTo(ByteArrayOutputStream byteArrayOutputStream) throws IOException {
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeLong(164087134871L);
        objectOutputStream.writeInt(1);
        objectOutputStream.writeInt(0);
        objectOutputStream.writeInt(this.requiredLabels.size());
        for (String string : this.requiredLabels) {
            objectOutputStream.writeUTF(string);
        }
        objectOutputStream.writeInt(this.optionalLabels.size());
        for (String string : this.optionalLabels) {
            objectOutputStream.writeUTF(string);
        }
        objectOutputStream.flush();
    }
}

