/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.accesscontrol;

import com.ibm.cognos.camaaa.internal.accesscontrol.Permission;
import com.ibm.cognos.camaaa.internal.accesscontrol.PolicyDescription;
import com.ibm.cognos.camaaa.internal.common.util.Blob;
import com.ibm.cognos.internal.camaaa.accesscontrol.AccessControlException;
import com.ibm.cognos.internal.camaaa.accesscontrol.Identity;
import com.ibm.cognos.internal.camaaa.accesscontrol.Policy;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.Vector;
import org.dom4j.Element;

class CAMPolicy
implements Policy {
    public static final short MAJOR_VERSION = 1;
    public static final int MAJOR_VERSION_OFFSET = 0;
    public static final short MINOR_VERSION = 1;
    public static final int MINOR_VERSION_OFFSET = 2;
    public static final int NB_PERMISSION_OFFSET = 4;
    public static final int PERMISSION_INDEX_TABLE_OFFSET = 8;
    public static final String ADMINISTRATOR_IDENTITY = "::System Administrators";
    private static final int SIZE_OF_INT = 4;
    private static final String UTF8_ENCODING = "UTF-8";
    private byte[] policyBlob = null;

    private boolean checkAccess(Identity identity, String string, int n) {
        boolean bl = false;
        try {
            int n2 = 8;
            int n3 = n * 4 + n2;
            boolean bl2 = false;
            block2: for (int i = 0; i < n; ++i) {
                String string2;
                int n4;
                if (bl2) {
                    return bl;
                }
                int n5 = Blob.getInt((byte[])this.policyBlob, (int)n2);
                n2 += 4;
                String string3 = Blob.getString((byte[])this.policyBlob, (int)(n5 += n3));
                if (string3.compareTo(string) != 0) continue;
                int n6 = Blob.getInt((byte[])this.policyBlob, (int)(n5 += string3.getBytes(UTF8_ENCODING).length + 1));
                n5 += 4;
                for (n4 = 0; n4 < n6; ++n4) {
                    string2 = Blob.getString((byte[])this.policyBlob, (int)n5);
                    if (identity.contains(string2)) {
                        bl = false;
                        bl2 = true;
                        break;
                    }
                    n5 += string2.getBytes(UTF8_ENCODING).length + 1;
                }
                if (bl2) continue;
                n6 = Blob.getInt((byte[])this.policyBlob, (int)n5);
                n5 += 4;
                for (n4 = 0; n4 < n6; ++n4) {
                    string2 = Blob.getString((byte[])this.policyBlob, (int)n5);
                    if (identity.contains(string2)) {
                        bl = true;
                        bl2 = true;
                        continue block2;
                    }
                    n5 += string2.getBytes(UTF8_ENCODING).length + 1;
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object clone() throws CloneNotSupportedException {
        CAMPolicy cAMPolicy = (CAMPolicy)super.clone();
        CAMPolicy cAMPolicy2 = this;
        synchronized (cAMPolicy2) {
            if (this.policyBlob != null) {
                cAMPolicy.policyBlob = (byte[])this.policyBlob.clone();
            }
            return cAMPolicy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        CAMPolicy cAMPolicy = this;
        synchronized (cAMPolicy) {
            this.policyBlob = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean equalsTo(byte[] byArray) {
        CAMPolicy cAMPolicy = this;
        synchronized (cAMPolicy) {
            boolean bl = true;
            if (this.policyBlob.length != byArray.length) {
                bl = false;
            }
            for (int i = 0; i < byArray.length; ++i) {
                if (this.policyBlob[i] == byArray[i]) continue;
                bl = false;
            }
            return bl;
        }
    }

    boolean equalsTo(CAMPolicy cAMPolicy) {
        Vector vector;
        boolean bl = true;
        Vector vector2 = this.getPermissions();
        if (vector2 == null | (vector = cAMPolicy.getPermissions()) == null) {
            throw new RuntimeException("PermissionVector is null for CAMPolicy in CAMPolicy.equals");
        }
        if (vector2.size() != vector.size()) {
            bl = false;
        } else {
            for (int i = 0; i < vector2.size(); ++i) {
                Permission permission = (Permission)vector2.get(i);
                boolean bl2 = false;
                for (int j = 0; j < vector.size(); ++j) {
                    Permission permission2 = (Permission)vector.get(j);
                    if (!permission2.getName().equals(permission.getName()) || !Arrays.equals(permission2.getGrantedIds(), permission.getGrantedIds()) || !Arrays.equals(permission2.getDeniedIds(), permission.getDeniedIds())) continue;
                    bl2 = true;
                    break;
                }
                if (bl2) continue;
                return false;
            }
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void formPolicyBlob(SortedMap sortedMap) throws AccessControlException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            Object object;
            Blob.writeShort((OutputStream)byteArrayOutputStream, (short)1);
            Blob.writeShort((OutputStream)byteArrayOutputStream, (short)1);
            Blob.writeInt((OutputStream)byteArrayOutputStream, (int)sortedMap.size());
            if (sortedMap != null && sortedMap.size() != 0) {
                Object object2;
                object = new ByteArrayOutputStream();
                ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
                Iterator iterator = sortedMap.values().iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    object2 = (Permission)iterator.next();
                    Blob.writeInt((OutputStream)object, (int)n);
                    ((Permission)object2).writeTo(byteArrayOutputStream2);
                    byteArrayOutputStream2.flush();
                    n = byteArrayOutputStream2.size();
                }
                ((OutputStream)object).flush();
                byteArrayOutputStream2.flush();
                object2 = ((ByteArrayOutputStream)object).toByteArray();
                if (object2 != null) {
                    byteArrayOutputStream.write((byte[])object2);
                }
                if ((object2 = (Object)byteArrayOutputStream2.toByteArray()) != null) {
                    byteArrayOutputStream.write((byte[])object2);
                }
                ((ByteArrayOutputStream)object).close();
                byteArrayOutputStream2.close();
            }
            object = this;
            synchronized (object) {
                this.policyBlob = byteArrayOutputStream.toByteArray();
            }
            byteArrayOutputStream.close();
        }
        catch (IOException iOException) {
            throw new AccessControlException("AAA_ACM_E_INVALID_FORMAT_FOR_BLOB", iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PolicyDescription formPolicyElement() {
        PolicyDescription policyDescription = new PolicyDescription();
        try {
            CAMPolicy cAMPolicy = this;
            synchronized (cAMPolicy) {
                if (this.policyBlob != null) {
                    int n = Blob.getInt((byte[])this.policyBlob, (int)4);
                    int n2 = 8;
                    int n3 = n * 4 + n2;
                    for (int i = 0; i < n; ++i) {
                        String string;
                        String string2;
                        int n4;
                        int n5 = Blob.getInt((byte[])this.policyBlob, (int)n2);
                        n2 += 4;
                        String string3 = Blob.getString((byte[])this.policyBlob, (int)(n5 += n3));
                        int n6 = Blob.getInt((byte[])this.policyBlob, (int)(n5 += string3.getBytes(UTF8_ENCODING).length + 1));
                        n5 += 4;
                        if (n6 > 0) {
                            for (n4 = 0; n4 < n6; ++n4) {
                                string2 = Blob.getString((byte[])this.policyBlob, (int)n5);
                                string = "CAMID(\"" + string2 + "\")";
                                policyDescription.addDeniedPermission(string, string3);
                                n5 += string2.getBytes(UTF8_ENCODING).length + 1;
                            }
                        }
                        n6 = Blob.getInt((byte[])this.policyBlob, (int)n5);
                        n5 += 4;
                        if (n6 <= 0) continue;
                        for (n4 = 0; n4 < n6; ++n4) {
                            string2 = Blob.getString((byte[])this.policyBlob, (int)n5);
                            string = "CAMID(\"" + string2 + "\")";
                            policyDescription.addGrantedPermission(string, string3);
                            n5 += string2.getBytes(UTF8_ENCODING).length + 1;
                        }
                    }
                }
            }
        }
        catch (IOException iOException) {
            return new PolicyDescription();
        }
        return policyDescription;
    }

    @Override
    public Element getDescription() {
        PolicyDescription policyDescription = this.formPolicyElement();
        return policyDescription.getRootElement();
    }

    private Vector getPermissions() {
        try {
            PolicyDescription policyDescription = this.formPolicyElement();
            SortedMap sortedMap = policyDescription.getPermissions();
            return new Vector(sortedMap.values());
        }
        catch (AccessControlException accessControlException) {
            return null;
        }
    }

    @Override
    public void init(Element element) throws AccessControlException {
        SortedMap sortedMap = PolicyDescription.getPermissions(element);
        this.formPolicyBlob(sortedMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAccessGranted(Identity identity, String string) {
        if (identity.contains(ADMINISTRATOR_IDENTITY)) {
            return true;
        }
        boolean bl = true;
        CAMPolicy cAMPolicy = this;
        synchronized (cAMPolicy) {
            int n;
            bl = this.validateBlob() ? ((n = Blob.getInt((byte[])this.policyBlob, (int)4)) == 0 ? false : this.checkAccess(identity, string, n)) : false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isBlobNull() {
        CAMPolicy cAMPolicy = this;
        synchronized (cAMPolicy) {
            return this.policyBlob == null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readFrom(ByteArrayInputStream byteArrayInputStream) throws IOException {
        if (byteArrayInputStream.available() <= 0) {
            return;
        }
        int n = -1;
        CAMPolicy cAMPolicy = this;
        synchronized (cAMPolicy) {
            this.policyBlob = new byte[byteArrayInputStream.available()];
            byteArrayInputStream.read(this.policyBlob);
            n = Blob.getShort((byte[])this.policyBlob, (int)0);
        }
        if (n != 1) {
            throw new IOException("Invalid policy blob version in CAMPolicy.readExternal");
        }
    }

    private boolean validateBlob() {
        boolean bl = true;
        if (this.policyBlob == null) {
            bl = false;
        } else if (Blob.getShort((byte[])this.policyBlob, (int)0) != 1) {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeTo(ByteArrayOutputStream byteArrayOutputStream) throws IOException {
        CAMPolicy cAMPolicy = this;
        synchronized (cAMPolicy) {
            if (this.policyBlob == null) {
                return;
            }
            byteArrayOutputStream.write(this.policyBlob);
        }
        byteArrayOutputStream.flush();
    }
}

