/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.accesscontrol;

import com.ibm.cognos.camaaa.internal.common.util.Blob;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.HashSet;
import java.util.Iterator;

class Permission {
    private final String permissionName;
    private final HashSet deniedIds;
    private final HashSet grantedIds;

    Permission(String string) {
        this.permissionName = new String(string);
        this.deniedIds = new HashSet();
        this.grantedIds = new HashSet();
    }

    void addDeniedId(String string) {
        if (string != null) {
            this.deniedIds.add(string);
        }
    }

    void addGrantedId(String string) {
        if (string != null) {
            this.grantedIds.add(string);
        }
    }

    void dump(StringWriter stringWriter) {
        stringWriter.write(this.permissionName);
        stringWriter.write("\n# of denied ID = " + this.deniedIds.size() + "\n");
        Iterator iterator = this.deniedIds.iterator();
        while (iterator.hasNext()) {
            stringWriter.write((String)iterator.next());
            stringWriter.write("\n");
        }
        stringWriter.write("# of granted ID = " + this.grantedIds.size() + "\n");
        iterator = this.grantedIds.iterator();
        while (iterator.hasNext()) {
            stringWriter.write((String)iterator.next());
            stringWriter.write("\n");
        }
    }

    String[] getDeniedIds() {
        return this.deniedIds.toArray(new String[this.deniedIds.size()]);
    }

    String[] getGrantedIds() {
        return this.grantedIds.toArray(new String[this.grantedIds.size()]);
    }

    String getName() {
        return this.permissionName;
    }

    void writeTo(OutputStream outputStream) throws IOException {
        Iterator iterator;
        Blob.writeUTF((OutputStream)outputStream, (String)this.getName());
        if (this.deniedIds != null) {
            Blob.writeInt((OutputStream)outputStream, (int)this.deniedIds.size());
            iterator = this.deniedIds.iterator();
            while (iterator.hasNext()) {
                Blob.writeUTF((OutputStream)outputStream, (String)((String)iterator.next()));
            }
        }
        if (this.grantedIds != null) {
            Blob.writeInt((OutputStream)outputStream, (int)this.grantedIds.size());
            iterator = this.grantedIds.iterator();
            while (iterator.hasNext()) {
                Blob.writeUTF((OutputStream)outputStream, (String)((String)iterator.next()));
            }
        }
    }
}

