/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.accesscontrol;

import com.ibm.cognos.camaaa.internal.accesscontrol.CAMIdentity;
import com.ibm.cognos.camaaa.internal.accesscontrol.Permission;
import com.ibm.cognos.internal.camaaa.accesscontrol.AccessControlException;
import java.util.HashMap;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

class PolicyDescription {
    private static final Namespace BIBUS_NS = new Namespace("bus", "http://developer.cognos.com/schemas/bibus/3/");
    private static final String SOAP_ENC_NS_PREFIX = "SOAP-ENC";
    private static final Namespace XSD_NS = new Namespace("xsd", "http://www.w3.org/2001/XMLSchema");
    private static final Namespace SOAP_ENC_NS = new Namespace("SOAP-ENC", "http://schemas.xmlsoap.org/soap/encoding/");
    private static final Namespace XSI_NS = new Namespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
    private static final QName POLICIES = QName.get((String)"policies", (Namespace)BIBUS_NS);
    private static final QName POLICY = QName.get((String)"policy", (Namespace)BIBUS_NS);
    private static final String VALUE = "value";
    private static final String ITEM = "item";
    private static final String PERMISSIONS = "permissions";
    private static final String SECURITYOBJECT = "securityObject";
    private static final String SEARCHPATH = "searchPath";
    private static final String NAME = "name";
    private static final String ACCESS = "access";
    private static final String GRANT = "grant";
    private static final String DENY = "deny";
    private static final QName PERMISSION = QName.get((String)"permission", (Namespace)BIBUS_NS);
    private static final QName ACCESS_ENUM = QName.get((String)"accessEnum", (Namespace)BIBUS_NS);
    private static final String BRACKET_START = "[";
    private static final String BRACKET_END = "]";
    private static final String SOAP_ENC_ARRAY = QName.get((String)"Array", (Namespace)SOAP_ENC_NS).getQualifiedName();
    private static final QName SOAP_ENC_ARRAYTYPE = QName.get((String)"arrayType", (Namespace)SOAP_ENC_NS);
    private static final QName XSD_STRING = QName.get((String)"string", (Namespace)XSD_NS);
    private static final QName XSI_TYPE = QName.get((String)"type", (Namespace)XSI_NS);
    private static final Namespace XML_NS = new Namespace("xml", "http://www.w3.org/XML/1998/namespace");
    private static final QName XML_SPACE = QName.get((String)"space", (Namespace)XML_NS);
    private static final String PRESERVE_STRING = "preserve";
    private final HashMap policyItems;
    private final Element policyRoot;
    private final Element valueElement;

    PolicyDescription() {
        Document document = DocumentFactory.getInstance().createDocument();
        this.policyRoot = document.addElement(POLICIES);
        this.policyRoot.addAttribute(XSI_TYPE, QName.get((String)"policyArrayProp", (Namespace)BIBUS_NS).getQualifiedName());
        this.valueElement = this.policyRoot.addElement(VALUE);
        this.valueElement.addAttribute(XSI_TYPE, SOAP_ENC_ARRAY);
        this.valueElement.addAttribute(SOAP_ENC_ARRAYTYPE, POLICY.getQualifiedName() + BRACKET_START + "0" + BRACKET_END);
        this.valueElement.add(SOAP_ENC_NS);
        this.valueElement.add(XSD_NS);
        this.policyItems = new HashMap();
    }

    private static String getIdentity(Element element) {
        String string;
        String string2 = null;
        Element element2 = (Element)element.selectSingleNode("./*[local-name()='securityObject']/*[local-name()='searchPath']/*[local-name()='value']");
        if (element2 != null && (string = element2.getTextTrim()) != null) {
            string2 = CAMIdentity.extractPolicyObjectID(string);
        }
        return string2;
    }

    static SortedMap getPermissions(Element element) throws AccessControlException {
        if (!(element.getQName().equals((Object)POLICIES) || element.getQName().getNamespaceURI().equals("") && element.getQName().getName().equals(POLICIES.getName()))) {
            throw new AccessControlException("AAA_ACM_E_INVALID_QNAME_FOR_POLICY_ELEMENT");
        }
        Element element2 = element.element(VALUE);
        List list = element2.elements();
        TreeMap treeMap = new TreeMap();
        for (int i = 0; i < list.size(); ++i) {
            List list2;
            Element element3 = (Element)list.get(i);
            String string = PolicyDescription.getIdentity(element3);
            if (string == null) {
                throw new AccessControlException("AAA_ACM_E_INVALID_QNAME_FOR_POLICY_ELEMENT");
            }
            Element element4 = element3.element(PERMISSIONS);
            if (element4 == null || (list2 = element4.elements()).size() == 0) continue;
            for (int j = 0; j < list2.size(); ++j) {
                PolicyDescription.parsePermissions(treeMap, string, (Element)list2.get(j));
            }
        }
        return treeMap;
    }

    private static void parsePermissions(SortedMap sortedMap, String string, Element element) {
        Element element2 = element.element(NAME);
        if (element2 == null) {
            return;
        }
        String string2 = element2.getTextTrim();
        Element element3 = element.element(ACCESS);
        if (element3 == null) {
            return;
        }
        String string3 = element3.getTextTrim();
        Permission permission = (Permission)sortedMap.get(string2);
        if (permission == null) {
            permission = new Permission(string2);
            sortedMap.put(string2, permission);
        }
        if (string3.compareTo(DENY) == 0) {
            permission.addDeniedId(string);
        } else if (string3.compareTo(GRANT) == 0) {
            permission.addGrantedId(string);
        }
    }

    void addDeniedPermission(String string, String string2) {
        Element element = this.getPolicyItem(string);
        Element element2 = element.element(PERMISSIONS);
        if (element2 == null) {
            element2 = element.addElement(PERMISSIONS);
            element2.addAttribute(XSI_TYPE, SOAP_ENC_ARRAY);
        }
        Element element3 = DocumentFactory.getInstance().createElement(ITEM);
        element3.addAttribute(XSI_TYPE, PERMISSION.getQualifiedName());
        Element element4 = element3.addElement(NAME);
        element4.addAttribute(XSI_TYPE, XSD_STRING.getQualifiedName());
        element4.addAttribute(XML_SPACE, PRESERVE_STRING);
        element4.addText(string2);
        Element element5 = element3.addElement(ACCESS);
        element5.addAttribute(XSI_TYPE, ACCESS_ENUM.getQualifiedName());
        element5.addText(DENY);
        element2.add(element3);
        int n = element2.nodeCount();
        element2.addAttribute(SOAP_ENC_ARRAYTYPE, PERMISSION.getQualifiedName() + BRACKET_START + n + BRACKET_END);
    }

    void addGrantedPermission(String string, String string2) {
        Element element = this.getPolicyItem(string);
        Element element2 = element.element(PERMISSIONS);
        if (element2 == null) {
            element2 = element.addElement(PERMISSIONS);
            element2.addAttribute(XSI_TYPE, SOAP_ENC_ARRAY);
        }
        Element element3 = DocumentFactory.getInstance().createElement(ITEM);
        element3.addAttribute(XSI_TYPE, PERMISSION.getQualifiedName());
        Element element4 = element3.addElement(NAME);
        element4.addAttribute(XSI_TYPE, XSD_STRING.getQualifiedName());
        element4.addAttribute(XML_SPACE, PRESERVE_STRING);
        element4.addText(string2);
        Element element5 = element3.addElement(ACCESS);
        element5.addAttribute(XSI_TYPE, ACCESS_ENUM.getQualifiedName());
        element5.addText(GRANT);
        element2.add(element3);
        int n = element2.nodeCount();
        element2.addAttribute(SOAP_ENC_ARRAYTYPE, PERMISSION.getQualifiedName() + BRACKET_START + n + BRACKET_END);
    }

    private Element addPolicyItem(String string) {
        String string2 = CAMIdentity.extractObjectId(string);
        if (string2 == null) {
            return null;
        }
        Element element = DocumentFactory.getInstance().createElement(ITEM);
        element.addAttribute(XSI_TYPE, POLICY.getQualifiedName());
        Element element2 = element.addElement(SECURITYOBJECT);
        element2.addAttribute(XSI_TYPE, QName.get((String)"nil", (Namespace)BIBUS_NS).getQualifiedName());
        Element element3 = element2.addElement(SEARCHPATH);
        element3.addAttribute(XSI_TYPE, QName.get((String)"stringProp", (Namespace)BIBUS_NS).getQualifiedName());
        Element element4 = element3.addElement(VALUE);
        element4.addAttribute(XSI_TYPE, XSD_STRING.getQualifiedName());
        element4.addAttribute(XML_SPACE, PRESERVE_STRING);
        element4.addText(string);
        List list = this.valueElement.elements();
        list.add(element);
        this.policyItems.put(string2, element);
        list = this.valueElement.elements();
        int n = list.size();
        this.valueElement.addAttribute(SOAP_ENC_ARRAYTYPE, POLICY.getQualifiedName() + BRACKET_START + n + BRACKET_END);
        return element;
    }

    SortedMap getPermissions() throws AccessControlException {
        return PolicyDescription.getPermissions(this.policyRoot);
    }

    Element getPolicyItem(String string) {
        String string2 = CAMIdentity.extractObjectId(string);
        Element element = null;
        if (string2 != null) {
            Element element2 = (Element)this.policyItems.get(string2);
            element = element2 != null ? element2 : this.addPolicyItem(string);
        }
        return element;
    }

    Element getRootElement() {
        return this.policyRoot;
    }
}

