/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.auth;

import com.ibm.cognos.camaaa.internal.auth.soap.TenancyInfo;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.common.messages.LocalizableMessage;
import com.ibm.cognos.camaaa.internal.msgsdk.camaaa_srvc.Message;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class TenancyInfoImpl
implements TenancyInfo {
    private static final long serialVersionUID = 187340189365L;
    private Map<TenancyInfo.TenancyType, Set<String>> tenantIDs = new HashMap<TenancyInfo.TenancyType, Set<String>>();
    private boolean dirty;
    private boolean isImpersonating;

    public TenancyInfoImpl() {
        this.tenantIDs.put(TenancyInfo.TenancyType.TENANTID, new HashSet());
        this.tenantIDs.put(TenancyInfo.TenancyType.READ_TENANTID, new HashSet());
        this.tenantIDs.put(TenancyInfo.TenancyType.WRITE_TENANTID, new HashSet());
        this.dirty = true;
    }

    public TenancyInfoImpl(String string, String string2, String string3) {
        this();
        this.setTenancy(TenancyInfo.TenancyType.TENANTID, string);
        this.setTenancy(TenancyInfo.TenancyType.READ_TENANTID, string2);
        this.setTenancy(TenancyInfo.TenancyType.WRITE_TENANTID, string3);
    }

    public void addTenancies(TenancyInfo.TenancyType tenancyType, String[] stringArray) throws SoapFaultException {
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        Set<String> set = this.tenantIDs.get(tenancyType);
        if (stringArray.length > 1 && (tenancyType == TenancyInfo.TenancyType.TENANTID || tenancyType == TenancyInfo.TenancyType.WRITE_TENANTID)) {
            throw new SoapFaultException("Server", (LocalizableMessage)new Message("AAA_CAP_E_SERVER_DID_SOMETHING_WRONG"), TenancyInfoImpl.class.toString(), null, "AAA_SYS_E_INTERNAL_ERROR", (LocalizableMessage)new Message("AAA_SYS_E_INTERNAL_ERROR"));
        }
        if (set.size() == 1 && (tenancyType == TenancyInfo.TenancyType.TENANTID || tenancyType == TenancyInfo.TenancyType.WRITE_TENANTID)) {
            if (!set.contains(stringArray[0])) {
                throw new SoapFaultException("Server", (LocalizableMessage)new Message("AAA_CAP_E_SERVER_DID_SOMETHING_WRONG"), TenancyInfoImpl.class.toString(), null, "AAA_SYS_E_INTERNAL_ERROR", (LocalizableMessage)new Message("AAA_SYS_E_INTERNAL_ERROR"));
            }
        } else {
            Collections.addAll(set, stringArray);
        }
        this.dirty = true;
    }

    public Object clone() throws CloneNotSupportedException {
        TenancyInfoImpl tenancyInfoImpl = (TenancyInfoImpl)super.clone();
        tenancyInfoImpl.tenantIDs = (HashMap)((HashMap)this.tenantIDs).clone();
        for (Map.Entry<TenancyInfo.TenancyType, Set<String>> entry : this.tenantIDs.entrySet()) {
            TenancyInfo.TenancyType tenancyType = entry.getKey();
            HashSet hashSet = (HashSet)((HashSet)entry.getValue()).clone();
            tenancyInfoImpl.tenantIDs.put(tenancyType, hashSet);
        }
        return tenancyInfoImpl;
    }

    public String[] getTenancies(TenancyInfo.TenancyType tenancyType) {
        Set<String> set = this.tenantIDs.get(tenancyType);
        if (set.isEmpty()) {
            return null;
        }
        return set.toArray(new String[set.size()]);
    }

    public String getTenancy(TenancyInfo.TenancyType tenancyType) throws SoapFaultException {
        Set<String> set = this.tenantIDs.get(tenancyType);
        if (set.isEmpty()) {
            return null;
        }
        if (set.size() > 1) {
            throw new SoapFaultException("Server", (LocalizableMessage)new Message("AAA_CAP_E_SERVER_DID_SOMETHING_WRONG"), TenancyInfoImpl.class.toString(), null, "AAA_SYS_E_INTERNAL_ERROR", (LocalizableMessage)new Message("AAA_SYS_E_INTERNAL_ERROR"));
        }
        return set.iterator().next();
    }

    public boolean hasStateChanged() {
        return this.dirty;
    }

    public boolean isUnset() {
        return this.tenantIDs.isEmpty();
    }

    public boolean isImpersonating() {
        return this.isImpersonating;
    }

    public void setIsImpersonating(boolean bl) {
        this.isImpersonating = bl;
        this.dirty = true;
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        long l = objectInput.readLong();
        if (l != 187340189365L) {
            throw new IOException("Unkown version: " + Long.toString(l));
        }
        int n = objectInput.readInt();
        TenancyInfo.TenancyType tenancyType = TenancyInfo.TenancyType.values()[n];
        while (tenancyType != TenancyInfo.TenancyType.INVALID_TENANTID) {
            int n2 = objectInput.readInt();
            for (int i = 0; i < n2; ++i) {
                String string = objectInput.readUTF();
                this.setTenancy(tenancyType, string);
            }
            n = objectInput.readInt();
            tenancyType = TenancyInfo.TenancyType.values()[n];
        }
        this.setIsImpersonating(objectInput.readBoolean());
    }

    public void resetChangeIndicator() {
        this.dirty = false;
    }

    public void setTenancies(TenancyInfo.TenancyType tenancyType, String[] stringArray) throws SoapFaultException {
        Set<String> set = this.tenantIDs.get(tenancyType);
        if (stringArray == null || stringArray.length == 0) {
            set.clear();
        } else {
            if (stringArray.length > 1 && (tenancyType == TenancyInfo.TenancyType.TENANTID || tenancyType == TenancyInfo.TenancyType.WRITE_TENANTID)) {
                throw new SoapFaultException("Server", (LocalizableMessage)new Message("AAA_CAP_E_SERVER_DID_SOMETHING_WRONG"), TenancyInfoImpl.class.toString(), null, "AAA_SYS_E_INTERNAL_ERROR", (LocalizableMessage)new Message("AAA_SYS_E_INTERNAL_ERROR"));
            }
            set.clear();
            Collections.addAll(set, stringArray);
        }
        this.dirty = true;
    }

    public void setTenancy(TenancyInfo.TenancyType tenancyType, String string) {
        Set<String> set = this.tenantIDs.get(tenancyType);
        if (string == null) {
            set.clear();
        } else {
            set.clear();
            set.add(string);
        }
        this.dirty = true;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeLong(187340189365L);
        for (Map.Entry<TenancyInfo.TenancyType, Set<String>> entry : this.tenantIDs.entrySet()) {
            objectOutput.writeInt(entry.getKey().ordinal());
            Set<String> set = entry.getValue();
            objectOutput.writeInt(set.size());
            for (String string : set) {
                objectOutput.writeUTF(string);
            }
        }
        objectOutput.writeInt(TenancyInfo.TenancyType.INVALID_TENANTID.ordinal());
        objectOutput.writeBoolean(this.isImpersonating());
        objectOutput.flush();
    }
}

