/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.common.soap;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.CAMFactory;
import com.cognos.accman.jcam.crypto.EncryptingSession;
import com.cognos.cclcfgapi.base64;
import com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.jaxen.Context;
import org.jaxen.Function;
import org.jaxen.FunctionCallException;
import org.jaxen.Navigator;
import org.jaxen.function.StringFunction;

public class DecryptTextFunction
implements Function {
    private static final String ENCRYPTED_ATTRIBUTE = "encrypted";
    private CAMFactory camFactory;
    private boolean parseContent;

    DecryptTextFunction() {
        this.parseContent = true;
        this.camFactory = null;
    }

    DecryptTextFunction(boolean bl) {
        this.parseContent = bl;
        this.camFactory = null;
    }

    public Object call(Context context, List list) throws FunctionCallException {
        Object object = null;
        if (!list.isEmpty()) {
            for (Object e : list) {
                if (e instanceof List) {
                    object = this.call(context, (List)e);
                    continue;
                }
                if (!(e instanceof Element)) continue;
                Element element = (Element)e;
                object = this.evaluate(context, element);
            }
        }
        return object;
    }

    private String decrypt(String string) {
        try {
            if (this.camFactory == null) {
                this.camFactory = new CAMFactory();
                this.camFactory.initialize("<initializeDocument><serviceID>DecryptTextFunction</serviceID></initializeDocument>".getBytes());
            }
            byte[] byArray = base64.decode((int)0, (String)string);
            EncryptingSession encryptingSession = this.camFactory.createEncryptingSession();
            return new String(encryptingSession.decryptData(byArray), "UTF-8");
        }
        catch (CAMCryptoException cAMCryptoException) {
            throw new RuntimeException(cAMCryptoException);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    private Object evaluateEncryptedText(Context context, Element element) {
        String string = StringFunction.evaluate((Object)element, (Navigator)context.getNavigator());
        String string2 = "";
        if (string != null) {
            string2 = this.decrypt(string);
            if (this.parseContent) {
                return this.parse(string2);
            }
        }
        return DocumentFactory.getInstance().createText(string2);
    }

    private Object evaluate(Context context, Element element) {
        String string = element.attributeValue(ENCRYPTED_ATTRIBUTE);
        if (string != null && Boolean.valueOf(string).booleanValue()) {
            return this.evaluateEncryptedText(context, element);
        }
        if (element.isTextOnly()) {
            return element;
        }
        return (Element)element.elements().get(0);
    }

    private Element parse(String string) {
        if (string != null) {
            try {
                return DocumentHelper.parseText(string).getRootElement();
            }
            catch (DocumentException documentException) {
                throw new RuntimeException(documentException);
            }
        }
        return null;
    }
}

