/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.common.soap;

import com.cognos.pogo.pdk.xml.PooledSAXReader;
import com.cognos.pogo.pdk.xml.SAXReaderPool;
import com.ibm.cognos.camaaa.internal.common.soap.BiBusNamespaceContext;
import com.ibm.cognos.camaaa.internal.common.soap.DecryptTextFunction;
import com.ibm.cognos.camaaa.internal.common.soap.ElementTextFunction;
import com.ibm.cognos.camaaa.internal.common.soap.XMLConstants;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.dom4j.Attribute;
import org.dom4j.Branch;
import org.dom4j.Comment;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.QName;
import org.dom4j.Text;
import org.dom4j.Visitor;
import org.dom4j.VisitorSupport;
import org.dom4j.XPath;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.dom4j.util.NodeComparator;
import org.jaxen.Function;
import org.jaxen.FunctionContext;
import org.jaxen.NamespaceContext;
import org.jaxen.VariableContext;
import org.jaxen.XPathFunctionContext;
import org.xml.sax.SAXException;

public final class DocumentHelper {
    private static final DecryptTextFunction DECRYPT_TEXT_FUNCTION = new DecryptTextFunction();
    private static final DecryptTextFunction DECRYPT_PASSWORD_TEXT_FUNCTION = new DecryptTextFunction(false);
    private static final ElementTextFunction ELEMENT_TEXT_FUNCTION = new ElementTextFunction();
    private static final String UTF8_ENCODING = "UTF-8";

    private DocumentHelper() {
    }

    public static XPath createXPath(String string) {
        XPath xPath = DocumentFactory.getInstance().createXPath(string);
        XPathFunctionContext xPathFunctionContext = new XPathFunctionContext();
        xPathFunctionContext.registerFunction("http://developer.cognos.com/schemas/CAM/AAA/2/", "element-text", (Function)ELEMENT_TEXT_FUNCTION);
        xPathFunctionContext.registerFunction("http://developer.cognos.com/schemas/CAM/AAA/2/", "decrypt-text", (Function)DECRYPT_TEXT_FUNCTION);
        xPathFunctionContext.registerFunction("http://developer.cognos.com/schemas/CAM/AAA/2/", "decrypt-password-text", (Function)DECRYPT_PASSWORD_TEXT_FUNCTION);
        xPath.setFunctionContext((FunctionContext)xPathFunctionContext);
        xPath.setNamespaceContext((NamespaceContext)new BiBusNamespaceContext());
        return xPath;
    }

    public static XPath createXPath(String string, VariableContext variableContext) {
        XPath xPath = DocumentHelper.createXPath(string);
        xPath.setVariableContext(variableContext);
        return xPath;
    }

    public static String getChildElementText(Element element, String string) {
        Element element2 = element.element(string);
        return DocumentHelper.getElementText(element2);
    }

    public static String getChildElementText(Element element, QName qName) {
        Element element2 = element.element(qName);
        return DocumentHelper.getElementText(element2);
    }

    private static List getElementList(List list) {
        if (list != null && list.size() > 0) {
            ArrayList<Node> arrayList = new ArrayList<Node>();
            for (Node node : list) {
                if (node.getNodeType() != 1) continue;
                arrayList.add(node);
            }
            return arrayList;
        }
        return null;
    }

    public static String getElementText(Element element) {
        String string;
        if (!(element == null || (string = element.attributeValue(XMLConstants.XSI_NIL)) != null && Boolean.parseBoolean(string))) {
            return element.getText();
        }
        return null;
    }

    private static PooledSAXReader getSaxReader() {
        SAXReaderPool sAXReaderPool = SAXReaderPool.getInstance();
        PooledSAXReader pooledSAXReader = sAXReaderPool.get();
        return pooledSAXReader;
    }

    public static Document parse(InputStream inputStream) throws DocumentException {
        PooledSAXReader pooledSAXReader = DocumentHelper.getSaxReader();
        try {
            Document document = pooledSAXReader.read(inputStream);
            return document;
        }
        finally {
            pooledSAXReader.release();
        }
    }

    public static void addMissingAttribute(Element element, QName qName, String string) {
        Attribute attribute = element.attribute(qName);
        if (attribute == null) {
            element.addAttribute(qName, string);
        }
    }

    public static String createQualifiedElementName(String string, String string2) {
        return string + ":" + string2;
    }

    public static boolean isXsiNil(Element element) {
        Attribute attribute = element.attribute(XMLConstants.XSI_NIL);
        if (attribute != null) {
            return Boolean.valueOf(attribute.getText());
        }
        return false;
    }

    public static void removeAttribute(Element element, QName qName) {
        Attribute attribute = element.attribute(qName);
        if (attribute != null) {
            element.remove(attribute);
        }
    }

    public static Document parse(Reader reader) throws DocumentException {
        PooledSAXReader pooledSAXReader = DocumentHelper.getSaxReader();
        try {
            Document document = pooledSAXReader.read(reader);
            return document;
        }
        finally {
            pooledSAXReader.release();
        }
    }

    public static Document parseText(String string) throws DocumentException {
        PooledSAXReader pooledSAXReader = DocumentHelper.getSaxReader();
        try {
            Document document = pooledSAXReader.read((Reader)new StringReader(string));
            return document;
        }
        finally {
            pooledSAXReader.release();
        }
    }

    public static void removeMatchedNodes(Element element, String[] stringArray) {
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.addAll(DocumentHelper.selectNodes(stringArray[i], (Node)element));
        }
        for (Node node : arrayList) {
            node.getParent().remove(node);
        }
    }

    public static void removeMatchedNodes(Element element, XPath[] xPathArray) {
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < xPathArray.length; ++i) {
            arrayList.addAll(DocumentHelper.selectNodes(xPathArray[i], (Node)element));
        }
        for (Node node : arrayList) {
            node.getParent().remove(node);
        }
    }

    public static List selectElements(String string, List list) {
        List list2 = DocumentHelper.selectNodes(string, list);
        return DocumentHelper.getElementList(list2);
    }

    public static List selectElements(String string, Node node) {
        List list = DocumentHelper.selectNodes(string, node);
        return DocumentHelper.getElementList(list);
    }

    public static List selectElements(String string, VariableContext variableContext, Node node) {
        List list = DocumentHelper.selectNodes(string, variableContext, node);
        return DocumentHelper.getElementList(list);
    }

    public static List selectElements(XPath xPath, Node node) {
        List list = DocumentHelper.selectNodes(xPath, node);
        return DocumentHelper.getElementList(list);
    }

    public static List selectNodes(String string, List list) {
        if (list == null) {
            return new ArrayList();
        }
        XPath xPath = DocumentHelper.createXPath(string);
        return xPath.selectNodes((Object)list);
    }

    public static List selectNodes(String string, Node node) {
        if (node == null) {
            return new ArrayList();
        }
        XPath xPath = DocumentHelper.createXPath(string);
        return xPath.selectNodes((Object)node);
    }

    public static List selectNodes(String string, VariableContext variableContext, Node node) {
        if (node == null) {
            return new ArrayList();
        }
        XPath xPath = DocumentHelper.createXPath(string, variableContext);
        return xPath.selectNodes((Object)node);
    }

    public static List selectNodes(XPath xPath, Node node) {
        if (node == null) {
            return new ArrayList();
        }
        return xPath.selectNodes((Object)node);
    }

    public static Element selectSingleElement(String string, Node node) {
        List list = DocumentHelper.selectElements(string, node);
        if (list != null) {
            return (Element)list.get(0);
        }
        return null;
    }

    public static Element selectSingleElement(XPath xPath, Node node) {
        List list = DocumentHelper.selectElements(xPath, node);
        List list2 = DocumentHelper.getElementList(list);
        if (list2 != null) {
            return (Element)list2.get(0);
        }
        return null;
    }

    public static Node selectSingleNode(String string, Node node) {
        if (node == null) {
            return null;
        }
        XPath xPath = DocumentHelper.createXPath(string);
        return xPath.selectSingleNode((Object)node);
    }

    public static Node selectSingleNode(XPath xPath, Node node) {
        if (node == null) {
            return null;
        }
        return xPath.selectSingleNode((Object)node);
    }

    public static String toCompactUtf8String(Element element, boolean bl) throws SAXException {
        OutputFormat outputFormat = OutputFormat.createCompactFormat();
        outputFormat.setSuppressDeclaration(bl);
        outputFormat.setEncoding(UTF8_ENCODING);
        outputFormat.setExpandEmptyElements(true);
        outputFormat.setTrimText(false);
        return DocumentHelper.toXmlString(element, outputFormat);
    }

    public static String toPrettyPrintUtf8String(Element element, boolean bl) throws SAXException {
        OutputFormat outputFormat = OutputFormat.createPrettyPrint();
        outputFormat.setSuppressDeclaration(bl);
        outputFormat.setEncoding(UTF8_ENCODING);
        outputFormat.setExpandEmptyElements(true);
        outputFormat.setTrimText(false);
        outputFormat.setNewlines(true);
        return DocumentHelper.toXmlString(element, outputFormat);
    }

    public static String toXmlString(Element element, OutputFormat outputFormat) throws SAXException {
        String string = null;
        if (element != null) {
            element.normalize();
            try {
                StringWriter stringWriter = new StringWriter();
                XMLWriter xMLWriter = new XMLWriter((Writer)stringWriter, outputFormat);
                xMLWriter.startDocument();
                xMLWriter.write(element);
                xMLWriter.endDocument();
                xMLWriter.flush();
                xMLWriter.close();
                string = stringWriter.toString();
                stringWriter.close();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new RuntimeException(unsupportedEncodingException);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        return string;
    }

    public static String valueOf(String string, Node node) {
        return DocumentHelper.valueOf(string, node, null);
    }

    public static String valueOf(String string, Node node, String string2) {
        List list = DocumentHelper.selectNodes(string, node);
        if (list != null && list.size() > 0) {
            return DocumentHelper.valueOfFromNodeList(list);
        }
        return string2;
    }

    public static String valueOf(XPath xPath, Node node) {
        return DocumentHelper.valueOf(xPath, node, null);
    }

    public static String valueOf(XPath xPath, Node node, String string) {
        List list = DocumentHelper.selectNodes(xPath, node);
        if (list != null && list.size() > 0) {
            return DocumentHelper.valueOfFromNodeList(list);
        }
        return string;
    }

    private static String valueOfFromNodeList(List list) {
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        for (Node node : list) {
            if (node == null || node.getStringValue() == null) continue;
            stringBuffer.append(node.getStringValue());
            bl = true;
        }
        if (bl) {
            return stringBuffer.toString();
        }
        return null;
    }

    public static boolean isConfigurationDifferent(List list, List list2) {
        boolean bl = false;
        if (list.size() != list2.size()) {
            bl = true;
        } else {
            Iterator iterator = list.iterator();
            Iterator iterator2 = list2.iterator();
            while (iterator.hasNext() && iterator2.hasNext() && !bl) {
                Node node = (Node)iterator.next();
                Node node2 = (Node)iterator2.next();
                bl = DocumentHelper.isConfigurationDifferent(node, node2);
            }
        }
        return bl;
    }

    public static boolean isConfigurationDifferent(Node node, Node node2) {
        boolean bl = false;
        NodeComparator nodeComparator = new NodeComparator();
        if (node != null && node2 != null) {
            DocumentHelper.normalizeAndPrune(node);
            DocumentHelper.normalizeAndPrune(node2);
            bl = nodeComparator.compare(node, node2) != 0;
        } else {
            bl = node == null && node2 == null;
        }
        return bl;
    }

    private static void normalizeAndPrune(Node node) {
        if (node.getNodeType() == 1 || node.getNodeType() == 9) {
            ((Branch)node).normalize();
            DocumentHelper.prune((Branch)node);
        }
    }

    private static boolean isSimpleType(Element element) {
        boolean bl = false;
        Attribute attribute = element.attribute(XMLConstants.XSI_TYPE);
        if (attribute != null) {
            String string = attribute.getStringValue();
            if (string.equals("cfg:credential")) {
                Attribute attribute2 = element.attribute("encrypted");
                bl = attribute2 != null && Boolean.getBoolean(attribute2.getStringValue());
            } else if (string.equals("xsd:string") || string.equals("xsd:int") || string.equals("cfg:hostPort") || string.equals("xsd:boolean") || string.equals("cfg:filePath") || string.equals("xsd:anyURI") || string.equals("cfg:anyPathURI") || string.equals("xsd:unsignedShort") || string.equals("xsd:positiveInteger")) {
                bl = true;
            }
        }
        return bl;
    }

    private static boolean isComplexType(Element element) {
        return !DocumentHelper.isSimpleType(element);
    }

    private static void prune(Branch branch) {
        PruningVisitor pruningVisitor = new PruningVisitor();
        branch.accept((Visitor)pruningVisitor);
        pruningVisitor.removeNodesToPrune();
    }

    public static class PruningVisitor
    extends VisitorSupport {
        private List<Node> toBePruned = new ArrayList<Node>();

        void reset() {
            this.toBePruned.clear();
        }

        public void visit(Comment comment) {
            this.toBePruned.add((Node)comment);
        }

        public void visit(Text text) {
            if (text.getParent() != null && DocumentHelper.isComplexType(text.getParent())) {
                this.toBePruned.add((Node)text);
            }
        }

        public void removeNodesToPrune() {
            ListIterator<Node> listIterator = this.toBePruned.listIterator();
            while (listIterator.hasNext()) {
                Node node = listIterator.next();
                node.getParent().remove(node);
            }
            this.reset();
        }
    }
}

