/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.common.util;

import java.io.IOException;
import java.io.OutputStream;

public final class Blob {
    private static final String UTF8_ENCODING = "UTF-8";

    private Blob() {
    }

    public static boolean getBoolean(byte[] byArray, int n) {
        return byArray[n] != 0;
    }

    public static char getChar(byte[] byArray, int n) {
        return (char)(((byArray[n + 1] & 0xFF) << 0) + ((byArray[n + 0] & 0xFF) << 8));
    }

    public static double getDouble(byte[] byArray, int n) {
        long l = (((long)byArray[n + 7] & 0xFFL) << 0) + (((long)byArray[n + 6] & 0xFFL) << 8) + (((long)byArray[n + 5] & 0xFFL) << 16) + (((long)byArray[n + 4] & 0xFFL) << 24) + (((long)byArray[n + 3] & 0xFFL) << 32) + (((long)byArray[n + 2] & 0xFFL) << 40) + (((long)byArray[n + 1] & 0xFFL) << 48) + (((long)byArray[n + 0] & 0xFFL) << 56);
        return Double.longBitsToDouble(l);
    }

    public static float getFloat(byte[] byArray, int n) {
        int n2 = ((byArray[n + 3] & 0xFF) << 0) + ((byArray[n + 2] & 0xFF) << 8) + ((byArray[n + 1] & 0xFF) << 16) + ((byArray[n + 0] & 0xFF) << 24);
        return Float.intBitsToFloat(n2);
    }

    public static int getInt(byte[] byArray, int n) {
        return ((byArray[n + 3] & 0xFF) << 0) + ((byArray[n + 2] & 0xFF) << 8) + ((byArray[n + 1] & 0xFF) << 16) + ((byArray[n + 0] & 0xFF) << 24);
    }

    public static long getLong(byte[] byArray, int n) {
        return (((long)byArray[n + 7] & 0xFFL) << 0) + (((long)byArray[n + 6] & 0xFFL) << 8) + (((long)byArray[n + 5] & 0xFFL) << 16) + (((long)byArray[n + 4] & 0xFFL) << 24) + (((long)byArray[n + 3] & 0xFFL) << 32) + (((long)byArray[n + 2] & 0xFFL) << 40) + (((long)byArray[n + 1] & 0xFFL) << 48) + (((long)byArray[n + 0] & 0xFFL) << 56);
    }

    public static short getShort(byte[] byArray, int n) {
        return (short)(((byArray[n + 1] & 0xFF) << 0) + ((byArray[n + 0] & 0xFF) << 8));
    }

    public static String getString(byte[] byArray, int n) throws IOException {
        int n2 = 0;
        for (int i = n; i < byArray.length && byArray[i] != 0; ++i) {
            ++n2;
        }
        return new String(byArray, n, n2, UTF8_ENCODING);
    }

    public static void putBoolean(byte[] byArray, int n, boolean bl) {
        byArray[n] = bl ? (byte)1 : 0;
    }

    public static void putChar(byte[] byArray, int n, char c) {
        byArray[n + 1] = (byte)(c >>> 0);
        byArray[n + 0] = (byte)(c >>> 8);
    }

    public static void putDouble(byte[] byArray, int n, double d) {
        long l = Double.doubleToLongBits(d);
        byArray[n + 7] = (byte)(l >>> 0);
        byArray[n + 6] = (byte)(l >>> 8);
        byArray[n + 5] = (byte)(l >>> 16);
        byArray[n + 4] = (byte)(l >>> 24);
        byArray[n + 3] = (byte)(l >>> 32);
        byArray[n + 2] = (byte)(l >>> 40);
        byArray[n + 1] = (byte)(l >>> 48);
        byArray[n + 0] = (byte)(l >>> 56);
    }

    public static void putFloat(byte[] byArray, int n, float f) {
        int n2 = Float.floatToIntBits(f);
        byArray[n + 3] = (byte)(n2 >>> 0);
        byArray[n + 2] = (byte)(n2 >>> 8);
        byArray[n + 1] = (byte)(n2 >>> 16);
        byArray[n + 0] = (byte)(n2 >>> 24);
    }

    public static void putInt(byte[] byArray, int n, int n2) {
        byArray[n + 3] = (byte)(n2 >>> 0);
        byArray[n + 2] = (byte)(n2 >>> 8);
        byArray[n + 1] = (byte)(n2 >>> 16);
        byArray[n + 0] = (byte)(n2 >>> 24);
    }

    public static void putLong(byte[] byArray, int n, long l) {
        byArray[n + 7] = (byte)(l >>> 0);
        byArray[n + 6] = (byte)(l >>> 8);
        byArray[n + 5] = (byte)(l >>> 16);
        byArray[n + 4] = (byte)(l >>> 24);
        byArray[n + 3] = (byte)(l >>> 32);
        byArray[n + 2] = (byte)(l >>> 40);
        byArray[n + 1] = (byte)(l >>> 48);
        byArray[n + 0] = (byte)(l >>> 56);
    }

    public static void putShort(byte[] byArray, int n, short s) {
        byArray[n + 1] = (byte)(s >>> 0);
        byArray[n + 0] = (byte)(s >>> 8);
    }

    public static void writeInt(OutputStream outputStream, int n) throws IOException {
        byte[] byArray = new byte[4];
        Blob.putInt(byArray, 0, n);
        outputStream.write(byArray);
    }

    public static void writeShort(OutputStream outputStream, short s) throws IOException {
        byte[] byArray = new byte[2];
        Blob.putShort(byArray, 0, s);
        outputStream.write(byArray);
    }

    public static void writeUTF(OutputStream outputStream, String string) throws IOException {
        byte[] byArray = string.getBytes(UTF8_ENCODING);
        outputStream.write(byArray);
        outputStream.write(0);
    }
}

