/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.common.util;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.CAMFactory;
import com.ibm.cognos.camaaa.internal.common.exception.LocalizableException;
import com.ibm.cognos.camaaa.internal.common.messages.LocalizableMessage;
import com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper;
import com.ibm.cognos.camaaa.internal.common.util.CAMAAServiceCommunicator;
import com.ibm.cognos.camaaa.internal.msgsdk.camaaa_srvc.Message;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.dom4j.Document;
import org.dom4j.DocumentException;

public class CAMAAServiceHttpCommunicator
implements CAMAAServiceCommunicator {
    static final String INTERNAL_DISPATCHER = "internalDispatcher";
    private HttpClient httpClient;
    private final String dispatcherURL;

    CAMAAServiceHttpCommunicator(HttpClient httpClient, String string) {
        this.httpClient = httpClient;
        this.dispatcherURL = string;
    }

    public CAMAAServiceHttpCommunicator(URL uRL, int n) throws LocalizableException {
        this(CAMAAServiceHttpCommunicator.createHttpClient(uRL, new CAMFactory(), n), uRL.getPath());
    }

    static HttpClient createHttpClient(URL uRL, CAMFactory cAMFactory, int n) throws LocalizableException {
        try {
            cAMFactory.initialize("<initializeDocument><serviceID>CAMAAA_Com</serviceID></initializeDocument>".getBytes());
            HttpClient httpClient = cAMFactory.createHttpClient(uRL);
            if (httpClient != null) {
                MultiThreadedHttpConnectionManager multiThreadedHttpConnectionManager = new MultiThreadedHttpConnectionManager();
                HttpConnectionManagerParams httpConnectionManagerParams = new HttpConnectionManagerParams();
                httpConnectionManagerParams.setMaxTotalConnections(n);
                multiThreadedHttpConnectionManager.setParams(httpConnectionManagerParams);
                httpClient.setHttpConnectionManager((HttpConnectionManager)multiThreadedHttpConnectionManager);
            }
            return httpClient;
        }
        catch (CAMCryptoException cAMCryptoException) {
            throw new LocalizableException((LocalizableMessage)new Message("AAA_CFG_E_CRYPTO_INIT_FAILED"), (Throwable)cAMCryptoException);
        }
    }

    @Override
    public void terminate() {
        if (this.httpClient != null) {
            HttpConnectionManager httpConnectionManager = this.httpClient.getHttpConnectionManager();
            if (httpConnectionManager instanceof MultiThreadedHttpConnectionManager) {
                ((MultiThreadedHttpConnectionManager)httpConnectionManager).shutdown();
            }
            this.httpClient = null;
        }
    }

    private PostMethod createPostMethod(String string, String string2) throws LocalizableException {
        PostMethod postMethod = new PostMethod(this.dispatcherURL);
        postMethod.addRequestHeader("soapaction", string2);
        try {
            postMethod.setRequestEntity((RequestEntity)new StringRequestEntity(string, "text/xml", "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new LocalizableException((LocalizableMessage)new Message("AAA_SYS_E_SERVER_COMMUNICATION_ERROR"), (Throwable)unsupportedEncodingException);
        }
        return postMethod;
    }

    private Document executeMethod(PostMethod postMethod) throws LocalizableException {
        try {
            if (this.httpClient == null) {
                throw new IllegalStateException();
            }
            this.httpClient.setState(new HttpState());
            this.httpClient.executeMethod((HttpMethod)postMethod);
            Document document = this.readResponse(postMethod);
            postMethod.releaseConnection();
            return document;
        }
        catch (IOException iOException) {
            throw new LocalizableException((LocalizableMessage)new Message("AAA_SYS_E_SERVER_COMMUNICATION_ERROR"), (Throwable)iOException);
        }
        catch (DocumentException documentException) {
            throw new LocalizableException((LocalizableMessage)new Message("AAA_SYS_E_SERVER_RESPONSE_ERROR"), (Throwable)documentException);
        }
    }

    @Override
    public Document processSoapRequest(Document document, String string) throws LocalizableException {
        return this.processSoapRequest(document.asXML(), string);
    }

    @Override
    public Document processSoapRequest(String string, String string2) throws LocalizableException {
        PostMethod postMethod = this.createPostMethod(string, string2);
        return this.executeMethod(postMethod);
    }

    private Document readResponse(PostMethod postMethod) throws IOException, DocumentException {
        String string = postMethod.getResponseBodyAsString();
        if (string.startsWith("<html")) {
            throw new IOException(string);
        }
        return DocumentHelper.parseText(string);
    }
}

