/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.common.util;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.ICCLConfiguration;
import java.util.Locale;

public final class LocaleUtil {
    private static ICCLConfiguration cclConfig = CCLConfigurationFactory.getInstance();
    private static final int CONTENT_LOCALE_TYPE = 1;
    private static final int PRODUCT_LOCALE_TYPE = 2;
    private static final int GENERAL_LOCALE_TYPE = 3;

    private LocaleUtil() {
    }

    public static Locale createContentLocale(String string, Locale locale) {
        return LocaleUtil.createLocaleObject(1, string, locale);
    }

    public static Locale createLocale(String string, Locale locale) {
        return LocaleUtil.createLocaleObject(3, string, locale);
    }

    private static Locale createLocaleObject(int n, String string, Locale locale) {
        Locale locale2 = null;
        if (string != null && string.length() > 0) {
            try {
                String string2 = null;
                switch (n) {
                    case 1: {
                        string2 = cclConfig.mapContentLocale(string, true);
                        break;
                    }
                    case 2: {
                        string2 = cclConfig.mapProductLocale(string, true);
                        break;
                    }
                    default: {
                        string2 = cclConfig.normalizeLocale(string);
                    }
                }
                int n2 = string2.indexOf("-");
                String string3 = "";
                String string4 = "";
                if (n2 == -1) {
                    string3 = string2;
                } else {
                    string3 = string2.substring(0, n2);
                    string4 = string2.substring(n2 + 1);
                }
                if (string3.length() > 0) {
                    locale2 = new Locale(string3, string4);
                }
            }
            catch (CCLConfigurationException cCLConfigurationException) {
                // empty catch block
            }
        }
        if (locale2 == null) {
            locale2 = LocaleUtil.createDefaultLocale(locale);
        }
        return locale2;
    }

    private static Locale createDefaultLocale(Locale locale) {
        Locale locale2 = null;
        if (locale != null) {
            try {
                String string = locale.getLanguage();
                String string2 = cclConfig.normalizeLocale(string);
                locale2 = new Locale(string2, "");
            }
            catch (CCLConfigurationException cCLConfigurationException) {
                // empty catch block
            }
        }
        return locale2;
    }

    public static Locale createProductLocale(String string, Locale locale) {
        return LocaleUtil.createLocaleObject(2, string, locale);
    }
}

