/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.common.util;

import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.ICCLConfiguration;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Properties;

public class ReadProperties {
    private static final String AAA_PROPERTIES_FILE = "/configuration/AAA.properties";
    private static ICCLConfiguration cclConfig = CCLConfigurationFactory.getInstance();
    private static final String TRACE_SETTIG_TRUE_VALUE = "true";
    private boolean traceException;
    private boolean traceLogic;
    private PrintStream printStream;
    private Properties properties;

    public ReadProperties() {
        this.traceException = false;
        this.traceLogic = false;
        this.printStream = null;
        this.properties = null;
        this.getProperties();
    }

    public ReadProperties(Properties properties) {
        this.properties = properties;
        this.checkTraceSetting();
    }

    private void getProperties() {
        String string = cclConfig.resolveEffectivePath("..");
        File file = new File(string + AAA_PROPERTIES_FILE);
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            this.properties = new Properties();
            this.properties.load(fileInputStream);
            this.checkTraceSetting();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void checkTraceSetting() {
        boolean bl = this.tracePropertyEnabled("trace.debug");
        if (bl) {
            this.traceLogic = true;
            this.traceException = true;
        } else {
            this.traceLogic = this.tracePropertyEnabled("trace.debug.logic");
            this.traceException = this.tracePropertyEnabled("trace.debug.exception");
        }
    }

    public String getTraceFileName() throws FileNotFoundException {
        String string = this.properties.getProperty("trace.output");
        return string;
    }

    private void getTraceFileStream() throws FileNotFoundException {
        String string = this.getTraceFileName();
        if (string != null && this.printStream == null) {
            this.printStream = new PrintStream(string);
        }
    }

    private boolean tracePropertyEnabled(String string) {
        String string2 = this.properties.getProperty(string);
        return string2 != null && string2.equalsIgnoreCase(TRACE_SETTIG_TRUE_VALUE);
    }

    public boolean traceLogicEnabled() {
        return this.traceLogic;
    }

    public void logTraceException(Throwable throwable) {
        if (this.traceException) {
            if (this.printStream == null) {
                try {
                    this.getTraceFileStream();
                }
                catch (FileNotFoundException fileNotFoundException) {
                    fileNotFoundException.printStackTrace();
                }
            }
            throwable.printStackTrace(this.printStream);
        }
    }

    public void logTraceLogic(String string) {
        if (this.traceLogic) {
            if (this.printStream == null) {
                try {
                    this.getTraceFileStream();
                }
                catch (FileNotFoundException fileNotFoundException) {
                    fileNotFoundException.printStackTrace();
                }
            }
            this.printStream.println(string);
        }
    }
}

