/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.auth.exception;

import com.ibm.cognos.camaaa.internal.auth.exception.SelectOption;
import com.ibm.cognos.camaaa.internal.common.messages.LocalizableMessage;
import java.util.Locale;

public abstract class DisplayObject {
    public static final String TEXT = "text";
    public static final String TEXTNOECHO = "textnoecho";
    public static final String VERIFYTEXTNOECHO = "verifytextnoecho";
    public static final String SINGLESELECT = "singleselect";
    public static final String MULTISELECT = "multiselect";
    public static final String HIDDEN = "hidden";
    public static final String DISPLAY = "display";
    public static final String REDIRECT = "redirect";
    private final String name;
    private String value;
    private LocalizableMessage caption;
    private final String type;

    public DisplayObject(String string, String string2) {
        this.type = string;
        this.name = string2;
        this.caption = null;
        this.value = null;
    }

    public DisplayObject(String string, String string2, LocalizableMessage localizableMessage) {
        this(string, string2);
        this.caption = localizableMessage;
    }

    public DisplayObject(String string, String string2, LocalizableMessage localizableMessage, String string3) {
        this(string, string2, localizableMessage);
        this.value = string3;
    }

    private boolean areCaptionsEqual(DisplayObject displayObject) {
        boolean bl = false;
        if (this.caption == null && displayObject.caption == null) {
            bl = true;
        } else if (this.caption != null && displayObject.caption != null) {
            bl = this.caption.equals(displayObject.caption);
        }
        return bl;
    }

    private boolean areValuesEqual(DisplayObject displayObject) {
        boolean bl = false;
        if (this.value == null && displayObject.value == null) {
            bl = true;
        } else if (this.value != null && displayObject.value != null) {
            bl = this.value.equals(displayObject.value);
        }
        return bl;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DisplayObject displayObject = (DisplayObject)object;
        return this.name.equals(displayObject.name) && this.type.equals(displayObject.type) && this.areValuesEqual(displayObject) && this.areCaptionsEqual(displayObject);
    }

    public String getCaption(Locale locale) {
        if (this.caption == null) {
            return null;
        }
        return this.caption.getLocalizedMessage(locale);
    }

    public String getName() {
        return this.name;
    }

    public SelectOption[] getOptions() {
        return null;
    }

    public String getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public int hashCode() {
        int n = 0;
        if (this.value != null) {
            n += this.value.hashCode();
        }
        if (this.caption != null) {
            n += this.caption.hashCode();
        }
        if (this.name != null) {
            n += this.name.hashCode();
        }
        if (this.type != null) {
            n += this.type.hashCode();
        }
        return n;
    }

    public void setValue(String string) {
        this.value = string;
    }
}

