/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.common.exception;

import com.ibm.cognos.camaaa.internal.common.messages.LocalizableMessage;
import com.ibm.cognos.camaaa.internal.common.messages.LocalizedMessage;
import java.util.ArrayList;
import java.util.Locale;

public class LocalizableException
extends Exception {
    private static final long serialVersionUID = -3371645834717908397L;
    private final LocalizableMessage message;

    public LocalizableException(LocalizableMessage localizableMessage) {
        super(localizableMessage == null ? null : localizableMessage.getLocalizedMessage(Locale.getDefault()));
        this.message = localizableMessage;
    }

    public LocalizableException(LocalizableMessage localizableMessage, Throwable throwable) {
        super(localizableMessage == null ? null : localizableMessage.getLocalizedMessage(Locale.getDefault()), throwable);
        this.message = localizableMessage;
    }

    public LocalizableMessage getLocalizableMessage() {
        return this.message;
    }

    public LocalizableMessage[] getLocalizableMessageStack() {
        ArrayList<LocalizableMessage> arrayList = new ArrayList<LocalizableMessage>();
        for (Throwable throwable = this; throwable != null; throwable = throwable.getCause()) {
            LocalizableMessage localizableMessage = null;
            if (throwable instanceof LocalizableException) {
                LocalizableException localizableException = throwable;
                localizableMessage = localizableException.getLocalizableMessage();
            } else {
                localizableMessage = new LocalizedMessage(throwable.toString());
            }
            if (localizableMessage == null) continue;
            arrayList.add(localizableMessage);
        }
        return arrayList.toArray(new LocalizableMessage[arrayList.size()]);
    }

    @Override
    public String getLocalizedMessage() {
        if (this.message != null) {
            return this.message.getLocalizedMessage(Locale.getDefault());
        }
        return super.getLocalizedMessage();
    }
}

