/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.common.messages;

import com.ibm.cognos.camaaa.internal.common.messages.LocalizableMessage;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;

public class ResourceBundleMessage
implements LocalizableMessage {
    private final String bundleName;
    private final String messageID;
    private Object[] parameters;

    public ResourceBundleMessage(String string, String string2) {
        this.bundleName = string;
        this.messageID = string2;
        this.parameters = null;
        ResourceBundle.getBundle(this.bundleName);
    }

    public ResourceBundleMessage(String string, String string2, Object[] objectArray) {
        this(string, string2);
        this.parameters = objectArray;
    }

    private boolean areParametersEqual(ResourceBundleMessage resourceBundleMessage) {
        boolean bl = false;
        if (this.parameters == null && resourceBundleMessage.parameters == null) {
            bl = true;
        } else if (this.parameters != null && resourceBundleMessage.parameters != null) {
            if (this.parameters.length == resourceBundleMessage.parameters.length) {
                bl = true;
            }
            for (int i = 0; i < this.parameters.length && bl; ++i) {
                bl = bl && this.parameters[i].equals(resourceBundleMessage.parameters[i]);
            }
        }
        return bl;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ResourceBundleMessage resourceBundleMessage = (ResourceBundleMessage)object;
        return this.bundleName.equals(resourceBundleMessage.bundleName) && this.messageID.equals(resourceBundleMessage.messageID) && this.areParametersEqual(resourceBundleMessage);
    }

    @Override
    public String getLocalizedMessage(Locale locale) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle(this.bundleName, locale);
        return MessageFormat.format(resourceBundle.getString(this.messageID), this.parameters);
    }

    public int hashCode() {
        int n = 0;
        if (this.parameters != null) {
            for (int i = 0; i < this.parameters.length; ++i) {
                n += this.parameters[i].hashCode();
            }
        }
        return this.bundleName.hashCode() + this.messageID.hashCode() + n;
    }
}

