/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cclcfgapi;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.CAMFactory;
import com.cognos.accman.jcam.crypto.EncryptingSession;
import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.CCLConfigurationUtils;
import com.cognos.cclcfgapi.CCLStartupConfiguration;
import com.cognos.cclcfgapi.CFG;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.cclcfgapi.base64;
import com.cognos.i18n.ToolkitResources;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.dom4j.Attribute;
import org.dom4j.Comment;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.QName;
import org.dom4j.Text;
import org.dom4j.io.SAXReader;

class CCLConfiguration2
implements ICCLConfiguration {
    private String startupConfigFilePath;
    private Element startupConfigRoot;
    private List m_productLocaleList;
    private Map m_productLocaleMap;
    private Map m_productLocales;
    private List m_contentLocaleList;
    private Map m_contentLocaleMap;
    private Map m_contentLocales;
    private List m_currencyList;
    private Map m_currencies;
    private ArrayList m_fontList;
    private Map m_fontsMap;
    private Document m_localeDoc;
    private Object m_localeDocGuard = new Object();
    private Document m_ConfigDoc;
    private Document m_ConfigUnresolvedDoc;
    private Map m_componentMap;
    private Map m_globalParameterNameValueMap;
    private static final String LOCALE_CONFIGURATION_FILE = "../configuration/coglocale.xml";
    private static final String CMPLST_FILE = "../cmplst.txt";
    private static final String WILDCARD = "-*";
    private static final int LIST_LOCALE = 1;
    private static final int LIST_TIMEZONE = 2;
    private static final int LIST_CURRENCY = 3;
    private static final String XML_ROOT = "localeConfiguration";
    private static final String XML_PRODUCT_LOCALE_MAP = "productLocaleMap";
    private static final String XML_CONTENT_LOCALE_MAP = "contentLocaleMap";
    private static final String XML_SUPPORTED_PRODUCT_LOCALES = "supportedProductLocales";
    private static final String XML_SUPPORTED_CONTENT_LOCALES = "supportedContentLocales";
    private static final String XML_SUPPORTED_CURRENCIES = "supportedCurrencies";
    private static final String XML_SUPPORTED_FONTS = "supportedFonts";
    private static final String XML_LOCALE_MAP = "localeMap";
    private static final String XML_LOCALE = "locale";
    private static final String XML_CURRENCY = "currency";
    private static final String XML_FONT = "font";
    private static final String XML_FONTS_MAP = "fontsMap";
    private static final String XML_FONT_MAP = "fontMap";
    private static final String XML_COOKIE_DOMAIN = "cookieDomain";
    private static final String XML_COOKIE_PATH = "cookiePath";
    private static final String XML_COOKIE_SECURE = "cookieSecure";
    private static final String XML_EMAIL_ENCODING = "emailEncoding";
    private static final String XML_ALIAS_ROOTS = "aliasRoots";
    private static final String XML_SERVER_LOCALE = "serverLocale";
    private static final String XML_SERVER_TIME_ZONE_ID = "serverTimeZoneID";
    private static final String XML_DEFAULT_FONT = "defaultFont";
    private static final String XML_INTERNAL_DISP_URI = "internalDispatcher";
    private static final String XML_EXTERNAL_DISP_URI = "externalDispatcher";
    private static final String XML_ARCHIVE_LOCATION_FILESCHEME_ROOT = "archiveLocationFileSchemeRoot";
    private static final String XML_HTTPS_ID = "https";
    private static final String CM_XSI_TYPE_ATTR = "xsi:type";
    private static final String CM_XSI_ARRAYTYPE_ATTR = "xsi:arrayType";
    private boolean m_bStartupInitialized;
    private CAMFactory m_cf;
    private EncryptingSession m_es;
    private static String m_binDirectoryPath;
    private static Object m_mutex;
    private Map<String, Element> m_parameterNameValueMap = new HashMap<String, Element>();
    private Map<String, Element> m_parameterNameValueUnresolvedMap = new HashMap<String, Element>();
    private List<Element> m_advSettingsParams = new ArrayList<Element>();
    private Map<String, Element> m_serviceAdvSettingsMap = new HashMap<String, Element>();
    private Map<String, Element> m_serviceAdvSettingsUnresolvedMap = new HashMap<String, Element>();

    CCLConfiguration2() {
        this.startupConfigFilePath = "../configuration/cogstartup.xml";
    }

    CCLConfiguration2(String startupConfigFilePath) {
        this.startupConfigFilePath = startupConfigFilePath;
    }

    CCLConfiguration2(Element startupConfigRoot) {
        this.startupConfigFilePath = null;
        this.startupConfigRoot = startupConfigRoot;
    }

    private boolean startupElementSupplied() {
        return this.startupConfigRoot != null;
    }

    @Override
    public void init() throws CCLConfigurationException {
        this.init((Element)null);
    }

    @Override
    public void init(InputStream configurationDoc) throws CCLConfigurationException {
        if (null != configurationDoc) {
            SAXReader reader = new SAXReader();
            Document doc = null;
            try {
                doc = reader.read(configurationDoc);
            }
            catch (DocumentException de) {
                throw new CCLConfigurationException(5);
            }
            this._init(doc.getRootElement());
        } else {
            this._init(null);
        }
        this.reloadGlobalConfiguration();
    }

    @Override
    public void init(Element configurationElement) throws CCLConfigurationException {
        this._init(configurationElement);
        this.reloadGlobalConfiguration();
    }

    private synchronized void _init(Element configurationElement) throws CCLConfigurationException {
        Element root;
        boolean bResolvePaths = false;
        boolean bReplaceVars = false;
        if (null == this.m_ConfigDoc) {
            this.m_parameterNameValueMap.clear();
            this.m_advSettingsParams.clear();
            root = this.createConfigDoc();
            this.loadFactoryDefaultsForRuntimeParams(root);
            bResolvePaths = true;
            bReplaceVars = true;
        }
        if (this.m_ConfigUnresolvedDoc == null) {
            this.m_parameterNameValueUnresolvedMap.clear();
            this.m_ConfigUnresolvedDoc = (Document)this.m_ConfigDoc.clone();
        }
        root = this.m_ConfigDoc.getRootElement();
        Element unresolvedRoot = this.m_ConfigUnresolvedDoc.getRootElement();
        if (!this.m_bStartupInitialized) {
            this.loadStartupConfig(root, unresolvedRoot);
            bResolvePaths = true;
            bReplaceVars = true;
            this.m_bStartupInitialized = true;
        }
        if (null != configurationElement) {
            this.loadCMConfiguration(configurationElement, root, unresolvedRoot);
            bResolvePaths = true;
            bReplaceVars = true;
        }
        if (bReplaceVars) {
            CCLConfiguration2.replaceVariables(root);
            CCLConfiguration2.replaceVariables(unresolvedRoot);
        }
        if (bResolvePaths) {
            CCLConfiguration2.fixupPaths(root);
        }
    }

    private void loadCMConfiguration(Element configurationElement, Element root, Element unresolvedRoot) {
        if (configurationElement.getName().compareTo("queryResult") == 0) {
            this._scanParametersHelper(configurationElement, root, this.m_parameterNameValueMap, this.m_serviceAdvSettingsMap);
            this._scanParametersHelper(configurationElement, unresolvedRoot, this.m_parameterNameValueUnresolvedMap, this.m_serviceAdvSettingsUnresolvedMap);
        } else {
            List resultList = CCLConfiguration2.getElementsByTagName(configurationElement, "queryResult");
            for (int i = 0; i < resultList.size(); ++i) {
                Element resultNode = (Element)resultList.get(i);
                this._scanParametersHelper(resultNode, root, this.m_parameterNameValueMap, this.m_serviceAdvSettingsMap);
                this._scanParametersHelper(resultNode, unresolvedRoot, this.m_parameterNameValueUnresolvedMap, this.m_serviceAdvSettingsUnresolvedMap);
            }
        }
    }

    private Element createConfigDoc() {
        this.m_ConfigDoc = DocumentHelper.createDocument();
        Element root = DocumentHelper.createElement((QName)CCLStartupConfiguration.qnParameters);
        this.m_ConfigDoc.add(root);
        root.addAttribute("version", "1.0");
        root.add(CCLStartupConfiguration.nsCFG);
        root.add(CCLStartupConfiguration.nsXSD);
        root.add(CCLStartupConfiguration.nsXSI);
        return root;
    }

    void loadFactoryDefaultsForRuntimeParams(Element root) {
        String name;
        int index = 0;
        while ((name = CFG.runtimeDefaults[index++]) != null) {
            String factoryDefault = CFG.runtimeDefaults[index++];
            Element param = root.addElement(CCLStartupConfiguration.qnParameter);
            param.addAttribute("name", name);
            Element value = param.addElement(CCLStartupConfiguration.qnValue);
            value.setText(factoryDefault);
            this.m_parameterNameValueMap.put(name, param);
        }
    }

    private void loadStartupConfig(Element root, Element unresolvedRoot) throws CCLConfigurationException {
        Element rootConfigElement = null;
        if (this.startupElementSupplied()) {
            rootConfigElement = this.startupConfigRoot;
        } else {
            StringBuilder startupConfguration = new StringBuilder();
            int result = this.loadStartupFile(startupConfguration);
            if (result == 0) {
                rootConfigElement = this.getStartupRootElement(startupConfguration.toString());
            } else {
                this.loadStartupDefaults(root, unresolvedRoot);
                return;
            }
        }
        this.processStartupConfiguration(rootConfigElement, root, unresolvedRoot);
    }

    private int loadStartupFile(StringBuilder startupConfguration) {
        int result = 0;
        result = CCLStartupConfiguration.getStartupConfigurationDocument(this.startupConfigFilePath, startupConfguration, false);
        return result;
    }

    private Element getStartupRootElement(String startupConfguration) throws CCLConfigurationException {
        Document doc = null;
        try {
            doc = DocumentHelper.parseText((String)startupConfguration);
        }
        catch (DocumentException e) {
            throw new CCLConfigurationException(3);
        }
        Element rootElement = doc.getRootElement();
        return rootElement;
    }

    private void processStartupConfiguration(Element rootElement, Element root, Element unresolvedRoot) throws CCLConfigurationException {
        if (rootElement.getQName().equals((Object)CCLStartupConfiguration.qnParameters)) {
            List comments = rootElement.selectNodes("//comment()");
            if (comments != null) {
                for (Comment comment : comments) {
                    comment.getParent().remove(comment);
                }
            }
            List parameterNodeList = rootElement.elements(CCLStartupConfiguration.qnParameter);
            for (Element paramElement : parameterNodeList) {
                Element existElement;
                String name = paramElement.attributeValue("name");
                String opaque = paramElement.attributeValue("opaque");
                Element valueElement = paramElement.element(CCLStartupConfiguration.qnValue);
                if (null != opaque && 0 == opaque.compareToIgnoreCase("true")) {
                    valueElement.add(CCLStartupConfiguration.nsCFG);
                    valueElement.add(CCLStartupConfiguration.nsXSD);
                    valueElement.add(CCLStartupConfiguration.nsXSI);
                }
                if (null != (existElement = this.m_parameterNameValueMap.get(name))) {
                    existElement.getParent().remove(existElement);
                }
                paramElement.detach();
                unresolvedRoot.add(paramElement);
                this.m_parameterNameValueUnresolvedMap.put(name, paramElement);
                Element paramElementResolved = (Element)paramElement.clone();
                root.add(paramElementResolved);
                this.m_parameterNameValueMap.put(name, paramElementResolved);
            }
        } else {
            throw new CCLConfigurationException(4);
        }
    }

    private void loadStartupDefaults(Element root, Element unresolvedRoot) {
        String name;
        int index = 0;
        while ((name = CFG.startupDefaults[index++]) != null) {
            String factoryDefault = CFG.startupDefaults[index++];
            Element param = root.addElement(CCLStartupConfiguration.qnParameter);
            Element unresolvedParam = unresolvedRoot.addElement(CCLStartupConfiguration.qnParameter);
            param.addAttribute("name", name);
            unresolvedParam.addAttribute("name", name);
            Element value = param.addElement(CCLStartupConfiguration.qnValue);
            Element unresolvedValue = unresolvedParam.addElement(CCLStartupConfiguration.qnValue);
            value.setText(factoryDefault);
            unresolvedValue.setText(factoryDefault);
            this.m_parameterNameValueMap.put(name, param);
            this.m_parameterNameValueUnresolvedMap.put(name, unresolvedParam);
        }
    }

    private void _scanParametersHelper(Element node, Element root, Map<String, Element> parameterNameValueMap, Map<String, Element> serviceAdvSettingsMap) {
        List itemList = node.elements("item");
        for (Element itemElement : itemList) {
            String serviceName = itemElement.attributeValue(CCLStartupConfiguration.qnXSIType);
            List paramList = itemElement.elements();
            for (Element paramElement : paramList) {
                String name = paramElement.getQualifiedName();
                if (name.equals("advancedSettings")) {
                    if (serviceName == null || serviceName.length() == 0) {
                        this.checkAndAddParam(root, parameterNameValueMap, name, paramElement);
                        continue;
                    }
                    Element existElement = serviceAdvSettingsMap.get(serviceName);
                    if (null != existElement) {
                        serviceAdvSettingsMap.remove(serviceName);
                    }
                    this._scanAdvancedSettingsHelper(root, existElement, paramElement, parameterNameValueMap);
                    Element newadvElem = (Element)paramElement.clone();
                    serviceAdvSettingsMap.put(serviceName, newadvElem);
                    continue;
                }
                this.checkAndAddParam(root, parameterNameValueMap, name, paramElement);
            }
        }
        Element aliasRootsElem = node.element(XML_ALIAS_ROOTS);
        if (aliasRootsElem != null) {
            Element existElement = parameterNameValueMap.get(XML_ALIAS_ROOTS);
            if (null != existElement) {
                existElement.getParent().remove(existElement);
                parameterNameValueMap.remove(XML_ALIAS_ROOTS);
            }
            Element param = this.loadAliasRootsFromParam(aliasRootsElem);
            param.setParent(root);
            parameterNameValueMap.put(XML_ALIAS_ROOTS, param);
        }
    }

    private void checkAndAddParam(Element root, Map<String, Element> parameterNameValueMap, String paramName, Element paramElement) {
        Element param;
        Element existElement = parameterNameValueMap.get(paramName);
        if (null != existElement) {
            existElement.getParent().remove(existElement);
            parameterNameValueMap.remove(paramName);
        }
        if ((param = this.addParamFromValueElement(paramElement, root, paramName)) != null) {
            parameterNameValueMap.put(paramName, param);
        }
    }

    private Element addParamFromValueElement(Element paramElement, Element root, String name) {
        String opaque;
        Element valueElement = paramElement.element("value");
        if (valueElement == null) {
            return null;
        }
        Element param = root.addElement(CCLStartupConfiguration.qnParameter);
        param.addAttribute("name", name);
        Element newValueElement = param.addElement(CCLStartupConfiguration.qnValue);
        newValueElement.addAttribute(CCLStartupConfiguration.qnXSIType, valueElement.attributeValue(CCLStartupConfiguration.qnXSIType));
        String encrypted = valueElement.attributeValue("encrypted");
        if (encrypted != null && encrypted.compareToIgnoreCase("true") == 0) {
            newValueElement.addAttribute("encrypted", encrypted);
        }
        if ((opaque = paramElement.attributeValue("opaque")) != null && opaque.equals("true")) {
            param.addAttribute("opaque", "true");
        }
        if (opaque != null && opaque.equals("false")) {
            param.addAttribute("opaque", "false");
        }
        if (opaque != null && opaque.equals("false")) {
            newValueElement.setText(valueElement.getText());
        } else if (opaque != null && opaque.equals("true")) {
            List lElem = valueElement.elements();
            for (int i = 0; i < lElem.size(); ++i) {
                Element e = (Element)((Element)lElem.get(i)).clone();
                newValueElement.add(e);
            }
        } else if (valueElement.isTextOnly()) {
            newValueElement.setText(valueElement.getText());
        } else {
            newValueElement.add((Element)valueElement.clone());
        }
        return param;
    }

    private Element loadAliasRootsFromParam(Element param) {
        Element newParam = DocumentHelper.createElement((QName)CCLStartupConfiguration.qnParameter);
        newParam.addAttribute("name", XML_ALIAS_ROOTS);
        Element newValueElement = newParam.addElement(CCLStartupConfiguration.qnValue);
        newValueElement.addAttribute(CCLStartupConfiguration.qnXSIType, "cfg:array");
        Element valueElem = param.element("value");
        if (valueElem != null) {
            List itemList = valueElem.elements("item");
            for (Element itemElement : itemList) {
                Element valueElement;
                String defaultName = null;
                String windowsURI = null;
                String unixURI = null;
                Element itemSubElement = itemElement.element("defaultName");
                if (itemSubElement != null && (valueElement = itemSubElement.element("value")) != null) {
                    defaultName = valueElement.getText();
                }
                if ((itemSubElement = itemElement.element("windowsURI")) != null && (valueElement = itemSubElement.element("value")) != null) {
                    windowsURI = valueElement.getText();
                }
                if ((itemSubElement = itemElement.element("unixURI")) != null && (valueElement = itemSubElement.element("value")) != null) {
                    unixURI = valueElement.getText();
                }
                if (defaultName == null || windowsURI == null && unixURI == null) continue;
                Element itemElem = newValueElement.addElement("item");
                Element subElem = itemElem.addElement("name");
                subElem.setText(defaultName);
                subElem = itemElem.addElement("windowsURI");
                subElem.setText(windowsURI != null ? windowsURI : "");
                subElem = itemElem.addElement("unixURI");
                subElem.setText(unixURI != null ? unixURI : "");
            }
        }
        return newParam;
    }

    private void _scanAdvancedSettingsHelper(Element root, Element previousAdvSettings, Element newAdvancedSettings, Map<String, Element> parameterNameValueMap) {
        try {
            Document newDoc;
            Element newRootElement;
            List newList;
            Element previousRootElement;
            List previousList;
            Document previousDoc;
            String prevText;
            Element valueElem;
            if (previousAdvSettings != null && (valueElem = previousAdvSettings.element("value")) != null && (prevText = valueElem.getText()) != null && (previousDoc = DocumentHelper.parseText((String)prevText)) != null && (previousList = (previousRootElement = previousDoc.getRootElement()).selectNodes("setting")) != null) {
                for (Element previousElem : previousList) {
                    String nameAttribValue = previousElem.attributeValue("name");
                    Element existElement = parameterNameValueMap.get(nameAttribValue);
                    if (existElement == null) continue;
                    existElement.getParent().remove(existElement);
                    parameterNameValueMap.remove(nameAttribValue);
                    this.m_advSettingsParams.remove(existElement);
                }
            }
            if (newAdvancedSettings != null && (valueElem = newAdvancedSettings.element("value")) != null && (newList = (newRootElement = (newDoc = DocumentHelper.parseText((String)valueElem.getText())).getRootElement()).selectNodes("setting")) != null) {
                for (Element aElem : newList) {
                    Element param = root.addElement(CCLStartupConfiguration.qnParameter);
                    String nameAttr = aElem.attributeValue("name");
                    param.addAttribute("name", nameAttr);
                    Element newValueElement = param.addElement(CCLStartupConfiguration.qnValue);
                    newValueElement.setText(aElem.getText());
                    parameterNameValueMap.put(nameAttr, param);
                    this.m_advSettingsParams.add(param);
                }
            }
        }
        catch (DocumentException documentException) {
            // empty catch block
        }
    }

    @Override
    public String serialize() throws CCLConfigurationException {
        String str = null;
        try {
            if (this.m_ConfigDoc == null) {
                this.init();
            }
            Document docElem = DocumentHelper.createDocument();
            Element rootElem = docElem.addElement("queryResult");
            rootElem.addAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            rootElem.addAttribute("xmlns:crn", "http://developer.cognos.com/schemas/crconfig/1/");
            rootElem.addAttribute("xmlns:cfg", "http://developer.cognos.com/schemas/configparams/XMLSchema/1/");
            Element elem = rootElem.addElement("item");
            Element elemRoot = this.m_ConfigDoc.getRootElement();
            Iterator iElements = elemRoot.elementIterator();
            while (iElements.hasNext()) {
                Element newElem;
                Element origElem = (Element)iElements.next();
                String ename = origElem.attributeValue("name");
                String opaque = origElem.attributeValue("opaque");
                if (this.m_advSettingsParams.contains(origElem)) continue;
                try {
                    newElem = elem.addElement(ename);
                }
                catch (IllegalArgumentException e) {
                    continue;
                }
                if (opaque != null && opaque.equals("true")) {
                    newElem.addAttribute("opaque", "true");
                } else {
                    newElem.addAttribute("opaque", "false");
                }
                for (int i = 0; i < origElem.attributeCount(); ++i) {
                    Attribute atr = origElem.attribute(i);
                    if (atr.getName().equals("name")) continue;
                    newElem.addAttribute(atr.getName(), atr.getText());
                }
                Element origVal = (Element)origElem.elements().get(0);
                Element newVal = newElem.addElement("value");
                newVal.addAttribute(CCLStartupConfiguration.qnXSIType, origVal.attributeValue(CCLStartupConfiguration.qnXSIType));
                if (opaque != null && opaque.equals("true")) {
                    List lElem = origVal.elements();
                    for (int i = 0; i < lElem.size(); ++i) {
                        Element item = (Element)((Element)lElem.get(i)).clone();
                        newVal.add(item);
                    }
                    continue;
                }
                newVal.setText(origVal.getText());
            }
            str = docElem.asXML();
        }
        catch (Exception e) {
            throw new CCLConfigurationException(e.getLocalizedMessage());
        }
        return str;
    }

    @Override
    public Collection getParameterNames() throws CCLConfigurationException {
        return this.m_parameterNameValueMap.keySet();
    }

    @Override
    public synchronized String getValue(String paramName, boolean decrypt) throws CCLConfigurationException {
        return this.getValue(paramName, decrypt, true);
    }

    @Override
    public synchronized Element getValueElement(String paramName, boolean decrypt) throws CCLConfigurationException {
        return this.getValueElement(paramName, decrypt, true);
    }

    private synchronized EncryptingSession getCrypto() throws CCLConfigurationException {
        if (null == this.m_cf) {
            this.m_cf = new CAMFactory();
            try {
                this.m_cf.initialize("<initializeDocument><serviceID>CFGAPI</serviceID></initializeDocument>".getBytes());
                this.m_es = this.m_cf.createEncryptingSession();
            }
            catch (CAMCryptoException e) {
                throw new CCLConfigurationException(e.getMessage());
            }
            catch (Throwable e) {
                Object[] args = new Object[]{e.getMessage()};
                throw new CCLConfigurationException(7, args);
            }
        }
        return this.m_es;
    }

    @Override
    public Map getProductLocaleList(String locale) throws CCLConfigurationException {
        this.initializeProductLocaleMaps();
        return CCLConfiguration2.getListFromMapHelper(locale, this.m_productLocales, this.m_productLocaleList, 1);
    }

    @Override
    public Map getContentLocaleList(String locale) throws CCLConfigurationException {
        this.initializeContentLocaleMaps();
        return CCLConfiguration2.getListFromMapHelper(locale, this.m_contentLocales, this.m_contentLocaleList, 1);
    }

    @Override
    public Map getTimeZones(String locale) throws CCLConfigurationException {
        String localeID = CCLConfiguration2.normalizeLocaleHelper(locale != null ? locale : "en");
        return ToolkitResources.getTimeZoneDescriptions((String)localeID);
    }

    @Override
    public String export() throws CCLConfigurationException {
        this.initializeProductLocaleMaps();
        this.initializeContentLocaleMaps();
        this.initializeCurrencies();
        this.initializeFonts();
        this.initializeGlobalParams();
        Document doc = DocumentHelper.createDocument();
        Element root = DocumentHelper.createElement((String)"localeExport");
        doc.add(root);
        root.add(new Namespace("SOAP-ENC", "http://schemas.xmlsoap.org/soap/encoding/"));
        root.add(new Namespace("cm", "http://developer.cognos.com/schemas/bibus/3/"));
        root.add(new Namespace("xs", "http://www.w3.org/2001/XMLSchema"));
        root.add(new Namespace("xsi", "http://www.w3.org/2001/XMLSchema-instance"));
        Element param = DocumentHelper.createElement((String)XML_SERVER_LOCALE);
        root.add(param);
        param.addAttribute(CM_XSI_TYPE_ATTR, "cm:languageProp");
        Element value = DocumentHelper.createElement((String)"value");
        param.add(value);
        value.addAttribute(CM_XSI_TYPE_ATTR, "xs:string");
        value.setText(this.getValue(XML_SERVER_LOCALE, true));
        param = DocumentHelper.createElement((String)XML_SERVER_TIME_ZONE_ID);
        root.add(param);
        param.addAttribute(CM_XSI_TYPE_ATTR, "cm:stringProp");
        value = DocumentHelper.createElement((String)"value");
        param.add(value);
        value.addAttribute(CM_XSI_TYPE_ATTR, "xs:string");
        value.setText(this.getValue(XML_SERVER_TIME_ZONE_ID, true));
        param = DocumentHelper.createElement((String)XML_PRODUCT_LOCALE_MAP);
        root.add(param);
        CCLConfiguration2.exportMap(this.m_productLocaleMap, param);
        param = DocumentHelper.createElement((String)XML_CONTENT_LOCALE_MAP);
        root.add(param);
        CCLConfiguration2.exportMap(this.m_contentLocaleMap, param);
        param = DocumentHelper.createElement((String)XML_SUPPORTED_PRODUCT_LOCALES);
        root.add(param);
        CCLConfiguration2.exportList(this.m_productLocaleList, param, "language");
        param = DocumentHelper.createElement((String)XML_SUPPORTED_CONTENT_LOCALES);
        root.add(param);
        CCLConfiguration2.exportList(this.m_contentLocaleList, param, "language");
        param = DocumentHelper.createElement((String)XML_SUPPORTED_CURRENCIES);
        root.add(param);
        CCLConfiguration2.exportList(this.m_currencyList, param, "token");
        param = DocumentHelper.createElement((String)XML_DEFAULT_FONT);
        root.add(param);
        param.addAttribute(CM_XSI_TYPE_ATTR, "cm:stringProp");
        value = DocumentHelper.createElement((String)"value");
        param.add(value);
        value.addAttribute(CM_XSI_TYPE_ATTR, "xs:string");
        value.setText(this.getValue(XML_DEFAULT_FONT, true));
        param = DocumentHelper.createElement((String)XML_SUPPORTED_FONTS);
        root.add(param);
        CCLConfiguration2.exportList(this.m_fontList, param, "string");
        Element valueElem = (Element)this.m_globalParameterNameValueMap.get(XML_COOKIE_DOMAIN);
        String sValue = valueElem != null ? valueElem.getText() : "";
        param = DocumentHelper.createElement((String)XML_COOKIE_DOMAIN);
        root.add(param);
        param.addAttribute(CM_XSI_TYPE_ATTR, "cm:stringProp");
        value = DocumentHelper.createElement((String)"value");
        param.add(value);
        value.addAttribute(CM_XSI_TYPE_ATTR, "xs:string");
        value.setText(sValue);
        valueElem = (Element)this.m_globalParameterNameValueMap.get(XML_COOKIE_PATH);
        sValue = valueElem != null ? valueElem.getText() : "";
        param = DocumentHelper.createElement((String)XML_COOKIE_PATH);
        root.add(param);
        param.addAttribute(CM_XSI_TYPE_ATTR, "cm:stringProp");
        value = DocumentHelper.createElement((String)"value");
        param.add(value);
        value.addAttribute(CM_XSI_TYPE_ATTR, "xs:string");
        value.setText(sValue);
        valueElem = (Element)this.m_globalParameterNameValueMap.get(XML_COOKIE_SECURE);
        sValue = valueElem != null ? valueElem.getText() : "";
        param = DocumentHelper.createElement((String)XML_COOKIE_SECURE);
        root.add(param);
        param.addAttribute(CM_XSI_TYPE_ATTR, "cm:booleanProp");
        value = DocumentHelper.createElement((String)"value");
        param.add(value);
        value.addAttribute(CM_XSI_TYPE_ATTR, "xs:boolean");
        value.setText(sValue);
        param = DocumentHelper.createElement((String)XML_EMAIL_ENCODING);
        root.add(param);
        param.addAttribute(CM_XSI_TYPE_ATTR, "cm:stringProp");
        value = DocumentHelper.createElement((String)"value");
        param.add(value);
        value.addAttribute(CM_XSI_TYPE_ATTR, "xs:string");
        value.setText(this.getValue(XML_EMAIL_ENCODING, true));
        Element newValueElem = (Element)this.m_globalParameterNameValueMap.get(XML_ARCHIVE_LOCATION_FILESCHEME_ROOT);
        String sNewValue = newValueElem != null ? newValueElem.getText() : "";
        param = DocumentHelper.createElement((String)XML_ARCHIVE_LOCATION_FILESCHEME_ROOT);
        root.add(param);
        param.addAttribute(CM_XSI_TYPE_ATTR, "cm:anyURIProp");
        value = DocumentHelper.createElement((String)"value");
        param.add(value);
        value.addAttribute(CM_XSI_TYPE_ATTR, "xs:string");
        value.setText(sNewValue);
        newValueElem = (Element)this.m_globalParameterNameValueMap.get(XML_ALIAS_ROOTS);
        if (newValueElem != null) {
            Attribute arrayTypeAttr;
            param = DocumentHelper.createElement((String)XML_ALIAS_ROOTS);
            root.add(param);
            newValueElem.detach();
            Attribute typeAttr = newValueElem.attribute("type");
            if (typeAttr != null) {
                newValueElem.remove(typeAttr);
            }
            if ((arrayTypeAttr = newValueElem.attribute("arrayType")) != null) {
                newValueElem.remove(arrayTypeAttr);
            }
            newValueElem.addAttribute(CM_XSI_TYPE_ATTR, "SOAP-ENC:Array");
            param.add(newValueElem);
        }
        return doc.asXML();
    }

    @Override
    public boolean validateProductLocale(String locale) throws CCLConfigurationException {
        if (locale != null) {
            boolean result = this.validateLocaleHelper(locale);
            if (result) {
                this.initializeProductLocaleMaps();
                result = locale.compareToIgnoreCase("in") == 0 ? this.m_productLocaleList.contains("id") : (locale.compareToIgnoreCase("in-id") == 0 ? this.m_productLocaleList.contains("id-id") : (locale.compareToIgnoreCase("iw") == 0 ? this.m_productLocaleList.contains("he") : (locale.compareToIgnoreCase("iw-il") == 0 ? this.m_productLocaleList.contains("he-il") : this.m_productLocaleList.contains(locale))));
            }
            return result;
        }
        throw new CCLConfigurationException(10);
    }

    @Override
    public boolean validateContentLocale(String locale) throws CCLConfigurationException {
        if (locale != null) {
            boolean result = this.validateLocaleHelper(locale);
            if (result) {
                this.initializeContentLocaleMaps();
                if (locale.compareToIgnoreCase("in") == 0) {
                    result = this.m_contentLocaleList.contains("id");
                } else if (locale.compareToIgnoreCase("in-id") == 0) {
                    result = this.m_contentLocaleList.contains("id-id");
                } else if (locale.compareToIgnoreCase("iw") == 0) {
                    result = this.m_contentLocaleList.contains("he");
                } else if (locale.compareToIgnoreCase("iw-il") == 0) {
                    result = this.m_contentLocaleList.contains("he-il");
                } else if (locale.compareToIgnoreCase("nb") == 0) {
                    result = this.m_contentLocaleList.contains("nb");
                    if (!result) {
                        result = this.m_contentLocaleList.contains("no");
                    }
                } else if (locale.compareToIgnoreCase("nb-no") == 0) {
                    result = this.m_contentLocaleList.contains("nb-no");
                    if (!result) {
                        result = this.m_contentLocaleList.contains("no-no");
                    }
                } else {
                    result = this.m_contentLocaleList.contains(locale);
                }
            }
            return result;
        }
        throw new CCLConfigurationException(10);
    }

    @Override
    public boolean validateContentLocaleStrict(String locale) throws CCLConfigurationException {
        if (locale != null) {
            boolean result = this.validateLocaleHelper(locale);
            if (result) {
                this.initializeContentLocaleMaps();
                result = this.m_contentLocaleList.contains(locale);
            }
            return result;
        }
        throw new CCLConfigurationException(10);
    }

    @Override
    public String normalizeLocale(String locale) throws CCLConfigurationException {
        if (locale != null) {
            return CCLConfiguration2.normalizeLocaleHelper(locale);
        }
        throw new CCLConfigurationException(10);
    }

    @Override
    public String mapProductLocale(String locale, boolean normalize) throws CCLConfigurationException {
        this.initializeProductLocaleMaps();
        String key = normalize ? this.normalizeLocale(locale) : locale;
        String value = null;
        if (key.length() >= 2 && (value = (String)this.m_productLocaleMap.get(key)) == null) {
            int countrySep = key.indexOf(45);
            if (countrySep == -1) {
                key = key + WILDCARD;
                value = (String)this.m_productLocaleMap.get(key);
            }
            if (value == null && (value = (String)this.m_productLocaleMap.get(key = key.substring(0, 3) + "*")) == null && (value = (String)this.m_productLocaleMap.get("*")) == null) {
                value = this.normalizeLocale(this.getValue(XML_SERVER_LOCALE, true));
                value = value != null && value.length() < 2 ? null : value.substring(0, 2);
            }
        }
        if (value == null) {
            Object[] args = new Object[]{locale};
            throw new CCLConfigurationException(13, args);
        }
        return value;
    }

    private String getMappedContentLocale(String locale, boolean normalize) throws CCLConfigurationException {
        this.initializeContentLocaleMaps();
        String key = normalize ? this.normalizeLocale(locale) : locale;
        String value = null;
        if (key.length() >= 2 && (value = (String)this.m_contentLocaleMap.get(key)) == null) {
            if (key.indexOf(45) == -1) {
                key = key + WILDCARD;
                value = (String)this.m_contentLocaleMap.get(key);
            }
            if (value == null && (value = (String)this.m_contentLocaleMap.get(key = key.substring(0, 3) + "*")) == null) {
                value = (String)this.m_contentLocaleMap.get("*");
            }
        }
        return value;
    }

    @Override
    public String mapContentLocale(String locale, boolean normalize) throws CCLConfigurationException {
        String value = this.getMappedContentLocale(locale, normalize);
        if (value == null && (value = this.normalizeLocale(this.getValue(XML_SERVER_LOCALE, true))) != null && value.length() < 2) {
            value = null;
        }
        if (value == null) {
            Object[] args = new Object[]{locale};
            throw new CCLConfigurationException(13, args);
        }
        return value;
    }

    @Override
    public String mapContentLocaleStrict(String locale, boolean normalize) throws CCLConfigurationException {
        return this.getMappedContentLocale(locale, normalize);
    }

    @Override
    public String resolveEffectivePath(String path) {
        return CCLConfigurationUtils.resolveEffectivePath(path);
    }

    @Override
    public Map getCurrencies(String locale) throws CCLConfigurationException {
        this.initializeCurrencies();
        return CCLConfiguration2.getListFromMapHelper(locale, this.m_currencies, this.m_currencyList, 3);
    }

    @Override
    public List getFonts(String locale) throws CCLConfigurationException {
        this.initializeFonts();
        return this.m_fontList;
    }

    @Override
    public String mapFont(String globalFontName) throws CCLConfigurationException {
        this.initializeFontsMap();
        String value = (String)this.m_fontsMap.get(globalFontName);
        if (value != null) {
            return value;
        }
        return globalFontName;
    }

    @Override
    public Map getFontMappings() throws CCLConfigurationException {
        this.initializeFontsMap();
        return this.m_fontsMap;
    }

    @Override
    public boolean isInternalSSL() throws CCLConfigurationException {
        this.init();
        String sURL = this.getValue(XML_INTERNAL_DISP_URI, true);
        return sURL.startsWith(XML_HTTPS_ID);
    }

    @Override
    public boolean isExternalSSL() throws CCLConfigurationException {
        this.init();
        String sURL = this.getValue(XML_EXTERNAL_DISP_URI, true);
        return sURL.startsWith(XML_HTTPS_ID);
    }

    @Override
    public String getComponentVersion(String shortComponentName) throws CCLConfigurationException {
        if (shortComponentName != null) {
            this.initializeComponentMap();
            String sVersionInfo = (String)this.m_componentMap.get(shortComponentName);
            return sVersionInfo == null ? "" : sVersionInfo;
        }
        throw new CCLConfigurationException(10);
    }

    @Override
    public synchronized String getValue(String paramName, boolean decrypt, boolean resolvePaths) throws CCLConfigurationException {
        StringBuilder oString = new StringBuilder();
        if (null == paramName) {
            throw new CCLConfigurationException(10);
        }
        if (paramName.length() > 0) {
            String prop;
            if (XML_INTERNAL_DISP_URI.equals(paramName) && (prop = System.getProperty(XML_INTERNAL_DISP_URI)) != null) {
                return prop;
            }
            Element paramElement = resolvePaths ? this.m_parameterNameValueMap.get(paramName) : this.m_parameterNameValueUnresolvedMap.get(paramName);
            if (null != paramElement) {
                String opaque = paramElement.attributeValue("opaque");
                Element valueElement = paramElement.element(CCLStartupConfiguration.qnValue);
                if (null != opaque && 0 == opaque.compareToIgnoreCase("true") || !valueElement.isTextOnly()) {
                    if (decrypt) {
                        EncryptingSession es = this.getCrypto();
                        valueElement = CCLConfiguration2.decryptXML((Element)valueElement.clone(), es);
                    }
                    oString.append(valueElement.asXML());
                } else {
                    String encrypted = valueElement.attributeValue("encrypted");
                    String value = valueElement.getText();
                    if (decrypt && null != encrypted && 0 == encrypted.compareToIgnoreCase("true")) {
                        EncryptingSession es = this.getCrypto();
                        value = CCLConfiguration2.decryptString(value, es);
                    }
                    oString.append(value);
                }
            }
        } else {
            Element rootElement = resolvePaths ? this.m_ConfigDoc.getRootElement() : this.m_ConfigUnresolvedDoc.getRootElement();
            if (decrypt) {
                EncryptingSession es = this.getCrypto();
                rootElement = CCLConfiguration2.decryptXML((Element)rootElement.clone(), es);
            }
            oString.append(rootElement.asXML());
        }
        return oString.toString();
    }

    @Override
    public synchronized Element getValueElement(String paramName, boolean decrypt, boolean resolvePaths) throws CCLConfigurationException {
        if (null == paramName) {
            throw new CCLConfigurationException(10);
        }
        Element element = null;
        if (paramName.length() > 0) {
            Element found = resolvePaths ? this.m_parameterNameValueMap.get(paramName) : this.m_parameterNameValueUnresolvedMap.get(paramName);
            if (null != found) {
                Element valueElement = found.element(CCLStartupConfiguration.qnValue);
                element = (Element)valueElement.clone();
            }
        } else {
            element = resolvePaths ? (Element)this.m_ConfigDoc.getRootElement().clone() : (Element)this.m_ConfigUnresolvedDoc.getRootElement().clone();
        }
        if (null != element && decrypt) {
            EncryptingSession es = this.getCrypto();
            element = CCLConfiguration2.decryptXML(element, es);
        }
        return element;
    }

    private synchronized void initializeProductLocaleMaps() throws CCLConfigurationException {
        if (this.m_productLocaleList == null) {
            this.m_productLocaleList = new ArrayList();
            this.loadList(this.m_productLocaleList, XML_SUPPORTED_PRODUCT_LOCALES, XML_LOCALE);
        }
        if (this.m_productLocaleMap == null) {
            this.m_productLocaleMap = new HashMap();
            this.loadMap(this.m_productLocaleMap, XML_PRODUCT_LOCALE_MAP, XML_LOCALE_MAP);
        }
        if (this.m_productLocales == null) {
            this.m_productLocales = new HashMap();
        }
    }

    private synchronized void initializeContentLocaleMaps() throws CCLConfigurationException {
        if (this.m_contentLocaleList == null) {
            this.m_contentLocaleList = new ArrayList();
            this.loadList(this.m_contentLocaleList, XML_SUPPORTED_CONTENT_LOCALES, XML_LOCALE);
        }
        if (this.m_contentLocaleMap == null) {
            this.m_contentLocaleMap = new HashMap();
            this.loadMap(this.m_contentLocaleMap, XML_CONTENT_LOCALE_MAP, XML_LOCALE_MAP);
        }
        if (this.m_contentLocales == null) {
            this.m_contentLocales = new HashMap();
        }
    }

    private synchronized void initializeCurrencies() throws CCLConfigurationException {
        if (null == this.m_currencyList) {
            this.m_currencyList = new ArrayList();
            this.loadList(this.m_currencyList, XML_SUPPORTED_CURRENCIES, XML_CURRENCY);
        }
        if (null == this.m_currencies) {
            this.m_currencies = new HashMap();
        }
    }

    private synchronized void initializeFonts() throws CCLConfigurationException {
        if (null == this.m_fontList) {
            this.m_fontList = new ArrayList();
            this.loadList(this.m_fontList, XML_SUPPORTED_FONTS, XML_FONT);
        }
    }

    private synchronized void initializeFontsMap() throws CCLConfigurationException {
        if (this.m_fontsMap == null) {
            this.m_fontsMap = new HashMap();
            this.loadMap(this.m_fontsMap, XML_FONTS_MAP, XML_FONT_MAP);
        }
    }

    private synchronized void initializeGlobalParams() throws CCLConfigurationException {
        if (null == this.m_globalParameterNameValueMap) {
            this.m_globalParameterNameValueMap = new HashMap();
            this.loadGlobalParameters(this.m_globalParameterNameValueMap);
        }
    }

    private synchronized void initializeComponentMap() throws CCLConfigurationException {
        if (this.m_componentMap == null) {
            try {
                this.m_componentMap = new HashMap();
                File cmpLstFile = new File(CCLConfigurationUtils.resolveEffectivePath(CMPLST_FILE));
                FileInputStream fis = new FileInputStream(cmpLstFile);
                InputStreamReader isr = new InputStreamReader(fis);
                BufferedReader reader = new BufferedReader(isr);
                String sLookingFor = "_version=";
                String sLine = reader.readLine();
                while (sLine != null) {
                    int index = sLine.indexOf("_version=");
                    if (index != -1) {
                        this.m_componentMap.put(sLine.substring(0, index), sLine.substring(index + "_version=".length()));
                    }
                    sLine = reader.readLine();
                }
                fis.close();
            }
            catch (FileNotFoundException e) {
                this.m_componentMap = null;
                throw new CCLConfigurationException(14);
            }
            catch (IOException e) {
                this.m_componentMap = null;
                throw new CCLConfigurationException(15);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadList(List list, String tagName, String tagEntry) throws CCLConfigurationException {
        Element localeElement;
        if (null == list) {
            return;
        }
        Object object = this.m_localeDocGuard;
        synchronized (object) {
            if (null == this.m_localeDoc) {
                this.m_localeDoc = DocumentHelper.createDocument();
                CCLConfiguration2.getLocaleDoc(this.m_localeDoc);
            }
        }
        Element rootElement = this.m_localeDoc.getRootElement();
        if (rootElement.getName().compareTo(XML_ROOT) == 0 && (localeElement = rootElement.element(tagName)) != null) {
            for (Element element : localeElement.elements(tagEntry)) {
                String value = element.attributeValue("id");
                list.add(value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadMap(Map map, String tagName, String tagEntry) throws CCLConfigurationException {
        Element localeElement;
        if (null == map) {
            return;
        }
        Object object = this.m_localeDocGuard;
        synchronized (object) {
            if (null == this.m_localeDoc) {
                this.m_localeDoc = DocumentHelper.createDocument();
                CCLConfiguration2.getLocaleDoc(this.m_localeDoc);
            }
        }
        Element rootElement = this.m_localeDoc.getRootElement();
        if (rootElement.getName().compareTo(XML_ROOT) == 0 && (localeElement = rootElement.element(tagName)) != null) {
            for (Element element : localeElement.elements(tagEntry)) {
                String key = element.attributeValue("key");
                String value = element.attributeValue("value");
                map.put(key, value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadGlobalParameters(Map map) throws CCLConfigurationException {
        if (null == map) {
            return;
        }
        Object object = this.m_localeDocGuard;
        synchronized (object) {
            if (null == this.m_localeDoc) {
                this.m_localeDoc = DocumentHelper.createDocument();
                CCLConfiguration2.getLocaleDoc(this.m_localeDoc);
            }
        }
        Element rootElement = this.m_localeDoc.getRootElement();
        if (rootElement.getName().compareTo(XML_ROOT) == 0) {
            for (Element paramElement : rootElement.elements("parameter")) {
                String name = paramElement.attributeValue("name");
                Element valueElement = paramElement.element("value");
                this.m_globalParameterNameValueMap.put(name, valueElement);
            }
        }
    }

    private static void loadListFromParam(List list, Element parameter) {
        List entries = parameter.selectNodes("*[local-name()='value']/*[local-name()='item']");
        for (Element item : entries) {
            list.add(item.getText());
        }
    }

    private static void loadMapFromParam(Map map, Element parameter) {
        List entries = parameter.selectNodes("*[local-name()='value']/*[local-name()='item']");
        for (Element item : entries) {
            Element key = item.element("key");
            Element value = item.element("value");
            map.put(key.getText(), value.getText());
        }
    }

    private void loadGlobalParamFromParam(Element parameter) {
        if (this.m_globalParameterNameValueMap == null) {
            this.m_globalParameterNameValueMap = new HashMap();
        }
        String name = parameter.attributeValue("name");
        Element valueElement = parameter.element("value");
        this.m_globalParameterNameValueMap.put(name, valueElement);
    }

    private static void getLocaleDoc(Document localedoc) throws CCLConfigurationException {
        if (localedoc == null) {
            throw new CCLConfigurationException(10);
        }
        try {
            File configFile = new File(CCLConfigurationUtils.resolveEffectivePath(LOCALE_CONFIGURATION_FILE));
            if (!configFile.exists()) {
                throw new CCLConfigurationException(11);
            }
            SAXReader reader = new SAXReader();
            Document doc = reader.read(configFile);
            Element rootElement = doc.getRootElement();
            if (rootElement != null) {
                rootElement.detach();
                localedoc.setRootElement(rootElement);
                return;
            }
            throw new CCLConfigurationException(12);
        }
        catch (DocumentException e) {
            throw new CCLConfigurationException(12);
        }
    }

    private synchronized void reloadGlobalConfiguration() throws CCLConfigurationException {
        Element tagElement = this.getValueElement(XML_SUPPORTED_PRODUCT_LOCALES, false);
        if (tagElement != null) {
            this.m_productLocaleList = new ArrayList();
            CCLConfiguration2.loadListFromParam(this.m_productLocaleList, tagElement);
            this.m_productLocales = null;
        }
        if ((tagElement = this.getValueElement(XML_PRODUCT_LOCALE_MAP, false)) != null) {
            this.m_productLocaleMap = new HashMap();
            CCLConfiguration2.loadMapFromParam(this.m_productLocaleMap, tagElement);
        }
        if ((tagElement = this.getValueElement(XML_SUPPORTED_CONTENT_LOCALES, false)) != null) {
            this.m_contentLocaleList = new ArrayList();
            CCLConfiguration2.loadListFromParam(this.m_contentLocaleList, tagElement);
            this.m_contentLocales = null;
        }
        if ((tagElement = this.getValueElement(XML_CONTENT_LOCALE_MAP, false)) != null) {
            this.m_contentLocaleMap = new HashMap();
            CCLConfiguration2.loadMapFromParam(this.m_contentLocaleMap, tagElement);
        }
        if ((tagElement = this.getValueElement(XML_SUPPORTED_CURRENCIES, false)) != null) {
            this.m_currencyList = new ArrayList();
            CCLConfiguration2.loadListFromParam(this.m_currencyList, tagElement);
            this.m_currencies = null;
        }
        if ((tagElement = this.getValueElement(XML_SUPPORTED_FONTS, false)) != null) {
            this.m_fontList = new ArrayList();
            CCLConfiguration2.loadListFromParam(this.m_fontList, tagElement);
        }
        if ((tagElement = this.getValueElement(XML_COOKIE_DOMAIN, false)) != null) {
            this.loadGlobalParamFromParam(tagElement);
        }
        if ((tagElement = this.getValueElement(XML_COOKIE_PATH, false)) != null) {
            this.loadGlobalParamFromParam(tagElement);
        }
        if ((tagElement = this.getValueElement(XML_COOKIE_SECURE, false)) != null) {
            this.loadGlobalParamFromParam(tagElement);
        }
    }

    private static void exportMap(Map localeMap, Element param) {
        param.addAttribute(CM_XSI_TYPE_ATTR, "cm:localeMapEntryArrayProp");
        Element value = DocumentHelper.createElement((String)"value");
        param.add(value);
        value.addAttribute(CM_XSI_TYPE_ATTR, "SOAP-ENC:Array");
        value.addAttribute("SOAP-ENC:arrayType", "cm:localeMapEntry[" + new Integer(localeMap.size()).toString() + "]");
        for (Map.Entry entry : localeMap.entrySet()) {
            Element item = DocumentHelper.createElement((String)"item");
            value.add(item);
            item.addAttribute(CM_XSI_TYPE_ATTR, "cm:localeMapEntry");
            Element entryKey = DocumentHelper.createElement((String)"key");
            item.add(entryKey);
            entryKey.addAttribute(CM_XSI_TYPE_ATTR, "xs:string");
            entryKey.setText(entry.getKey().toString());
            Element entryValue = DocumentHelper.createElement((String)"value");
            item.add(entryValue);
            entryValue.addAttribute(CM_XSI_TYPE_ATTR, "xs:string");
            entryValue.setText(entry.getValue().toString());
        }
    }

    private static void exportList(List list, Element param, String type) {
        param.addAttribute(CM_XSI_TYPE_ATTR, "cm:" + type + "ArrayProp");
        Element value = DocumentHelper.createElement((String)"value");
        param.add(value);
        value.addAttribute(CM_XSI_TYPE_ATTR, "SOAP-ENC:Array");
        if (list != null) {
            value.addAttribute("SOAP-ENC:arrayType", "cm:string[" + new Integer(list.size()).toString() + "]");
            for (Object entry : list) {
                Element item = DocumentHelper.createElement((String)"item");
                value.add(item);
                item.addAttribute(CM_XSI_TYPE_ATTR, "xs:string");
                item.setText(entry.toString());
            }
        } else {
            value.addAttribute("SOAP-ENC:arrayType", "cm:string[0]");
        }
    }

    private static String normalizeLocaleHelper(String locale) {
        return ToolkitResources.normalizeLocaleIdentifier((String)locale);
    }

    private boolean validateLocaleHelper(String locale) {
        return ToolkitResources.validateLocaleId((String)locale);
    }

    private static Map getListFromMapHelper(String locale, Map maps, List list, int type) {
        String localeID = CCLConfiguration2.normalizeLocaleHelper(locale != null ? locale : "en");
        TreeMap<String, String> foundMap = (TreeMap<String, String>)maps.get(localeID);
        if (null == foundMap) {
            TreeMap<String, String> sortedMap = new TreeMap<String, String>();
            Iterator it = list.iterator();
            switch (type) {
                case 1: {
                    while (it.hasNext()) {
                        String id = (String)it.next();
                        String desc = ToolkitResources.getLocaleDescription((String)id, (String)localeID);
                        sortedMap.put(id, desc);
                    }
                    break;
                }
                case 3: {
                    while (it.hasNext()) {
                        String id = (String)it.next();
                        String desc = ToolkitResources.getCurrencyDescription((String)id, (String)localeID);
                        sortedMap.put(id, desc);
                    }
                    break;
                }
            }
            foundMap = sortedMap;
            maps.put(localeID, foundMap);
        }
        return foundMap;
    }

    static void replaceVariables(Element element) {
        List valueList = CCLConfiguration2.getElementsByTagNameNS(element, "crn", "http://developer.cognos.com/schemas/crconfig/1/", "value");
        for (int k = 0; k < valueList.size(); ++k) {
            int index;
            String parmValue;
            Element valueElement = (Element)valueList.get(k);
            String sType = valueElement.attributeValue(CCLStartupConfiguration.qnXSIType);
            if (sType == null || sType.compareTo("cfg:folderPath") != 0 && sType.compareTo("cfg:filePath") != 0 || (parmValue = valueElement.getText()).length() <= 0 || (index = parmValue.indexOf("%")) == -1) continue;
            String sNewParmValue = CCLConfiguration2.replaceEnvVariables(parmValue);
            valueElement.setText(sNewParmValue);
        }
    }

    static void fixupPaths(Element element) {
        List valueList = CCLConfiguration2.getElementsByTagNameNS(element, "crn", "http://developer.cognos.com/schemas/crconfig/1/", "value");
        for (int k = 0; k < valueList.size(); ++k) {
            String pathValue;
            Element valueElement = (Element)valueList.get(k);
            String sType = valueElement.attributeValue(CCLStartupConfiguration.qnXSIType);
            if (sType == null || sType.compareTo("cfg:folderPath") != 0 && sType.compareTo("cfg:filePath") != 0 || (pathValue = valueElement.getText()).length() <= 0) continue;
            valueElement.setText(CCLConfigurationUtils.resolveEffectivePath(pathValue));
        }
    }

    static String replaceEnvVariables(String sParmValue) {
        if (sParmValue == null || sParmValue.indexOf("%") == -1) {
            return sParmValue;
        }
        String sNewParmValue = "";
        StringTokenizer sTokens = new StringTokenizer(sParmValue, "%", true);
        String startToken = sTokens.nextToken();
        String endToken = "";
        boolean bDoubleToken = false;
        while (startToken != "") {
            String midToken;
            if (!startToken.equalsIgnoreCase("%")) {
                sNewParmValue = sNewParmValue + startToken;
            } else if (sTokens.hasMoreTokens()) {
                String sValue = "";
                midToken = sTokens.nextToken();
                if (midToken.equalsIgnoreCase("%")) {
                    sNewParmValue = sNewParmValue + midToken;
                    bDoubleToken = true;
                } else {
                    sValue = midToken;
                    if (sTokens.hasMoreTokens()) {
                        endToken = sTokens.nextToken();
                        if (endToken.equalsIgnoreCase("%")) {
                            String sEnvVar = System.getenv(sValue);
                            sNewParmValue = sEnvVar != null ? sNewParmValue + sEnvVar : sNewParmValue + "%" + sValue + "%";
                        }
                    } else {
                        sNewParmValue = sNewParmValue + "%" + sValue;
                    }
                }
            } else {
                sNewParmValue = sNewParmValue + "%";
            }
            midToken = "";
            endToken = "";
            if (sTokens.hasMoreTokens() && !bDoubleToken) {
                startToken = sTokens.nextToken();
                continue;
            }
            if (sTokens.hasMoreTokens() && bDoubleToken) {
                startToken = "%";
                bDoubleToken = false;
                continue;
            }
            if (sTokens.hasMoreTokens()) continue;
            startToken = "";
        }
        return sNewParmValue;
    }

    private static List getElementsByTagNameNS(Element element, String sPrefix, String sNamespace, String sLocalName) {
        ArrayList list = new ArrayList();
        Namespace namespace = new Namespace(sPrefix, sNamespace);
        QName qName = new QName(sLocalName, namespace);
        CCLConfiguration2.getElementsByTagNameNSHelper(list, element, qName);
        return list;
    }

    private static void getElementsByTagNameNSHelper(List list, Element element, QName qName) {
        int size = element.nodeCount();
        for (int i = 0; i < size; ++i) {
            Node node = element.node(i);
            if (!(node instanceof Element)) continue;
            Element elem = (Element)node;
            if (elem.getQName().equals((Object)qName)) {
                list.add(elem);
            }
            CCLConfiguration2.getElementsByTagNameNSHelper(list, elem, qName);
        }
    }

    private static List getElementsByTagName(Element element, String sLocalName) {
        ArrayList list = new ArrayList();
        CCLConfiguration2.getElementsByTagNameHelper(list, element, sLocalName);
        return list;
    }

    private static void getElementsByTagNameHelper(List list, Element element, String sLocalName) {
        int size = element.nodeCount();
        for (int i = 0; i < size; ++i) {
            Node node = element.node(i);
            if (!(node instanceof Element)) continue;
            Element elem = (Element)node;
            if (elem.getName().equals(sLocalName)) {
                list.add(elem);
            }
            CCLConfiguration2.getElementsByTagNameHelper(list, elem, sLocalName);
        }
    }

    private static String decryptString(String encryptedBuffer, EncryptingSession es) throws CCLConfigurationException {
        if (encryptedBuffer.length() > 0) {
            byte[] decodedBuffer = null;
            try {
                decodedBuffer = base64.decode(0, encryptedBuffer);
                byte[] sDecryptedValue = es.decryptData(decodedBuffer);
                return new String(sDecryptedValue, "UTF-8");
            }
            catch (CAMCryptoException e) {
                throw new CCLConfigurationException(e.getMessage());
            }
            catch (Throwable e) {
                Object[] args = new Object[]{e.getMessage()};
                throw new CCLConfigurationException(8, args);
            }
        }
        return encryptedBuffer;
    }

    private static Element decryptXML(Element encryptedElement, EncryptingSession es) throws CCLConfigurationException {
        if (CCLConfiguration2.decryptLeafElement(encryptedElement, es)) {
            return encryptedElement;
        }
        return CCLConfiguration2.decryptXMLHelper(encryptedElement, es);
    }

    private static Element decryptXMLHelper(Element encryptedElement, EncryptingSession es) throws CCLConfigurationException {
        Iterator it = encryptedElement.elementIterator();
        while (it.hasNext()) {
            Element element;
            Node node = (Node)it.next();
            if (node.getNodeType() != 1 || CCLConfiguration2.decryptLeafElement(element = (Element)node, es)) continue;
            CCLConfiguration2.decryptXMLHelper(element, es);
        }
        return encryptedElement;
    }

    private static boolean decryptLeafElement(Element element, EncryptingSession es) throws CCLConfigurationException {
        Attribute encryptedAttr = element.attribute("encrypted");
        String type = element.attributeValue(CCLStartupConfiguration.qnXSIType);
        if (encryptedAttr != null && encryptedAttr.getText().compareToIgnoreCase("true") == 0 && type.compareTo("cfg:systemPassword") != 0 && element.isTextOnly() && element.nodeCount() > 0) {
            Text textNode;
            StringBuilder sText = new StringBuilder();
            ArrayList<Text> listOfTextNodes = new ArrayList<Text>();
            for (int i = 0; i < element.nodeCount(); ++i) {
                Node node2 = element.node(i);
                if (node2.getNodeType() != 3) continue;
                textNode = (Text)node2;
                listOfTextNodes.add(textNode);
                sText.append(textNode.getText());
            }
            String decryptedValue = CCLConfiguration2.decryptString(sText.toString(), es);
            if (null != decryptedValue) {
                encryptedAttr.getParent().remove(encryptedAttr);
                for (int j = 0; j < listOfTextNodes.size(); ++j) {
                    textNode = (Text)listOfTextNodes.get(j);
                    element.remove(textNode);
                }
                try {
                    Document docFragment = DocumentHelper.parseText((String)decryptedValue);
                    Element fragElement = docFragment.getRootElement();
                    fragElement.detach();
                    element.add(fragElement);
                }
                catch (DocumentException e) {
                    element.setText(decryptedValue);
                }
                return true;
            }
        }
        return false;
    }

    static {
        m_mutex = new Object();
    }
}

