<?xml version="1.0" encoding="UTF-8"?>
<!--
	Licensed Materials - Property of IBM

	IBM Cognos Products: cclmcf

	(C) Copyright IBM Corp. 2009, 2010

	US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<!-- copy all other elements -->
	<xsl:output method="xml" version="1.0" indent="yes" encoding="UTF-8"/>
	<!-- copy everything -->
	<xsl:template match="*|@*|text()|processing-instruction()">
		<xsl:copy>
			<xsl:apply-templates select="*|@*|text()|processing-instruction()"/>
			<xsl:if test="local-name()='supportedContentLocales'">
				<xsl:if test="not(./locale/@id='th')">
					<xsl:element name="locale">
						<xsl:attribute name="id">th</xsl:attribute>
					</xsl:element>
				</xsl:if>
				<xsl:if test="not(./locale/@id='th-th')">
					<xsl:element name="locale">
						<xsl:attribute name="id">th-th</xsl:attribute>
					</xsl:element>
				</xsl:if>
			</xsl:if>
			<xsl:if test="local-name()='supportedCurrencies'">
				<xsl:if test="not(./currency/@id='THB')">
					<xsl:element name="currency">
						<xsl:attribute name="id">THB</xsl:attribute>
					</xsl:element>
				</xsl:if>
			</xsl:if>
			<xsl:if test="local-name()='contentLocaleMap'">
				<xsl:if test="not(./localeMap/@key='th-*')">
					<xsl:element name="localeMap">
						<xsl:attribute name="key">th-*</xsl:attribute>
						<xsl:attribute name="value">th</xsl:attribute>
					</xsl:element>
				</xsl:if>
			</xsl:if>
		</xsl:copy>
	</xsl:template>
	<!-- update the version name of the root element of CRNLOCALE.XML -->
	<xsl:template match="/localeConfiguration">
		<xsl:element name="{name()}" namespace="{namespace-uri()}">
			<xsl:copy-of select="namespace::*"/>
			<xsl:copy-of select="@*"/>
			<xsl:attribute name="version">111.0</xsl:attribute>
			<xsl:apply-templates select="node()"/>
		</xsl:element>
	</xsl:template>
</xsl:stylesheet>
