<?xml version="1.0" encoding="UTF-8"?>
<!--
	Licensed Materials - Property of IBM

	IBM Cognos Products: cclmcf

	(C) Copyright IBM Corp. 2009, 2010

	US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<!-- copy all other elements -->
	<xsl:output method="xml" version="1.0" indent="yes" encoding="UTF-8"/>

	<!-- copy everything -->
	<xsl:template match="*|@*|text()|processing-instruction()">
		<xsl:copy>
			<xsl:apply-templates select="*|@*|text()|processing-instruction()"/>
		</xsl:copy>
	</xsl:template>

	<!-- DELETE localeConfiguration/supportedContentLocales/ all hindi locales -->
	<xsl:template match="/localeConfiguration/supportedContentLocales/locale[starts-with(@id,'hi')]"/>

	<!-- DELETE localeConfiguration/supportedProductLocales/ all hindi locales-->
	<xsl:template match="/localeConfiguration/supportedProductLocales/locale[starts-with(@id,'hi')]"/>

	<!-- DELETE localeConfiguration/contentLocaleMap/localeMap whose values start with hi -->
	<xsl:template match="/localeConfiguration/contentLocaleMap/localeMap[starts-with(@value,'hi')]"/>
	
	<!-- DELETE localeConfiguration/productLocaleMap/localeMap whose values start with hi -->
	<xsl:template match="/localeConfiguration/productLocaleMap/localeMap[starts-with(@value,'hi')]"/>
	
	<!-- update the version name of the root element of CRNLOCALE.XML -->
	<xsl:template match="/localeConfiguration">
		<xsl:element name="{name()}" namespace="{namespace-uri()}">
			<xsl:copy-of select="namespace::*"/>
			<xsl:copy-of select="@*"/>
			<xsl:attribute name="version">112.0</xsl:attribute>
			<xsl:apply-templates select="node()"/>
		</xsl:element>
	</xsl:template>
</xsl:stylesheet>
