<?xml version="1.0" encoding="UTF-8"?>
<!--
	Licensed Materials - Property of IBM

	IBM Cognos Products: cclmcf

	(C) Copyright IBM Corp. 2009, 2010

	US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<!-- copy all other elements -->
	<xsl:output method="xml" version="1.0" indent="yes" encoding="UTF-8"/>
	<!-- update the version name of the root element of CRNLOCALE.XML -->
	<xsl:template match="/localeConfiguration">
		<xsl:element name="{name()}" namespace="{namespace-uri()}">
			<xsl:copy-of select="namespace::*"/>
			<xsl:copy-of select="@*"/>
			<xsl:attribute name="version">113.0</xsl:attribute>
			<xsl:apply-templates select="node()"/>
		</xsl:element>
	</xsl:template>
	<!-- Add localeConfiguration/supportedCurrencies/new currentcies: 
		NOK Norway, krone
		SEK Sweden, krona
		IDR Indonesia, rupiah
		MYR Malaysia, ringgit 
	-->
	<xsl:template match="/localeConfiguration/supportedCurrencies">
		<xsl:copy>
			<xsl:copy-of select="@*"/>
			<xsl:apply-templates/>
			<!-- Add currency NOK-->
			<xsl:if test="not (/localeConfiguration/supportedCurrencies/currency[@id='NOK'])">
				<currency id="NOK"/>
			</xsl:if>
			<!-- Add currency SEK -->
			<xsl:if test="not (/localeConfiguration/supportedCurrencies/currency[@id='SEK'])">
				<currency id="SEK"/>
			</xsl:if>
			<!-- Add currency IDR-->
			<xsl:if test="not (/localeConfiguration/supportedCurrencies/currency[@id='IDR'])">
				<currency id="IDR"/>
			</xsl:if>
			<!-- Add currency MYR-->
			<xsl:if test="not (/localeConfiguration/supportedCurrencies/currency[@id='MYR'])">
				<currency id="MYR"/>
			</xsl:if>
		</xsl:copy>
	</xsl:template>
	<!-- copy everything -->
	<xsl:template match="*|@*|text()|processing-instruction()">
		<xsl:copy>
			<xsl:apply-templates select="*|@*|text()|processing-instruction()"/>
		</xsl:copy>
	</xsl:template>
</xsl:stylesheet>
