<?xml version="1.0" encoding="UTF-8"?>
<!--
	Licensed Materials - Property of IBM

	IBM Cognos Products: cclmcf

	(C) Copyright IBM Corp. 2009, 2010

	US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<!-- copy all other elements -->
	<xsl:output method="xml" version="1.0" indent="yes" encoding="UTF-8"/>
	<!-- update the version name of the root element of CRNLOCALE.XML -->
	<xsl:template match="/localeConfiguration">
		<xsl:element name="{name()}" namespace="{namespace-uri()}">
			<xsl:copy-of select="namespace::*"/>
			<xsl:copy-of select="@*"/>
			<xsl:attribute name="version">114.0</xsl:attribute>
			<xsl:apply-templates select="node()"/>
			<!-- Add cookie parameters-->
			<xsl:call-template name="addCookieParams"/>
		</xsl:element>
	</xsl:template>
	<!-- Add new parameters: cookieDomain, cookiePath and cookieSecure -->
	<xsl:template name="addCookieParams">
		<!-- Add parameter cookieDomain -->
		<xsl:if test="not (/localeConfiguration/*[local-name()='parameter' and @name='cookieDomain'])">
			<parameter name="cookieDomain">
				<value type="xsd:string"/>
			</parameter>
		</xsl:if>
		<!-- Add parameter cookiePath -->
		<xsl:if test="not (/localeConfiguration/*[local-name()='parameter' and @name='cookiePath'])">
			<parameter name="cookiePath">
				<value type="xsd:string">/</value>
			</parameter>
		</xsl:if>
		<!-- Add parameter cookieSecure-->
		<xsl:if test="not (/localeConfiguration/*[local-name()='parameter' and @name='cookieSecure'])">
			<parameter name="cookieSecure">
				<value type="xsd:boolean">false</value>
			</parameter>
		</xsl:if>
	</xsl:template>
	<!-- copy everything -->
	<xsl:template match="*|@*|text()|processing-instruction()">
		<xsl:copy>
			<xsl:apply-templates select="*|@*|text()|processing-instruction()"/>
		</xsl:copy>
	</xsl:template>
</xsl:stylesheet>
