<?xml version="1.0" encoding="UTF-8"?>
<!--
	Licensed Materials - Property of IBM

	IBM Cognos Products: cclmcf

	(C) Copyright IBM Corp. 2009, 2010

	US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<!-- copy all other elements -->
	<xsl:output method="xml" version="1.0" indent="yes" encoding="UTF-8"/>
	<!-- copy everything -->
	<xsl:template match="*|@*|text()|processing-instruction()">
		<xsl:copy>
			<xsl:apply-templates select="*|@*|text()|processing-instruction()"/>
			
			<!-- 	ADD Malaysia (ms), Indonesia (id) -->
			<xsl:if test="local-name()='supportedContentLocales'">
				<xsl:if test="not(./locale/@id='ms')">
					<xsl:element name="locale">
						<xsl:attribute name="id">ms</xsl:attribute>
					</xsl:element>
				</xsl:if>
				<xsl:if test="not(./locale/@id='ms-my')">
					<xsl:element name="locale">
						<xsl:attribute name="id">ms-my</xsl:attribute>
					</xsl:element>
				</xsl:if>
				<xsl:if test="not(./locale/@id='id')">
					<xsl:element name="locale">
						<xsl:attribute name="id">id</xsl:attribute>
					</xsl:element>
				</xsl:if>
				<xsl:if test="not(./locale/@id='id-id')">
					<xsl:element name="locale">
						<xsl:attribute name="id">id-id</xsl:attribute>
					</xsl:element>
				</xsl:if>
			</xsl:if>
			<xsl:if test="local-name()='contentLocaleMap'">
				<xsl:if test="not(./localeMap/@key='ms-*')">
					<xsl:element name="localeMap">
						<xsl:attribute name="key">ms-*</xsl:attribute>
						<xsl:attribute name="value">ms</xsl:attribute>
					</xsl:element>
				</xsl:if>
				<xsl:if test="not(./localeMap/@key='id-*')">
					<xsl:element name="localeMap">
						<xsl:attribute name="key">id-*</xsl:attribute>
						<xsl:attribute name="value">id</xsl:attribute>
					</xsl:element>
				</xsl:if>
			</xsl:if>
		</xsl:copy>
	</xsl:template>

	<!-- DELETE localeConfiguration/supportedContentLocales/ all Romamia locales -->
	<xsl:template match="/localeConfiguration/supportedContentLocales/locale[starts-with(@id,'ro')]"/>

	<!-- DELETE localeConfiguration/contentLocaleMap/localeMap whose values start with ro -->
	<xsl:template match="/localeConfiguration/contentLocaleMap/localeMap[starts-with(@value,'ro')]"/>

	<!-- DELETE localeConfiguration/supportedContentLocales/ all Slovakia locales -->
	<xsl:template match="/localeConfiguration/supportedContentLocales/locale[starts-with(@id,'sk')]"/>

	<!-- DELETE localeConfiguration/contentLocaleMap/localeMap whose values start with sk -->
	<xsl:template match="/localeConfiguration/contentLocaleMap/localeMap[starts-with(@value,'sk')]"/>

	<!-- DELETE localeConfiguration/supportedContentLocales/ all Turkey locales -->
	<xsl:template match="/localeConfiguration/supportedContentLocales/locale[starts-with(@id,'tr')]"/>

	<!-- DELETE localeConfiguration/contentLocaleMap/localeMap whose values start with tr -->
	<xsl:template match="/localeConfiguration/contentLocaleMap/localeMap[starts-with(@value,'tr')]"/>

	<!-- update the version name of the root element of CRNLOCALE.XML -->
	<xsl:template match="/localeConfiguration">
		<xsl:element name="{name()}" namespace="{namespace-uri()}">
			<xsl:copy-of select="namespace::*"/>
			<xsl:copy-of select="@*"/>
			<xsl:attribute name="version">117.0</xsl:attribute>
			<xsl:apply-templates select="node()"/>
		</xsl:element>
	</xsl:template>
</xsl:stylesheet>