<?xml version="1.0" encoding="UTF-8"?>
<!--
	Licensed Materials - Property of IBM

	IBM Cognos Products: cclmcf

	(C) Copyright IBM Corp. 2009, 2010

	US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<!-- copy all other elements -->
	<xsl:output method="xml" version="1.0" indent="yes" encoding="UTF-8"/>
	<!-- copy everything -->
	<xsl:template match="*|@*|text()|processing-instruction()">
		<xsl:copy>
			<xsl:apply-templates select="*|@*|text()|processing-instruction()"/>
			
			<!-- 	ADD new locales: Croatian(hr), Icelandic(is), Malaysia (ms-bn) -->
			<!--  Also add back locales: Romamia (ro), Slovakia (sk),  Turkey (tk)-->
			<xsl:if test="local-name()='supportedContentLocales'">
				<xsl:if test="not(./locale/@id='hr')">
					<xsl:element name="locale">
						<xsl:attribute name="id">hr</xsl:attribute>
					</xsl:element>
				</xsl:if>
				<xsl:if test="not(./locale/@id='hr-hr')">
					<xsl:element name="locale">
						<xsl:attribute name="id">hr-hr</xsl:attribute>
					</xsl:element>
				</xsl:if>
				<xsl:if test="not(./locale/@id='is')">
					<xsl:element name="locale">
						<xsl:attribute name="id">is</xsl:attribute>
					</xsl:element>
				</xsl:if>
				<xsl:if test="not(./locale/@id='is-is')">
					<xsl:element name="locale">
						<xsl:attribute name="id">is-is</xsl:attribute>
					</xsl:element>
				</xsl:if>
				<xsl:if test="not(./locale/@id='ms-bn')">
					<xsl:element name="locale">
						<xsl:attribute name="id">ms-bn</xsl:attribute>
					</xsl:element>
				</xsl:if>
				<xsl:if test="not(./locale/@id='ro')">
					<xsl:element name="locale">
						<xsl:attribute name="id">ro</xsl:attribute>
					</xsl:element>
				</xsl:if>
				<xsl:if test="not(./locale/@id='ro-ro')">
					<xsl:element name="locale">
						<xsl:attribute name="id">ro-ro</xsl:attribute>
					</xsl:element>
				</xsl:if>
				<xsl:if test="not(./locale/@id='sk')">
					<xsl:element name="locale">
						<xsl:attribute name="id">sk</xsl:attribute>
					</xsl:element>
				</xsl:if>
				<xsl:if test="not(./locale/@id='sk-sk')">
					<xsl:element name="locale">
						<xsl:attribute name="id">sk-sk</xsl:attribute>
					</xsl:element>
				</xsl:if>
				<xsl:if test="not(./locale/@id='tr')">
					<xsl:element name="locale">
						<xsl:attribute name="id">tr</xsl:attribute>
					</xsl:element>
				</xsl:if>
				<xsl:if test="not(./locale/@id='tr-tr')">
					<xsl:element name="locale">
						<xsl:attribute name="id">tr-tr</xsl:attribute>
					</xsl:element>
				</xsl:if>
			</xsl:if>
			<xsl:if test="local-name()='contentLocaleMap'">
				<xsl:if test="not(./localeMap/@key='hr-*')">
					<xsl:element name="localeMap">
						<xsl:attribute name="key">hr-*</xsl:attribute>
						<xsl:attribute name="value">hr</xsl:attribute>
					</xsl:element>
				</xsl:if>
				<xsl:if test="not(./localeMap/@key='is-*')">
					<xsl:element name="localeMap">
						<xsl:attribute name="key">is-*</xsl:attribute>
						<xsl:attribute name="value">is</xsl:attribute>
					</xsl:element>
				</xsl:if>
				<xsl:if test="not(./localeMap/@key='ro-*')">
					<xsl:element name="localeMap">
						<xsl:attribute name="key">ro-*</xsl:attribute>
						<xsl:attribute name="value">ro</xsl:attribute>
					</xsl:element>
				</xsl:if>
				<xsl:if test="not(./localeMap/@key='sk-*')">
					<xsl:element name="localeMap">
						<xsl:attribute name="key">sk-*</xsl:attribute>
						<xsl:attribute name="value">sk</xsl:attribute>
					</xsl:element>
				</xsl:if>
				<xsl:if test="not(./localeMap/@key='tr-*')">
					<xsl:element name="localeMap">
						<xsl:attribute name="key">tr-*</xsl:attribute>
						<xsl:attribute name="value">tr</xsl:attribute>
					</xsl:element>
				</xsl:if>
			</xsl:if>
		</xsl:copy>
	</xsl:template>
	
	<!-- update the version name of the root element of CRNLOCALE.XML -->
	<xsl:template match="/localeConfiguration">
		<xsl:element name="{name()}" namespace="{namespace-uri()}">
			<xsl:copy-of select="namespace::*"/>
			<xsl:copy-of select="@*"/>
			<xsl:attribute name="version">118.0</xsl:attribute>
			<xsl:apply-templates select="node()"/>
		</xsl:element>
	</xsl:template>
</xsl:stylesheet>