<?xml version="1.0" encoding="UTF-8"?>
<!--
	Licensed Materials - Property of IBM

	IBM Cognos Products: cclmcf

	(C) Copyright IBM Corp. 2009, 2010

	US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:crn="http://developer.cognos.com/schemas/crconfig/1/" xmlns:cfg="http://developer.cognos.com/schemas/configparams/XMLSchema/1/">
	<!-- copy all other elements -->
	<xsl:output method="xml" version="1.0" indent="yes" encoding="UTF-8"/>
	
	<!-- copy everything -->
	<xsl:template match="*|@*|text()|processing-instruction()">
		<xsl:copy><xsl:apply-templates select="*|@*|text()|processing-instruction()"/></xsl:copy>
	</xsl:template>

	<!-- update the version name of the root element of CRNLOCALE.XML -->
	<xsl:template match="/localeConfiguration">
		<xsl:element name="{name()}" namespace="{namespace-uri()}">
			<xsl:copy-of select="namespace::*"/>
			<xsl:copy-of select="@*"/>
			<xsl:attribute name="version">119.0</xsl:attribute>
			<xsl:apply-templates select="node()"/>
		</xsl:element>
	</xsl:template>

<!-- Add localeConfiguration/supportedFonts/new fonts: 
		Courier-PDF, Helvetica-PDF
	    Symbol-PDF, Times-PDF, ZapfDingbats-PDF
	-->
	<xsl:template match="/localeConfiguration/supportedFonts">
		<xsl:copy>
			<xsl:copy-of select="@*"/>
			<xsl:apply-templates/>
			<!-- Add font Courier-PDF -->
			<xsl:if test="not (/localeConfiguration/supportedFonts/font[@id='Courier-PDF'])">
				<font id="Courier-PDF"/>
			</xsl:if>
			<!-- Add font Helvetica-PDF -->
			<xsl:if test="not (/localeConfiguration/supportedFonts/font[@id='Helvetica-PDF'])">
				<font id="Helvetica-PDF"/>
			</xsl:if>
			<!-- Add font Symbol-PDF -->
			<xsl:if test="not (/localeConfiguration/supportedFonts/font[@id='Symbol-PDF'])">
				<font id="Symbol-PDF"/>
			</xsl:if>
			<!-- Add font Times-PDF -->
			<xsl:if test="not (/localeConfiguration/supportedFonts/font[@id='Times-PDF'])">
				<font id="Times-PDF"/>
			</xsl:if>
			<!-- Add font ZapfDingbats-PDF -->
			<xsl:if test="not (/localeConfiguration/supportedFonts/font[@id='ZapfDingbats-PDF'])">
				<font id="ZapfDingbats-PDF"/>
			</xsl:if>
		</xsl:copy>
	</xsl:template>

</xsl:stylesheet>
