<?xml version="1.0" encoding="UTF-8"?>
<!--
	Licensed Materials - Property of IBM

	IBM Cognos Products: cclmcf

	(C) Copyright IBM Corp. 2009, 2010

	US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<!-- copy all other elements -->
	<xsl:output method="xml" version="1.0" indent="yes" encoding="UTF-8"/>
	<!-- copy everything -->
	<xsl:template match="*|@*|text()|processing-instruction()">
		<xsl:copy>
			<xsl:apply-templates select="*|@*|text()|processing-instruction()"/>
			
			<!-- 	ADD new locales: Spanish (es), Finnish (fi), Italian (it), Korean (ko), Dutch (nl), Portuguese (pt), Swedish (sv), Russian (ru), Chinese Traditional (zh-cn), Chinese Simplified (zh-tw) -->
			<xsl:if test="local-name()='supportedProductLocales'">
				<xsl:if test="not(./locale/@id='es')">
					<xsl:element name="locale">
						<xsl:attribute name="id">es</xsl:attribute>
					</xsl:element>
				</xsl:if>
				<xsl:if test="not(./locale/@id='fi')">
					<xsl:element name="locale">
						<xsl:attribute name="id">fi</xsl:attribute>
					</xsl:element>
				</xsl:if>
				<xsl:if test="not(./locale/@id='it')">
					<xsl:element name="locale">
						<xsl:attribute name="id">it</xsl:attribute>
					</xsl:element>
				</xsl:if>
				<xsl:if test="not(./locale/@id='ko')">
					<xsl:element name="locale">
						<xsl:attribute name="id">ko</xsl:attribute>
					</xsl:element>
				</xsl:if>
				<xsl:if test="not(./locale/@id='nl')">
					<xsl:element name="locale">
						<xsl:attribute name="id">nl</xsl:attribute>
					</xsl:element>
				</xsl:if>
				<xsl:if test="not(./locale/@id='pt')">
					<xsl:element name="locale">
						<xsl:attribute name="id">pt</xsl:attribute>
					</xsl:element>
				</xsl:if>
				<xsl:if test="not(./locale/@id='sv')">
					<xsl:element name="locale">
						<xsl:attribute name="id">sv</xsl:attribute>
					</xsl:element>
				</xsl:if>
				<xsl:if test="not(./locale/@id='ru')">
					<xsl:element name="locale">
						<xsl:attribute name="id">ru</xsl:attribute>
					</xsl:element>
				</xsl:if>
				<xsl:if test="not(./locale/@id='zh-cn')">
					<xsl:element name="locale">
						<xsl:attribute name="id">zh-cn</xsl:attribute>
					</xsl:element>
				</xsl:if>
				<xsl:if test="not(./locale/@id='zh-tw')">
					<xsl:element name="locale">
						<xsl:attribute name="id">zh-tw</xsl:attribute>
					</xsl:element>
				</xsl:if>
			</xsl:if>

			
		</xsl:copy>
	</xsl:template>
	
	<!-- update the version name of the root element of CRNLOCALE.XML -->
	<xsl:template match="/localeConfiguration">
		<xsl:element name="{name()}" namespace="{namespace-uri()}">
			<xsl:copy-of select="namespace::*"/>
			<xsl:copy-of select="@*"/>
			<xsl:attribute name="version">120.0</xsl:attribute>
			<xsl:apply-templates select="node()"/>
		</xsl:element>
	</xsl:template>
	
		<!-- Add localeConfiguration/supportedCurrencies/new currentcies: TWD Taiwan, dollar -->
	<xsl:template match="/localeConfiguration/supportedCurrencies">
		<xsl:copy>
			<xsl:copy-of select="@*"/>
			<xsl:apply-templates/>
			<xsl:if test="not (/localeConfiguration/supportedCurrencies/currency[@id='TWD'])">
				<currency id="TWD"/>
			</xsl:if>
		</xsl:copy>
	</xsl:template>
	
	
</xsl:stylesheet>