<?xml version="1.0" encoding="UTF-8"?>
<!--
	Licensed Materials - Property of IBM
	IBM Cognos Products: cclmcf
	(C) Copyright IBM Corp. 2009, 2010
	US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<!-- copy all other elements -->
	<xsl:output method="xml" version="1.0" indent="yes" encoding="UTF-8"/>
	<!-- copy everything -->
	<xsl:template match="*|@*|text()|processing-instruction()">
		<xsl:copy>
			<xsl:apply-templates select="*|@*|text()|processing-instruction()"/>
			
			<!-- 	ADD new locales: Turkish (tr), Romanian (ro), Polish (pl), Czech (cs), Hungarian (hu) -->
			<xsl:if test="local-name()='productLocaleMap'">
				<xsl:if test="not(./localeMap/@key='cs-*')">
					<xsl:element name="localeMap">
						<xsl:attribute name="key">cs-*</xsl:attribute>
						<xsl:attribute name="value">cs</xsl:attribute>
					</xsl:element>
				</xsl:if>
				<xsl:if test="not(./localeMap/@key='hu-*')">
					<xsl:element name="localeMap">
						<xsl:attribute name="key">hu-*</xsl:attribute>
						<xsl:attribute name="value">hu</xsl:attribute>
					</xsl:element>
				</xsl:if>
				<xsl:if test="not(./localeMap/@key='pl-*')">
					<xsl:element name="localeMap">
						<xsl:attribute name="key">pl-*</xsl:attribute>
						<xsl:attribute name="value">pl</xsl:attribute>
					</xsl:element>
				</xsl:if>
				<xsl:if test="not(./localeMap/@key='ro-*')">
					<xsl:element name="localeMap">
						<xsl:attribute name="key">ro-*</xsl:attribute>
						<xsl:attribute name="value">ro</xsl:attribute>
					</xsl:element>
				</xsl:if>
				<xsl:if test="not(./localeMap/@key='tr-*')">
					<xsl:element name="localeMap">
						<xsl:attribute name="key">tr-*</xsl:attribute>
						<xsl:attribute name="value">tr</xsl:attribute>
					</xsl:element>
				</xsl:if>
			</xsl:if>
		</xsl:copy>
	</xsl:template>
	
	<!-- update the version name of the root element of CRNLOCALE.XML -->
	<xsl:template match="/localeConfiguration">
		<xsl:element name="{name()}" namespace="{namespace-uri()}">
			<xsl:copy-of select="namespace::*"/>
			<xsl:copy-of select="@*"/>
			<xsl:attribute name="version">122.0</xsl:attribute>
			<xsl:apply-templates select="node()"/>
		</xsl:element>
	</xsl:template>
	
</xsl:stylesheet>