<?xml version="1.0" encoding="UTF-8"?>
<!--
	Licensed Materials - Property of IBM

	IBM Cognos Products: cclmcf

	(C) Copyright IBM Corp. 2009, 2020

	US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:crn="http://developer.cognos.com/schemas/crconfig/1/" xmlns:cfg="http://developer.cognos.com/schemas/configparams/XMLSchema/1/">
	<!-- copy all other elements -->
	<xsl:output method="xml" version="1.0" indent="yes" encoding="UTF-8"/>
	
	<!-- copy everything -->
	<xsl:template match="*|@*|text()|processing-instruction()">
		<xsl:copy><xsl:apply-templates select="*|@*|text()|processing-instruction()"/></xsl:copy>
	</xsl:template>

	<!-- update the version name of the root element of CRNLOCALE.XML -->
	<xsl:template match="/localeConfiguration">
		<xsl:element name="{name()}" namespace="{namespace-uri()}">
			<xsl:copy-of select="namespace::*"/>
			<xsl:copy-of select="@*"/>
			<xsl:attribute name="version">126.0</xsl:attribute>
			<xsl:apply-templates select="node()"/>
		</xsl:element>
	</xsl:template>

    <!-- Add new font "IBM Plex Sans" to localeConfiguration/supportedFonts/ -->
	<xsl:template match="/localeConfiguration/supportedFonts">
		<xsl:copy>
			<xsl:copy-of select="@*"/>
			<xsl:apply-templates/>
			<!-- Add font IBM Plex Sans -->
			<xsl:if test="not (/localeConfiguration/supportedFonts/font[@id='IBM Plex Sans'])">
				<font id="IBM Plex Sans"/>
			</xsl:if>
		</xsl:copy>
	</xsl:template>

</xsl:stylesheet>
