<?xml version="1.0" encoding="UTF-8"?>
<!--
	Licensed Materials - Property of IBM

	IBM Cognos Products: cclmcf

	(C) Copyright IBM Corp. 2009, 2010

	US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:crn="http://developer.cognos.com/schemas/crconfig/1/" xmlns:cfg="http://developer.cognos.com/schemas/configparams/XMLSchema/1/">
	<!-- copy all other elements -->
	<xsl:output method="xml" version="1.0" indent="yes" encoding="UTF-8"/>
	
	<!-- copy everything -->
	<xsl:template match="*|@*|text()|processing-instruction()">
		<xsl:copy><xsl:apply-templates select="*|@*|text()|processing-instruction()"/></xsl:copy>
	</xsl:template>

	<!-- update the version name of the root element of CRNLOCALE.XML -->
	<xsl:template match="/localeConfiguration">
		<xsl:element name="{name()}" namespace="{namespace-uri()}">
			<xsl:copy-of select="namespace::*"/>
			<xsl:copy-of select="@*"/>
			<xsl:attribute name="version">19.0</xsl:attribute>
			<xsl:apply-templates select="node()"/>
		</xsl:element>
	</xsl:template>

	<!-- ADD NEW ELEMENTS TO: localeConfiguration -->
	<xsl:template match="/localeConfiguration/child::*[position() = 1]">
		<xsl:copy-of select="."></xsl:copy-of>
		
		<!-- ADD supportedFonts -->
		<xsl:variable name="supportedFontsExists" select="name(../supportedFonts)"/>
		<xsl:if test="$supportedFontsExists != 'supportedFonts'">
			<xsl:element name="supportedFonts">
				<xsl:element name="font"><xsl:attribute name="id">Andale mono</xsl:attribute></xsl:element>
				<xsl:element name="font"><xsl:attribute name="id">Andale WT</xsl:attribute></xsl:element>
				<xsl:element name="font"><xsl:attribute name="id">Arabic Transparent</xsl:attribute></xsl:element>
				<xsl:element name="font"><xsl:attribute name="id">Arial</xsl:attribute></xsl:element>
				<xsl:element name="font"><xsl:attribute name="id">Arial Black</xsl:attribute></xsl:element>
				<xsl:element name="font"><xsl:attribute name="id">Arial Unicode MS</xsl:attribute></xsl:element>
				<xsl:element name="font"><xsl:attribute name="id">Comic Sans MS</xsl:attribute></xsl:element>
				<xsl:element name="font"><xsl:attribute name="id">CordiaUPC</xsl:attribute></xsl:element>
				<xsl:element name="font"><xsl:attribute name="id">Courier New</xsl:attribute></xsl:element>
				<xsl:element name="font"><xsl:attribute name="id">Georgia</xsl:attribute></xsl:element>
				<xsl:element name="font"><xsl:attribute name="id">Gulim</xsl:attribute></xsl:element>
				<xsl:element name="font"><xsl:attribute name="id">Gulimche</xsl:attribute></xsl:element>
				<xsl:element name="font"><xsl:attribute name="id">Helvetica</xsl:attribute></xsl:element>
				<xsl:element name="font"><xsl:attribute name="id">Impact</xsl:attribute></xsl:element>
				<xsl:element name="font"><xsl:attribute name="id">MinLiU</xsl:attribute></xsl:element>
				<xsl:element name="font"><xsl:attribute name="id">Miriam</xsl:attribute></xsl:element>
				<xsl:element name="font"><xsl:attribute name="id">Miriam Fixed</xsl:attribute></xsl:element>
				<xsl:element name="font"><xsl:attribute name="id">Miriam Transparent</xsl:attribute></xsl:element>
				<xsl:element name="font"><xsl:attribute name="id">MS Gothic</xsl:attribute></xsl:element>
				<xsl:element name="font"><xsl:attribute name="id">MS Mincho</xsl:attribute></xsl:element>
				<xsl:element name="font"><xsl:attribute name="id">MS PGothic</xsl:attribute></xsl:element>
				<xsl:element name="font"><xsl:attribute name="id">MS UI Gothic</xsl:attribute></xsl:element>
				<xsl:element name="font"><xsl:attribute name="id">NSimSun</xsl:attribute></xsl:element>
				<xsl:element name="font"><xsl:attribute name="id">NSimSun-18030</xsl:attribute></xsl:element>
				<xsl:element name="font"><xsl:attribute name="id">PMingLiU</xsl:attribute></xsl:element>
				<xsl:element name="font"><xsl:attribute name="id">Raghu8</xsl:attribute></xsl:element>
				<xsl:element name="font"><xsl:attribute name="id">Simplified Arabic</xsl:attribute></xsl:element>
				<xsl:element name="font"><xsl:attribute name="id">Simplified Arabic Fixed</xsl:attribute></xsl:element>
				<xsl:element name="font"><xsl:attribute name="id">SimSun</xsl:attribute></xsl:element>
				<xsl:element name="font"><xsl:attribute name="id">Tahoma</xsl:attribute></xsl:element>
				<xsl:element name="font"><xsl:attribute name="id">Times New Roman</xsl:attribute></xsl:element>
				<xsl:element name="font"><xsl:attribute name="id">Trebuchet MS</xsl:attribute></xsl:element>
				<xsl:element name="font"><xsl:attribute name="id">Verdana</xsl:attribute></xsl:element>
				<xsl:element name="font"><xsl:attribute name="id">Webdings</xsl:attribute></xsl:element>
			</xsl:element>
		</xsl:if>

		<!-- ADD fontsMap -->
		<xsl:variable name="fontsMapExists" select="name(../fontsMap)"/>
		<xsl:if test="$fontsMapExists != 'fontsMap'">
			<xsl:element name="fontsMap"/>
		</xsl:if>
	</xsl:template>
	
</xsl:stylesheet>
