<?xml version="1.0" encoding="UTF-8"?>
<!--
	Licensed Materials - Property of IBM

	IBM Cognos Products: cclmcf

	(C) Copyright IBM Corp. 2009, 2010

	US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:crn="http://developer.cognos.com/schemas/crconfig/1/" xmlns:cfg="http://developer.cognos.com/schemas/configparams/XMLSchema/1/">
	<!-- copy all other elements -->
	<xsl:output method="xml" version="1.0" indent="yes" encoding="UTF-8"/>
	<!-- update the version name of the root element of CRNSTARTUP.XML -->
	<xsl:template match="/crn:parameters">
		<xsl:copy>
			<xsl:copy-of select="@*"/>
			<xsl:attribute name="version">102.0</xsl:attribute>
			<xsl:apply-templates/>
		</xsl:copy>
	</xsl:template>
	<!-- ADD NEW ELEMENTS TO: AAA/instances -->
	<xsl:template match="crn:parameter[@name = 'AAA']/crn:value/crn:instances[@name = 'authProvider']/crn:instance[@class = 'SAP']">
		<xsl:copy>
			<xsl:copy-of select="@*"/>
			<xsl:apply-templates/>
			<!-- ADD codepage -->
			<xsl:if test="not(./crn:parameter[@name='codepage'])">
				<crn:parameter name="codepage">
					<crn:value xsi:type="xsd:string">1100</crn:value>
				</crn:parameter>
			</xsl:if>
		</xsl:copy>
	</xsl:template>
	<!-- copy everything -->
	<xsl:template match="*|@*|text()|processing-instruction()">
		<xsl:copy>
			<xsl:apply-templates select="*|@*|text()|processing-instruction()"/>
		</xsl:copy>
	</xsl:template>
</xsl:stylesheet>
