<?xml version="1.0" encoding="UTF-8"?>
<!--
	Licensed Materials - Property of IBM

	IBM Cognos Products: cclmcf

	(C) Copyright IBM Corp. 2009, 2010

	US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:crn="http://developer.cognos.com/schemas/crconfig/1/" xmlns:cfg="http://developer.cognos.com/schemas/configparams/XMLSchema/1/">
	<!-- copy all other elements -->
	<xsl:output method="xml" version="1.0" indent="yes" encoding="UTF-8"/>
	<!-- update the version name of the root element of CRNSTARTUP.XML -->
	<xsl:template match="/crn:parameters">
		<xsl:copy>
			<xsl:copy-of select="@*"/>
			<xsl:attribute name="version">104.0</xsl:attribute>
			<xsl:apply-templates/>
			<xsl:if test="not(./crn:parameter[@name='CPS'])">
				<xsl:call-template name="addCPS"/>
			</xsl:if>
		</xsl:copy>
	</xsl:template>
	<!-- ADD NEW ELEMENT: CPS -->
	<xsl:template name="addCPS">
		<!-- ADD CPS -->
		<crn:parameter name="CPS" opaque="true">
			<crn:value>
				<!-- ADD webcontent -->
				<crn:parameter 	name="webcontent">
					<crn:value 	xsi:type="xsd:anyURI">				
						<!-- if the gateway URI has "/cgi-bin" in it then make the part of the gatway URI in fornt of "/cgi-bin" the default value for this parameter
						otherwise the default value is "http://localhost:80/crn"-->
						<xsl:variable name="cpsWebcontentURI">
							<xsl:value-of select="substring-before(/crn:parameters/crn:parameter[@name='gateway']/crn:value, '/cgi-bin')"/>
						</xsl:variable>
						<xsl:choose>
							<xsl:when test="string-length($cpsWebcontentURI)=0">
								<xsl:text>http://localhost:80/crn</xsl:text>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="$cpsWebcontentURI"/>
							</xsl:otherwise>
						</xsl:choose>
					</crn:value>
				</crn:parameter>		

				<!-- ADD applications -->
				<crn:parameter 	name="applications">
					<crn:value 	xsi:type="xsd:string">
						<!-- if the SDK URI has "/p2pd" in it then make the part of the SDK URI in fornt of "/p2pd" + "samples/cps2/applications.xml" the default value for this parameter
						otherwise the default value is "http://localhost:9300/samples/cps2/applications.xml"-->
						<xsl:variable name="cpsAppliactionsURI">
							<xsl:value-of select="substring-before(/crn:parameters/crn:parameter[@name='sdk']/crn:value, '/p2pd')"/>
						</xsl:variable>
						<xsl:choose>
							<xsl:when test="string-length($cpsAppliactionsURI)=0">
								<xsl:text>http://localhost:9300/samples/cps2/applications.xml</xsl:text>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="concat($cpsAppliactionsURI, '/samples/cps2/applications.xml')"/>
							</xsl:otherwise>
						</xsl:choose>
					</crn:value>
				</crn:parameter>

				<!-- ADD cps_authMethod -->
				<crn:parameter 	name="cps_authMethod">
					<crn:value 	xsi:type="xsd:string">sso</crn:value>
				</crn:parameter>

				<!-- ADD cps_namespace -->
				<crn:parameter 	name="cps_namespace">
					<crn:value 	xsi:type="xsd:string"/>
				</crn:parameter>

				<!-- ADD cps_username -->
				<crn:parameter 	name="cps_username">
					<crn:value 	xsi:type="xsd:string"/>
				</crn:parameter>

				<!-- ADD cps_password -->
				<crn:parameter 	name="cps_password">
					<crn:value 	xsi:type="xsd:string"/>
				</crn:parameter>
			</crn:value>		
		</crn:parameter>
	</xsl:template>

	<!-- copy everything -->
	<xsl:template match="*|@*|text()|processing-instruction()">
		<xsl:copy>
			<xsl:apply-templates select="*|@*|text()|processing-instruction()"/>
		</xsl:copy>
	</xsl:template>
</xsl:stylesheet>
