<?xml version="1.0" encoding="UTF-8"?>
<!--
	Licensed Materials - Property of IBM

	IBM Cognos Products: cclmcf

	(C) Copyright IBM Corp. 2009, 2010

	US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:crn="http://developer.cognos.com/schemas/crconfig/1/" xmlns:cfg="http://developer.cognos.com/schemas/configparams/XMLSchema/1/">
	<!-- copy all other elements -->
	<xsl:output method="xml" version="1.0" indent="yes" encoding="UTF-8"/>
	<!-- update the version name of the root element of CRNSTARTUP.XML -->
	<xsl:template match="/crn:parameters">
		<xsl:copy>
			<xsl:copy-of select="@*"/>
			<xsl:attribute name="version">109.0</xsl:attribute>
			<xsl:apply-templates/>
			<xsl:if test="not(./crn:parameter[@name='contentManagers'])">
				<xsl:call-template name="addCMs"/>
			</xsl:if>
		</xsl:copy>
	</xsl:template>
	<!-- Add a new parameter "contentManagers" -->
	<xsl:template name="addCMs">
		<xsl:variable name="cmuri">
			<xsl:choose>
				<xsl:when test="/crn:parameters/crn:parameter[@name = 'contentManager']">
					<xsl:value-of select="/crn:parameters/crn:parameter[@name = 'contentManager']/crn:value"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="'http://localhost:9300/p2pd/servlet'"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<crn:parameter opaque="true" name="contentManagers">
			<crn:value xsi:type="cfg:array">
				<crn:item xsi:type="xsd:anyURI"><xsl:value-of select="$cmuri"/></crn:item>
			</crn:value>
		</crn:parameter>
	</xsl:template>
	<!-- ADD a new parameter 'bindCredentials' to: AAA/authProvider/ActiveDirectory -->
	<xsl:template match="/crn:parameters/crn:parameter[@name = 'AAA']/crn:value/crn:instances[@name = 'authProvider']/crn:instance[@class = 'ActiveDirectory']/child::*[position() = 1]">
		<xsl:copy-of select="."> </xsl:copy-of>
		<!-- ADD bindCredentials -->
		<xsl:if test="not (../crn:parameter[@name='bindCredentials'])">
			<crn:parameter name="bindCredentials">
				<crn:value xsi:type="cfg:credential">
					<credential>
						<username/>
						<password/>
					</credential>
				</crn:value>
			</crn:parameter>
		</xsl:if>
	</xsl:template>
	<!-- copy everything -->
	<xsl:template match="*|@*|text()|processing-instruction()">
		<xsl:copy>
			<xsl:apply-templates select="*|@*|text()|processing-instruction()"/>
		</xsl:copy>
	</xsl:template>
</xsl:stylesheet>
